/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTrigger;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

public class Oracle11gTrigger
extends AbstractOracleTrigger {
    private String editionable;

    public Oracle11gTrigger(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        DbType originType = this.getOriginDbType();
        if (!originType.isOracleType()) {
            throw new UnsupportedGrammarException(this.getSchemaObjectName(), "Origin dbType is not allowed to convert to ORACLE trigger: " + originType);
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isFullText()) {
            sb.append("CREATE OR REPLACE ");
            if ("N".equals(this.getEditionable())) {
                sb.append("NONEDITIONABLE ");
            }
        }
        sb.append(this.getText());
        String status = this.getStatus();
        CreateObjectDefine define = new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), this.terminate(sb));
        if ("DISABLED".equalsIgnoreCase(status)) {
            ChangeUtils.info(ObjectType.TRIGGER, this.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, sb + " -> [NULL]");
            define = new CreateObjectDefine(ObjectType.TRIGGER, this.getSimpleObjectName(), "");
            define.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TRIGGER, this.getSchemaObjectName()));
            return Lists.newArrayList((Object[])new ObjectDefine[]{define});
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{define});
    }

    @Override
    public String delimit(CharSequence ch) {
        return String.valueOf(ch);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTrigger other) {
        if (!(other instanceof Oracle11gTrigger)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getEditionable() {
        return this.editionable;
    }

    public void setEditionable(String editionable) {
        this.editionable = editionable;
    }
}

