/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.oracle11g;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleView;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gColumn;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gUniqueKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oracle11gView
extends AbstractOracleView {
    private Oracle11gPrimaryKey primaryKey;
    private Integer typeTextLength;
    private String typeText;
    private String viewTypeOwner;
    private String editionable;
    private final Map<String, Oracle11gColumn> columnMapping = new LinkedHashMap<String, Oracle11gColumn>();
    private final Map<String, Oracle11gUniqueKey> uniqueMapping = new LinkedHashMap<String, Oracle11gUniqueKey>();

    public Oracle11gView(Oracle11gSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE");
        if ("Y".equals(this.getEditionable())) {
            sb.append(" EDITIONABLE");
        } else if ("N".equals(this.getEditionable())) {
            sb.append(" NONEDITIONABLE");
        }
        if ("Y".equals(this.getEditioningView())) {
            sb.append(" EDITIONING");
        }
        sb.append(" VIEW ").append(this.getDefinitionSchemaObjectName());
        Collection<Oracle11gColumn> columns = this.getColumnMapping().values();
        if (CollectionUtils.isNotEmpty(columns)) {
            sb.append(" (");
            Iterator<Oracle11gColumn> iter1 = columns.iterator();
            while (iter1.hasNext()) {
                Oracle11gColumn column = iter1.next();
                sb.append("\n\t").append(this.wrapAndCase(column.getColumnName(), "columnCase"));
                if ("YES".equals(column.getHiddenColumn())) {
                    sb.append(" INVISIBLE");
                }
                if (!iter1.hasNext()) continue;
                sb.append(",");
            }
            Oracle11gPrimaryKey primaryKey = this.getPrimaryKey();
            if (primaryKey != null) {
                sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
            }
            Iterator<Oracle11gUniqueKey> iter2 = this.getUniqueMapping().values().iterator();
            while (iter2.hasNext()) {
                sb.append(",").append("\n\t").append((CharSequence)iter2.next().buildGrammar());
            }
            sb.append(")");
        }
        sb.append(" AS").append("\n").append(this.getText());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), sb.toString())});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractView other) {
        if (!(other instanceof Oracle11gView)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Oracle11gPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Oracle11gPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Integer getTypeTextLength() {
        return this.typeTextLength;
    }

    public void setTypeTextLength(Integer typeTextLength) {
        this.typeTextLength = typeTextLength;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    public String getViewTypeOwner() {
        return this.viewTypeOwner;
    }

    public void setViewTypeOwner(String viewTypeOwner) {
        this.viewTypeOwner = viewTypeOwner;
    }

    public String getEditionable() {
        return this.editionable;
    }

    public void setEditionable(String editionable) {
        this.editionable = editionable;
    }

    public Map<String, Oracle11gColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, Oracle11gUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }
}

