/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSequence;
import java.util.List;
import java.util.Locale;

public class PostgresColumn
extends AbstractColumn {
    private Integer characterMaximumLength;
    private Integer characterOctetLength;
    private Integer numericPrecision;
    private Integer numericPrecisionRadix;
    private Integer numericScale;
    private Integer datetimePrecision;
    private String intervalType;
    private String intervalPrecision;
    private String characterSetCatalog;
    private String characterSetSchema;
    private String characterSetName;
    private String collationCatalog;
    private String collationSchema;
    private String collationName;
    private String domainCatalog;
    private String domainSchema;
    private String domainName;
    private String udtCatalog;
    private String udtSchema;
    private String udtName;
    private String scopeCatalog;
    private String scopeSchema;
    private String scopeName;
    private String maximumCardinality;
    private String dtdIdentifier;
    private String isSelfReferencing;
    private String isIdentity;
    private String identityGeneration;
    private PostgresSequence identityExpr;
    private String isGenerated;
    private String generationExpression;
    private String isUpdatable;
    private String gisType;
    private Integer srid;
    private Integer coordDimension;
    private PostgresSequence sequence;

    public PostgresColumn(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String dataType;
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("DataType is null");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getGrammarColumnName()).append(" ");
        String columnDefault = this.getColumnDefault();
        String sysGenSeqName = "nextval('" + this.getOriginSchemaName() + "." + this.getObjectName() + "_" + this.getColumnName() + "_seq'::regclass)";
        boolean isSerialType = sysGenSeqName.equals(columnDefault);
        switch (dataType = this.getDataType().toUpperCase(Locale.getDefault())) {
            case "BIT": 
            case "BIT VARYING": 
            case "CHARACTER": 
            case "CHARACTER VARYING": {
                sb.append(dataType);
                Integer len = this.getCharacterMaximumLength();
                if (len <= 0) break;
                sb.append("(").append(len).append(")");
                break;
            }
            case "NUMERIC": {
                sb.append(dataType);
                Integer percision = this.getNumericPrecision();
                Integer scale = this.getNumericScale();
                if (percision <= 0) break;
                sb.append("(").append(percision);
                if (scale > 0) {
                    sb.append(", ").append(scale);
                }
                sb.append(")");
                break;
            }
            case "TIME WITHOUT TIME ZONE": 
            case "TIMESTAMP WITHOUT TIME ZONE": {
                sb.append(dataType.replace(" without time zone", ""));
                Integer precision = this.getDatetimePrecision();
                if (precision <= 0 || precision == 6) break;
                sb.append("(").append(precision).append(")");
                break;
            }
            case "TIME WITH TIME ZONE": 
            case "TIMESTAMP WITH TIME ZONE": {
                Integer precision = this.getDatetimePrecision();
                if (precision > 0 && precision != 6) {
                    sb.append(dataType.replace(" with", "(" + precision + ") with"));
                    break;
                }
                sb.append(dataType);
                break;
            }
            default: {
                if (isSerialType && "SMALLINT".equalsIgnoreCase(dataType)) {
                    dataType = "SMALLSERIAL";
                } else if (isSerialType && "INTEGER".equalsIgnoreCase(dataType)) {
                    dataType = "SERIAL";
                } else if (isSerialType && "BIGINT".equalsIgnoreCase(dataType)) {
                    dataType = "BIGSERIAL";
                }
                String gisType = this.getGisType();
                if (StringUtils.isNotBlank((CharSequence)gisType)) {
                    Integer coordDimension = this.getCoordDimension();
                    if (coordDimension != null) {
                        if (coordDimension == 3) {
                            dataType = dataType + "Z";
                        } else if (coordDimension == 4) {
                            dataType = dataType + "ZM";
                        }
                    }
                    if ("GEOMETRY".equals(dataType)) {
                        dataType = gisType;
                    } else {
                        dataType = gisType + "(" + dataType;
                        Integer srid = this.getSrid();
                        if (srid != null && (gisType.equals("GEOMETRY") && srid != 0 || gisType.equals("GEOGRAPHY") && srid != 4326)) {
                            dataType = dataType + "," + srid;
                        }
                        dataType = dataType + ")";
                    }
                }
                sb.append(dataType);
            }
        }
        if ("NO".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        if (columnDefault != null && !isSerialType) {
            sb.append(" DEFAULT ").append(columnDefault.replace("::bpchar", ""));
        }
        String identityGen = this.getIdentityGeneration();
        if ("YES".equals(this.getIsIdentity()) && StringUtils.isNotBlank((CharSequence)identityGen)) {
            sb.append(" GENERATED ").append(identityGen);
            sb.append((CharSequence)this.getIdentityExpr().buildIdentityGrammar());
        }
        if (DbType.PGSQL_12.isPriorFrom(this.getDbType())) {
            String genExpr = this.getGenerationExpression();
            if ("ALWAYS".equals(this.getIsGenerated()) && StringUtils.isNotBlank((CharSequence)genExpr)) {
                sb.append(" GENERATED ALWAYS AS ").append(genExpr).append(" STORED");
            }
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof PostgresColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Integer getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public void setCharacterMaximumLength(Integer characterMaximumLength) {
        this.characterMaximumLength = characterMaximumLength;
    }

    public Integer getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(Integer characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public Integer getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(Integer numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public Integer getNumericPrecisionRadix() {
        return this.numericPrecisionRadix;
    }

    public void setNumericPrecisionRadix(Integer numericPrecisionRadix) {
        this.numericPrecisionRadix = numericPrecisionRadix;
    }

    public Integer getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(Integer numericScale) {
        this.numericScale = numericScale;
    }

    public Integer getDatetimePrecision() {
        return this.datetimePrecision;
    }

    public void setDatetimePrecision(Integer datetimePrecision) {
        this.datetimePrecision = datetimePrecision;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public String getIntervalPrecision() {
        return this.intervalPrecision;
    }

    public void setIntervalPrecision(String intervalPrecision) {
        this.intervalPrecision = intervalPrecision;
    }

    public String getCharacterSetCatalog() {
        return this.characterSetCatalog;
    }

    public void setCharacterSetCatalog(String characterSetCatalog) {
        this.characterSetCatalog = characterSetCatalog;
    }

    public String getCharacterSetSchema() {
        return this.characterSetSchema;
    }

    public void setCharacterSetSchema(String characterSetSchema) {
        this.characterSetSchema = characterSetSchema;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCollationCatalog() {
        return this.collationCatalog;
    }

    public void setCollationCatalog(String collationCatalog) {
        this.collationCatalog = collationCatalog;
    }

    public String getCollationSchema() {
        return this.collationSchema;
    }

    public void setCollationSchema(String collationSchema) {
        this.collationSchema = collationSchema;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getDomainCatalog() {
        return this.domainCatalog;
    }

    public void setDomainCatalog(String domainCatalog) {
        this.domainCatalog = domainCatalog;
    }

    public String getDomainSchema() {
        return this.domainSchema;
    }

    public void setDomainSchema(String domainSchema) {
        this.domainSchema = domainSchema;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getUdtCatalog() {
        return this.udtCatalog;
    }

    public void setUdtCatalog(String udtCatalog) {
        this.udtCatalog = udtCatalog;
    }

    public String getUdtSchema() {
        return this.udtSchema;
    }

    public void setUdtSchema(String udtSchema) {
        this.udtSchema = udtSchema;
    }

    public String getUdtName() {
        return this.udtName;
    }

    public void setUdtName(String udtName) {
        this.udtName = udtName;
    }

    public String getScopeCatalog() {
        return this.scopeCatalog;
    }

    public void setScopeCatalog(String scopeCatalog) {
        this.scopeCatalog = scopeCatalog;
    }

    public String getScopeSchema() {
        return this.scopeSchema;
    }

    public void setScopeSchema(String scopeSchema) {
        this.scopeSchema = scopeSchema;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public String getMaximumCardinality() {
        return this.maximumCardinality;
    }

    public void setMaximumCardinality(String maximumCardinality) {
        this.maximumCardinality = maximumCardinality;
    }

    public String getDtdIdentifier() {
        return this.dtdIdentifier;
    }

    public void setDtdIdentifier(String dtdIdentifier) {
        this.dtdIdentifier = dtdIdentifier;
    }

    public String getIsSelfReferencing() {
        return this.isSelfReferencing;
    }

    public void setIsSelfReferencing(String isSelfReferencing) {
        this.isSelfReferencing = isSelfReferencing;
    }

    public String getIsIdentity() {
        return this.isIdentity;
    }

    public void setIsIdentity(String isIdentity) {
        this.isIdentity = isIdentity;
    }

    public String getIdentityGeneration() {
        return this.identityGeneration;
    }

    public void setIdentityGeneration(String identityGeneration) {
        this.identityGeneration = identityGeneration;
    }

    public PostgresSequence getIdentityExpr() {
        return this.identityExpr;
    }

    public void setIdentityExpr(PostgresSequence identityExpr) {
        this.identityExpr = identityExpr;
    }

    public String getIsGenerated() {
        return this.isGenerated;
    }

    public void setIsGenerated(String isGenerated) {
        this.isGenerated = isGenerated;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
    }

    public String getIsUpdatable() {
        return this.isUpdatable;
    }

    public void setIsUpdatable(String isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public String getGisType() {
        return this.gisType;
    }

    public void setGisType(String gisType) {
        this.gisType = gisType;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public Integer getCoordDimension() {
        return this.coordDimension;
    }

    public void setCoordDimension(Integer coordDimension) {
        this.coordDimension = coordDimension;
    }

    public PostgresSequence getSequence() {
        return this.sequence;
    }

    public void setSequence(PostgresSequence sequence) {
        this.sequence = sequence;
    }
}

