/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.AbstractPostgresConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.util.List;

public class PostgresExclusion
extends AbstractPostgresConstraint {
    public PostgresExclusion(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(512);
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("EXCLUDE ");
        if ("YES".equalsIgnoreCase(this.getIsDeferrable())) {
            sb.append("DEFERRABLE");
        } else {
            sb.append("NOT DEFERRABLE");
        }
        if ("YES".equalsIgnoreCase(this.getInitiallyDeferred())) {
            sb.append("INITIALLY DEFERRED");
        } else {
            sb.append("INITIALLY IMMEDIATE");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof PostgresExclusion)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }
}

