/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.AbstractPostgresConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.util.List;

public class PostgresForeignKey
extends AbstractPostgresConstraint {
    private String matchOption;
    private String updateRule;
    private String deleteRule;

    public PostgresForeignKey(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(512);
        if (StringUtils.isNotBlank((CharSequence)this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("FOREIGN KEY").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" REFERENCES ").append(this.getRefOwnerTableName()).append((CharSequence)this.joinRefConstraintColumns());
        if ("FULL".equals(this.getMatchOption())) {
            sb.append(" MATCH FULL");
        } else if ("PARTIAL".equals(this.getMatchOption())) {
            sb.append(" MATCH PARTIAL");
        }
        if ("CASCADE".equals(this.getMatchOption())) {
            sb.append(" ON DELETE CASCADE");
        } else if ("SET NULL".equals(this.getMatchOption())) {
            sb.append(" ON DELETE SET NULL");
        } else if ("SET DEFAULT".equals(this.getMatchOption())) {
            sb.append(" ON DELETE SET DEFAULT");
        } else if ("RESTRICT".equals(this.getMatchOption())) {
            sb.append(" ON DELETE RESTRICT");
        }
        if ("CASCADE".equals(this.getMatchOption())) {
            sb.append(" ON UPDATE CASCADE");
        } else if ("SET NULL".equals(this.getMatchOption())) {
            sb.append(" ON UPDATE SET NULL");
        } else if ("SET DEFAULT".equals(this.getMatchOption())) {
            sb.append(" ON UPDATE SET DEFAULT");
        } else if ("RESTRICT".equals(this.getMatchOption())) {
            sb.append(" ON UPDATE RESTRICT");
        }
        if ("YES".equalsIgnoreCase(this.getIsDeferrable())) {
            sb.append(" DEFERRABLE");
        } else {
            sb.append(" NOT DEFERRABLE");
        }
        if ("YES".equalsIgnoreCase(this.getInitiallyDeferred())) {
            sb.append(" INITIALLY DEFERRED");
        } else {
            sb.append(" INITIALLY IMMEDIATE");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractConstraint other) {
        if (!(other instanceof PostgresForeignKey)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getMatchOption() {
        return this.matchOption;
    }

    public void setMatchOption(String matchOption) {
        this.matchOption = matchOption;
    }

    @Override
    public String getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public void setUpdateRule(String updateRule) {
        this.updateRule = updateRule;
    }

    @Override
    public String getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public void setDeleteRule(String deleteRule) {
        this.deleteRule = deleteRule;
    }
}

