/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.util.List;
import java.util.stream.Collectors;

public class PostgresIndex
extends AbstractIndex {
    private String uniqueness;

    public PostgresIndex(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE");
        sb.append(this.safetyMapping(this.getUniqueRuleMapping(), this.getUniqueness()));
        sb.append(" INDEX IF NOT EXISTS ").append(this.getWrappedIndexName());
        sb.append(" ON ").append(this.getDefinitionSchemaObjectName());
        if (StringUtils.isNotBlank((CharSequence)this.getIndexType())) {
            sb.append(" USING ").append(this.getIndexType());
        }
        sb.append((CharSequence)this.joinIndexColumns());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof PostgresIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public StringBuilder joinIndexColumns() {
        StringBuilder excludes = this.enclose(this.getIndexColumns().stream().filter(e -> !"I".equals(e.getColumnOrder())).map(e -> {
            String columnOrder;
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            String subPart = e.getSubPart();
            if (!"GIST".equalsIgnoreCase(this.getIndexType()) && StringUtils.isNotBlank((CharSequence)subPart)) {
                columnName = columnName + "(" + subPart + ")";
            }
            if (StringUtils.isNotBlank((CharSequence)(columnOrder = this.getCollationMapping().get(e.getColumnOrder())))) {
                columnName = columnName + columnOrder;
            }
            return columnName;
        }).collect(Collectors.joining(", ")));
        String includes = this.getIndexColumns().stream().filter(e -> "I".equals(e.getColumnOrder())).map(e -> {
            String columnName = e.getColumnName();
            if (!e.isExpression()) {
                columnName = this.wrap(columnName);
            }
            return columnName;
        }).collect(Collectors.joining(", "));
        StringBuilder sb = new StringBuilder(excludes);
        if (StringUtils.isNotBlank((CharSequence)includes)) {
            sb.append(" INCLUDE").append((CharSequence)this.enclose(includes));
        }
        return sb;
    }

    private boolean isColumnOrderSupported() {
        return "btree".equalsIgnoreCase(this.getIndexType());
    }

    public String getUniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(String uniqueness) {
        this.uniqueness = uniqueness;
    }
}

