/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.math.BigDecimal;
import java.util.List;

public class PostgresSequence
extends AbstractSequence {
    private String sequenceCatalog;
    private String sequenceSchema;
    private String sequenceName;
    private String dataType;
    private int numericPrecision;
    private int numericPrecisionRadix;
    private int numericScale;
    private BigDecimal startValue;
    private BigDecimal nextVal;
    private BigDecimal minimumValue;
    private BigDecimal maximumValue;
    private long incrementBy;
    private String cycleOption;

    public PostgresSequence(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE SEQUENCE IF NOT EXISTS ");
        sb.append(this.getSchemaObjectName());
        sb.append((CharSequence)this.buildSequenceGrammar());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractSequence other) {
        if (!(other instanceof PostgresSequence)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public StringBuilder buildSequenceGrammar() {
        BigDecimal cache;
        StringBuilder sb = new StringBuilder(256);
        sb.append(" INCREMENT ").append(this.getIncrement());
        BigDecimal minValue = this.getMinValue();
        if (minValue != null && minValue.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(" MINVALUE ").append(minValue);
        } else {
            sb.append(" NO MINVALUE");
        }
        BigDecimal maxValue = this.getMaxValue();
        if (maxValue != null && maxValue.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(" MAXVALUE ").append(this.getMaxValue());
        } else {
            sb.append(" NO MAXVALUE");
        }
        BigDecimal start = this.getStart();
        if (start != null && start.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(" START ").append(start);
        }
        if ((cache = this.getCache()) != null && cache.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(" CACHE ").append(cache);
        }
        sb.append(StringUtils.isBlank((CharSequence)this.getCycle()) ? " NO" : "").append(" CYCLE");
        return sb;
    }

    @Override
    public StringBuilder buildIdentityGrammar() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(" AS IDENTITY (");
        sb.append(this.buildSequenceGrammar().toString().trim());
        return sb.append(")");
    }

    public String getSequenceCatalog() {
        return this.sequenceCatalog;
    }

    public void setSequenceCatalog(String sequenceCatalog) {
        this.sequenceCatalog = sequenceCatalog;
    }

    public String getSequenceSchema() {
        return this.sequenceSchema;
    }

    public void setSequenceSchema(String sequenceSchema) {
        this.sequenceSchema = sequenceSchema;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public int getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(int numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public int getNumericPrecisionRadix() {
        return this.numericPrecisionRadix;
    }

    public void setNumericPrecisionRadix(int numericPrecisionRadix) {
        this.numericPrecisionRadix = numericPrecisionRadix;
    }

    public int getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(int numericScale) {
        this.numericScale = numericScale;
    }

    public BigDecimal getStartValue() {
        return this.startValue;
    }

    public void setStartValue(BigDecimal startValue) {
        this.startValue = startValue;
    }

    public BigDecimal getNextVal() {
        return this.nextVal;
    }

    public void setNextVal(BigDecimal nextVal) {
        this.nextVal = nextVal;
    }

    public BigDecimal getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(BigDecimal minimumValue) {
        this.minimumValue = minimumValue;
    }

    public BigDecimal getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(BigDecimal maximumValue) {
        this.maximumValue = maximumValue;
    }

    public long getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(long incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getCycleOption() {
        return this.cycleOption;
    }

    public void setCycleOption(String cycleOption) {
        this.cycleOption = cycleOption;
    }
}

