/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.pgsql.AbstractPostgresConstraint;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresCheck;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresColumn;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresForeignKey;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresIndex;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTablePartition;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresUniqueKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PostgresTable
extends AbstractTable {
    private final Map<String, PostgresColumn> columnMapping = new LinkedHashMap<String, PostgresColumn>();
    private final Map<String, PostgresIndex> indexMapping = new LinkedHashMap<String, PostgresIndex>();
    private final Map<String, PostgresCheck> checkMapping = new LinkedHashMap<String, PostgresCheck>();
    private final Map<String, PostgresUniqueKey> uniqueMapping = new LinkedHashMap<String, PostgresUniqueKey>();
    private final Map<String, PostgresForeignKey> foreignMapping = new LinkedHashMap<String, PostgresForeignKey>();
    private PostgresPrimaryKey primaryKey;
    private String tableCatalog;
    private String tableSchema;
    private String tableName;
    private String tableType;
    private String selfReferencingColumnName;
    private String referenceGeneration;
    private String userDefinedTypeCatalog;
    private String userDefinedTypeSchema;
    private String userDefinedTypeName;
    private String isInsertableInto;
    private String isTyped;
    private String commitAction;
    private String relHasSubClass;
    private PostgresTablePartition tablePartition;

    public PostgresTable(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder grammar;
        Iterator<AbstractPostgresConstraint> iter;
        StringBuilder grammar2;
        StringBuilder sb = new StringBuilder(1024);
        String objectName = this.getDefinitionSchemaObjectName();
        sb.append("CREATE TABLE ").append(objectName).append(" (");
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        String tableComment = this.getTableComment();
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            tableComment = String.format("COMMENT ON TABLE %s IS '%s'", objectName, tableComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, objectName, tableComment));
        }
        Iterator<PostgresColumn> iterator = this.getColumnMapping().values().iterator();
        while (iterator.hasNext()) {
            String colComment;
            PostgresColumn col = iterator.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (iterator.hasNext()) {
                sb.append(",");
            }
            if (!StringUtils.isNotBlank((CharSequence)(colComment = col.getColumnComment()))) continue;
            String wrappedName = col.getWrappedName();
            colComment = String.format("COMMENT ON COLUMN %s.%s IS '%s'", objectName, wrappedName, colComment.replace("'", "''"));
            subDefines.add(new CreateObjectDefine(ObjectType.COMMENT, wrappedName, colComment));
        }
        if (this.getPrimaryKey() != null && StringUtils.isNotBlank((CharSequence)(grammar2 = this.getPrimaryKey().buildGrammar()))) {
            sb.append(",").append("\n\t").append((CharSequence)grammar2);
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            iter = this.getUniqueMapping().values().iterator();
            while (iter.hasNext()) {
                grammar = iter.next().buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            iter = this.getCheckMapping().values().iterator();
            while (iter.hasNext()) {
                grammar = ((PostgresCheck)iter.next()).buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            iter = this.getForeignMapping().values().iterator();
            while (iter.hasNext()) {
                grammar = ((PostgresForeignKey)iter.next()).buildGrammar();
                if (!StringUtils.isNotBlank((CharSequence)grammar)) continue;
                sb.append(",").append("\n\t").append((CharSequence)grammar);
            }
        }
        sb.append("\n").append(")");
        PostgresTablePartition tablePartition = this.getTablePartition();
        if (tablePartition != null && "YES".equals(this.getRelHasSubClass())) {
            sb.append((CharSequence)tablePartition.buildGrammar());
            ArrayList<String> subClasses = new ArrayList<String>();
            tablePartition.buildSubClasses(tablePartition.getTablePartitions(), subClasses);
            for (String subClass : subClasses) {
                subDefines.add(new CreateObjectDefine(ObjectType.TABLE_PARTITION, this.getSimpleObjectName(), subClass));
            }
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            Iterator<PostgresIndex> iter2 = this.getIndexMapping().values().iterator();
            while (iter2.hasNext()) {
                subDefines.addAll(iter2.next().buildDefinition());
            }
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof PostgresTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public Map<String, PostgresColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, PostgresIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, PostgresCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, PostgresUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, PostgresForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public PostgresPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PostgresPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public void setTableCatalog(String tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getTableType() {
        return this.tableType;
    }

    @Override
    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getSelfReferencingColumnName() {
        return this.selfReferencingColumnName;
    }

    public void setSelfReferencingColumnName(String selfReferencingColumnName) {
        this.selfReferencingColumnName = selfReferencingColumnName;
    }

    public String getReferenceGeneration() {
        return this.referenceGeneration;
    }

    public void setReferenceGeneration(String referenceGeneration) {
        this.referenceGeneration = referenceGeneration;
    }

    public String getUserDefinedTypeCatalog() {
        return this.userDefinedTypeCatalog;
    }

    public void setUserDefinedTypeCatalog(String userDefinedTypeCatalog) {
        this.userDefinedTypeCatalog = userDefinedTypeCatalog;
    }

    public String getUserDefinedTypeSchema() {
        return this.userDefinedTypeSchema;
    }

    public void setUserDefinedTypeSchema(String userDefinedTypeSchema) {
        this.userDefinedTypeSchema = userDefinedTypeSchema;
    }

    public String getUserDefinedTypeName() {
        return this.userDefinedTypeName;
    }

    public void setUserDefinedTypeName(String userDefinedTypeName) {
        this.userDefinedTypeName = userDefinedTypeName;
    }

    public String getIsInsertableInto() {
        return this.isInsertableInto;
    }

    public void setIsInsertableInto(String isInsertableInto) {
        this.isInsertableInto = isInsertableInto;
    }

    public String getIsTyped() {
        return this.isTyped;
    }

    public void setIsTyped(String isTyped) {
        this.isTyped = isTyped;
    }

    public String getCommitAction() {
        return this.commitAction;
    }

    public void setCommitAction(String commitAction) {
        this.commitAction = commitAction;
    }

    public String getRelHasSubClass() {
        return this.relHasSubClass;
    }

    public void setRelHasSubClass(String relHasSubClass) {
        this.relHasSubClass = relHasSubClass;
    }

    public PostgresTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(PostgresTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

