/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.util.ArrayList;
import java.util.List;

public class PostgresTablePartition
extends AbstractTablePartition {
    private final List<PostgresPartitionItem> tablePartitions = new ArrayList<PostgresPartitionItem>();
    private String partitionMethod;
    private Integer partKeyColumnNum;
    private String partAttrs;
    private String partitionExpression;
    private String partitionKey;

    public PostgresTablePartition(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(32);
        sb.append(" PARTITION BY ").append(this.getPartitionKey());
        return sb;
    }

    public void buildSubClasses(List<PostgresPartitionItem> items, List<String> subClasses) {
        for (PostgresPartitionItem item : items) {
            subClasses.add(this.buildPartitionItemGrammar(item).toString());
            List<PostgresPartitionItem> subItems = item.getSubPartitions();
            if (!CollectionUtils.isNotEmpty(subItems)) continue;
            this.buildSubClasses(subItems, subClasses);
        }
    }

    public StringBuilder buildPartitionItemGrammar(PostgresPartitionItem item) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getSchemaPartitionItemName(item.getPartitionName()));
        sb.append(" PARTITION OF ").append(item.getSchemaParentName());
        sb.append(" ").append(item.getPartitionBound());
        if (item.isHasSubClass()) {
            sb.append(" PARTITION BY ").append(item.getPartitionKey());
        }
        return sb.append(";");
    }

    public String getSchemaPartitionItemName(String partitionName) {
        StringBuilder sb = new StringBuilder();
        if (this.getGlobal().withSchema()) {
            sb.append(this.wrapAndCase(this.getSchemaName(), "schemaCase")).append(".");
        }
        return sb.append(this.wrap(partitionName)).toString();
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof PostgresTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public List<PostgresPartitionItem> getTablePartitions() {
        return this.tablePartitions;
    }

    public String getPartitionMethod() {
        return this.partitionMethod;
    }

    public void setPartitionMethod(String partitionMethod) {
        this.partitionMethod = partitionMethod;
    }

    public Integer getPartKeyColumnNum() {
        return this.partKeyColumnNum;
    }

    public void setPartKeyColumnNum(Integer partKeyColumnNum) {
        this.partKeyColumnNum = partKeyColumnNum;
    }

    public String getPartAttrs() {
        return this.partAttrs;
    }

    public void setPartAttrs(String partAttrs) {
        this.partAttrs = partAttrs;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String partitionExpression) {
        this.partitionExpression = partitionExpression;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public static class PostgresPartitionItem {
        private final List<PostgresPartitionItem> subPartitions = new ArrayList<PostgresPartitionItem>();
        private String partitionName;
        private String parentName;
        private String schemaName;
        private String partitionBound;
        private boolean hasSubClass;
        private String partitionMethod;
        private String partattrs;
        private String partitionKey;

        public String getSchemaParentName() {
            return "\"" + this.getSchemaName() + "\"" + "." + "\"" + this.getParentName() + "\"";
        }

        public List<PostgresPartitionItem> getSubPartitions() {
            return this.subPartitions;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public String getParentName() {
            return this.parentName;
        }

        public void setParentName(String parentName) {
            this.parentName = parentName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getPartitionBound() {
            return this.partitionBound;
        }

        public void setPartitionBound(String partitionBound) {
            this.partitionBound = partitionBound;
        }

        public boolean isHasSubClass() {
            return this.hasSubClass;
        }

        public void setHasSubClass(boolean hasSubClass) {
            this.hasSubClass = hasSubClass;
        }

        public String getPartitionMethod() {
            return this.partitionMethod;
        }

        public void setPartitionMethod(String partitionMethod) {
            this.partitionMethod = partitionMethod;
        }

        public String getPartattrs() {
            return this.partattrs;
        }

        public void setPartattrs(String partattrs) {
            this.partattrs = partattrs;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }
    }
}

