/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.pgsql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSchema;
import java.util.List;

public class PostgresTablespace
extends AbstractTablespace {
    private String spcName;
    private String spcOwner;
    private String spcLocation;
    private String spcAcl;
    private String spcOptions;

    public PostgresTablespace(PostgresSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE TABLESPACE ").append(this.getObjectName());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLESPACE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablespace other) {
        if (!(other instanceof PostgresTablespace)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public String getSpcName() {
        return this.spcName;
    }

    public void setSpcName(String spcName) {
        this.spcName = spcName;
    }

    public String getSpcOwner() {
        return this.spcOwner;
    }

    public void setSpcOwner(String spcOwner) {
        this.spcOwner = spcOwner;
    }

    public String getSpcLocation() {
        return this.spcLocation;
    }

    public void setSpcLocation(String spcLocation) {
        this.spcLocation = spcLocation;
    }

    public String getSpcAcl() {
        return this.spcAcl;
    }

    public void setSpcAcl(String spcAcl) {
        this.spcAcl = spcAcl;
    }

    public String getSpcOptions() {
        return this.spcOptions;
    }

    public void setSpcOptions(String spcOptions) {
        this.spcOptions = spcOptions;
    }
}

