/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.polarx;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlIndex;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PolarXIndex
extends AbstractMySqlIndex {
    private final List<KeyColumn> coveringColumns = new ArrayList<KeyColumn>();

    public PolarXIndex(PolarXSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof PolarXIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String indexComment;
        String visible;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        if (this.getNonunique() == 0) {
            sb.append(" ").append((Object)ObjectType.UNIQUE);
            this.addUniqueAttribute();
        }
        sb.append(" INDEX ").append(this.getWrappedIndexName()).append(" ON ");
        sb.append(this.getDefinitionSchemaObjectName()).append((CharSequence)this.joinCoveringColumns());
        if (CollectionUtils.isNotEmpty(this.coveringColumns)) {
            sb.append(" COVERING ").append((CharSequence)this.joinIndexColumns());
        }
        if (StringUtils.isNotBlank((CharSequence)(visible = this.getVisible())) && "NO".equals(visible)) {
            sb.append(" invisible");
        }
        if (StringUtils.isNotBlank((CharSequence)(indexComment = this.getIndexComment()))) {
            sb.append(" COMMENT \"").append(indexComment).append("\"");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getIndexType(), this.getSimpleIndexName(), this.terminate(sb))});
    }

    private StringBuilder joinCoveringColumns() {
        return this.enclose(this.getCoveringColumns().stream().map(e -> e.getColumnName()).collect(Collectors.joining(", ")));
    }

    public List<KeyColumn> getCoveringColumns() {
        return this.coveringColumns;
    }
}

