/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.polarx;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXColumn;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXIndex;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXSchema;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXTablePartition;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXUniqueKey;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PolarXTable
extends AbstractMySqlTable {
    private final Map<String, PolarXColumn> columnMapping = new LinkedHashMap<String, PolarXColumn>();
    private final Map<String, PolarXIndex> indexMapping = new LinkedHashMap<String, PolarXIndex>();
    private final Map<String, PolarXUniqueKey> uniqueMapping = new LinkedHashMap<String, PolarXUniqueKey>();
    private PolarXPrimaryKey primaryKey;
    private PolarXTablePartition tablePartition;

    public PolarXTable(PolarXSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof PolarXTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create table if not exists ").append(this.getDefinitionSchemaObjectName()).append(" (");
        Collection<PolarXColumn> columns = this.getColumnMapping().values();
        Iterator<PolarXColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            String characterSetName;
            PolarXColumn column = iter.next();
            String string = this.getTableCollation();
            if (string != null && string.equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((characterSetName = this.getCharacterSetName()) != null && characterSetName.equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        PolarXPrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (PolarXUniqueKey polarXUniqueKey : this.getUniqueMapping().values()) {
                sb.append(",\n\t").append((CharSequence)polarXUniqueKey.buildGrammar());
            }
        }
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (PolarXIndex index : this.getIndexMapping().values()) {
                subDefines.addAll(index.buildDefinition());
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        PolarXTablePartition polarXTablePartition = this.getTablePartition();
        if (polarXTablePartition != null) {
            sb.append((CharSequence)polarXTablePartition.buildGrammar());
        }
        CreateObjectDefine objectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        objectDefine.getChangeInfos().addAll(ChangeUtils.findByKey(ObjectType.TABLE, this.getSimpleObjectName()));
        return Lists.newArrayList((Object[])new ObjectDefine[]{objectDefine});
    }

    public Map<String, PolarXColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, PolarXIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, PolarXUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public PolarXPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PolarXPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PolarXTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(PolarXTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

