/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.polarx;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXSchema;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PolarXTablePartition
extends AbstractMySqlTablePartition {
    private Integer partitionTableType;

    public PolarXTablePartition(PolarXSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        Integer partitionTableType = this.getPartitionTableType();
        if (partitionTableType == 0) {
            sb.append("\n").append("SINGLE");
        } else if (partitionTableType == 1) {
            sb.append("\n").append("BROADCAST");
        } else {
            String partitionMethod = this.getPartTypeMapping().get(this.getPartitionMethod());
            this.checkPartitionMethod(partitionMethod);
            sb.append((CharSequence)this.buildPartitionGrammar(partitionMethod));
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        return null;
    }

    @Override
    public boolean isCompositePartitioned() {
        return false;
    }

    @Override
    protected void appendOptions(StringBuilder sb, AbstractMySqlTablePartition.MySqlPartitionItem partItem) {
    }

    private StringBuilder buildPartitionGrammar(String partitionMethod) {
        StringBuilder sb = new StringBuilder();
        Collection<AbstractMySqlTablePartition.MySqlPartitionItem> partitionItems = this.getTablePartitions();
        if (CollectionUtils.isEmpty(partitionItems)) {
            return sb;
        }
        sb.append("\n").append("PARTITION BY ").append(partitionMethod);
        sb.append((CharSequence)this.enclose(this.getPartitionExpression()));
        boolean isKeyHashPartMethod = "KEY".equals(partitionMethod);
        if (isKeyHashPartMethod |= "HASH".equals(partitionMethod)) {
            if (partitionItems.size() < 2) {
                return new StringBuilder();
            }
            return sb.append(" PARTITIONS ").append(partitionItems.size());
        }
        sb.append("\n").append("(");
        Map<String, String> partFormatMap = super.getTablePartTemplateMapping();
        partFormatMap.put("LIST", partFormatMap.get("LIST COLUMNS"));
        Iterator<AbstractMySqlTablePartition.MySqlPartitionItem> iter = this.getTablePartitions().iterator();
        while (iter.hasNext()) {
            AbstractMySqlTablePartition.MySqlPartitionItem partItem = iter.next();
            sb.append("\n\t");
            String partFormat = partFormatMap.get(partitionMethod);
            String partName = this.wrap(partItem.getPartitionName());
            String partDesc = partItem.getPartitionDescription();
            sb.append(String.format(partFormat, partName, partDesc));
            this.appendOptions(sb, partItem);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    public Integer getPartitionTableType() {
        return this.partitionTableType;
    }

    public void setPartitionTableType(Integer partitionTableType) {
        this.partitionTableType = partitionTableType;
    }
}

