/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.relation;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.DdlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ObjectRelationGraph {
    private final MutableGraph<String> graph;

    public ObjectRelationGraph(int nodeCount) {
        this.graph = GraphBuilder.directed().allowsSelfLoops(true).expectedNodeCount(nodeCount).nodeOrder(ElementOrder.insertion()).build();
    }

    public boolean add(Object predecessor, Object successor) {
        return this.graph.putEdge((Object)predecessor.toString(), (Object)successor.toString());
    }

    public boolean hasCycle() {
        return Graphs.hasCycle(this.graph);
    }

    public String cyclePathStr() {
        if (!this.hasCycle()) {
            return "No cycle reference were found";
        }
        List<LinkedList<String>> cycleList = this.findCycle();
        AtomicInteger index = new AtomicInteger(1);
        return cycleList.stream().filter(e -> !e.isEmpty()).map(e -> "Cycle-" + index.getAndIncrement() + ": " + e.stream().collect(Collectors.joining(" -> "))).collect(Collectors.joining("\n"));
    }

    public List<LinkedList<String>> findCycle() {
        ArrayList<LinkedList<String>> allCycle = new ArrayList<LinkedList<String>>();
        Set nodes = this.graph.nodes();
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> path = new LinkedList<String>();
        for (String node : nodes) {
            this.findCycle(node, path, visited, allCycle);
        }
        return allCycle;
    }

    private void findCycle(String node, LinkedList<String> path, Set<String> visited, List<LinkedList<String>> cyclePaths) {
        path.addLast(node);
        if (visited.contains(node)) {
            if (path.getFirst().equals(node) && ObjectRelationGraph.isMinNodeInPath(path, node)) {
                cyclePaths.add(new LinkedList<String>(path));
            }
            path.removeLast();
            return;
        }
        visited.add(node);
        for (String successor : this.graph.successors((Object)node)) {
            this.findCycle(successor, path, visited, cyclePaths);
        }
        visited.remove(node);
        path.removeLast();
    }

    private static boolean isMinNodeInPath(List<String> path, String node) {
        for (String temp : path) {
            if (node.compareTo(temp) <= 0) continue;
            return false;
        }
        return true;
    }

    public List<String> visitDepthFirst() {
        Set nodes = this.graph.nodes();
        LinkedHashSet sorted = new LinkedHashSet();
        Traverser traverser = Traverser.forGraph(this.graph);
        for (String node : nodes) {
            if (this.graph.inDegree((Object)node) > this.graph.outDegree((Object)node)) continue;
            Iterable iterable = traverser.depthFirstPostOrder((Object)node);
            Iterator iter = iterable.iterator();
            while (iter.hasNext()) {
                sorted.add(iter.next());
            }
        }
        return Lists.newArrayList(sorted);
    }

    public List<ObjectDefine> sortByDepthFirst(final List<ObjectDefine> objectDefines) {
        if (CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        final List<String> sorted = this.visitDepthFirst();
        Collections.sort(objectDefines, new Comparator<ObjectDefine>(){

            @Override
            public int compare(ObjectDefine o1, ObjectDefine o2) {
                int idx1 = sorted.indexOf(o1.getCoordinate());
                int idx2 = sorted.indexOf(o2.getCoordinate());
                if (idx1 != -1) {
                    idx1 = objectDefines.size() - idx1;
                }
                if (idx2 != -1) {
                    idx2 = objectDefines.size() - idx2;
                }
                return idx2 - idx1;
            }
        });
        return objectDefines;
    }

    public List<ObjectDefine> groupByDepthFirst(List<ObjectDefine> objectDefines) {
        if (CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        HashMap<String, ObjectDefine> edgeMap = new HashMap<String, ObjectDefine>(16);
        for (ObjectDefine objectDefine : objectDefines) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(objectDefine.getObjectType());
            sb.append("]");
            sb.append(objectDefine.getObjectName());
            edgeMap.putIfAbsent(sb.toString(), objectDefine);
        }
        Set nodes = this.graph.nodes();
        Traverser traverser = Traverser.forGraph(this.graph);
        HashMap<String, String> groupMap = new HashMap<String, String>(16);
        for (String node : nodes) {
            if (this.graph.inDegree((Object)node) > this.graph.outDegree((Object)node)) continue;
            int sequenceId = 0;
            String groupId = UUID.randomUUID().toString();
            Iterable iterable = traverser.depthFirstPostOrder((Object)node);
            for (String temp : iterable) {
                ObjectDefine objectDefine;
                groupMap.putIfAbsent(temp, groupId);
                if (groupMap.containsKey(temp)) {
                    groupId = (String)groupMap.get(temp);
                }
                if ((objectDefine = (ObjectDefine)edgeMap.get(temp)) == null) continue;
                if (DdlType.CREATE.name().equals(objectDefine.getDdlType())) {
                    objectDefine.setSequenceId(sequenceId++);
                } else {
                    objectDefine.setSequenceId(sequenceId--);
                }
                objectDefine.setGroupId(groupId);
            }
        }
        return Lists.newArrayList(edgeMap.values());
    }
}

