/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.sybasease;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractColumn;
import com.oceanbase.obtools.dbdiff.model.sybase.AbstractSybaseColumn;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseSchema;
import java.util.List;
import java.util.Locale;

public class SybaseaseColumn
extends AbstractSybaseColumn {
    private int colId;
    private int status;
    private long length;
    private int prec;
    private int scale;
    private int computedCol;
    private int encrType;
    private int encrLen;
    private int encrKeyId;
    private String encrKeyDb;
    private int lobCompLvl;
    private int ident;
    private int allowNulls;
    private String computeExpr;

    public SybaseaseColumn(SybaseaseSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String upperType;
        String dataType = this.getDataType();
        if (dataType == null) {
            throw new IllegalArgumentException("DataType is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGrammarColumnName()).append(" ");
        if (StringUtils.isNotBlank((CharSequence)this.getComputeExpr())) {
            return sb.append(this.getComputeExpr());
        }
        switch (upperType = dataType.trim().toUpperCase(Locale.getDefault())) {
            case "BINARY": 
            case "VARBINARY": 
            case "CHAR": 
            case "VARCHAR": 
            case "NCHAR": 
            case "NVARCHAR": {
                sb.append(dataType).append("(").append(this.getLength()).append(")");
                break;
            }
            case "NUMERIC": 
            case "DECIMAL": {
                sb.append(dataType).append("(").append(this.getPrec());
                if (this.getScale() > -1) {
                    sb.append(",").append(this.getScale());
                }
                sb.append(")");
                break;
            }
            case "NUMERIC IDENTITY": {
                sb.append("NUMERIC(").append(this.getPrec());
                if (this.getScale() > -1) {
                    sb.append(",").append(this.getScale());
                }
                sb.append(") identity");
                break;
            }
            default: {
                sb.append(dataType);
            }
        }
        if ("NO".equals(this.getNullable())) {
            sb.append(" NOT NULL");
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractColumn other) {
        if (!(other instanceof SybaseaseColumn)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public int getColId() {
        return this.colId;
    }

    public void setColId(int colId) {
        this.colId = colId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public int getPrec() {
        return this.prec;
    }

    public void setPrec(int prec) {
        this.prec = prec;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getComputedCol() {
        return this.computedCol;
    }

    public void setComputedCol(int computedCol) {
        this.computedCol = computedCol;
    }

    public int getEncrType() {
        return this.encrType;
    }

    public void setEncrType(int encrType) {
        this.encrType = encrType;
    }

    public int getEncrLen() {
        return this.encrLen;
    }

    public void setEncrLen(int encrLen) {
        this.encrLen = encrLen;
    }

    public int getEncrKeyId() {
        return this.encrKeyId;
    }

    public void setEncrKeyId(int encrKeyId) {
        this.encrKeyId = encrKeyId;
    }

    public String getEncrKeyDb() {
        return this.encrKeyDb;
    }

    public void setEncrKeyDb(String encrKeyDb) {
        this.encrKeyDb = encrKeyDb;
    }

    public int getLobCompLvl() {
        return this.lobCompLvl;
    }

    public void setLobCompLvl(int lobCompLvl) {
        this.lobCompLvl = lobCompLvl;
    }

    public int getIdent() {
        return this.ident;
    }

    public void setIdent(int ident) {
        this.ident = ident;
    }

    public int getAllowNulls() {
        return this.allowNulls;
    }

    public void setAllowNulls(int allowNulls) {
        this.allowNulls = allowNulls;
    }

    public String getComputeExpr() {
        return this.computeExpr;
    }

    public void setComputeExpr(String computeExpr) {
        this.computeExpr = computeExpr;
    }
}

