/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.sybasease;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractIndex;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.sybase.AbstractSybaseIndex;
import java.util.List;

public class SybaseaseIndex
extends AbstractSybaseIndex {
    private int nonUnique;
    private int type;
    private String locality;

    public SybaseaseIndex(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder(64);
        sb.append("create");
        if (this.getNonUnique() == 0) {
            sb.append(" unique");
        }
        if (this.getType() == 1) {
            sb.append(" clustered");
        }
        sb.append(" index ").append(this.wrap(this.getIndexName()));
        sb.append(" on ").append(this.wrap(this.getObjectName())).append((CharSequence)this.joinIndexColumns());
        if (StringUtils.isNotBlank((CharSequence)this.getLocality())) {
            sb.append(" local index");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.INDEX, this.getSimpleIndexName(), this.terminate(sb))});
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractIndex other) {
        if (!(other instanceof SybaseaseIndex)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public int getNonUnique() {
        return this.nonUnique;
    }

    public void setNonUnique(int nonUnique) {
        this.nonUnique = nonUnique;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }
}

