/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.sybasease;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.compare.result.CreateObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.sybase.AbstractSybaseTable;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseCheck;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseColumn;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseForeignKey;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseIndex;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseasePrimaryKey;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseSchema;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseTablePartition;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseUniqueKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SybaseaseTable
extends AbstractSybaseTable {
    private int id;
    private int uid;
    private String type;
    private String logiName;
    private SybaseasePrimaryKey primaryKey;
    private final Map<String, SybaseaseColumn> columnMapping = new LinkedHashMap<String, SybaseaseColumn>();
    private final Map<String, SybaseaseIndex> indexMapping = new LinkedHashMap<String, SybaseaseIndex>();
    private final Map<String, SybaseaseUniqueKey> uniqueMapping = new LinkedHashMap<String, SybaseaseUniqueKey>();
    private final Map<String, SybaseaseForeignKey> foreignMapping = new LinkedHashMap<String, SybaseaseForeignKey>();
    private final Map<String, SybaseaseCheck> checkMapping = new LinkedHashMap<String, SybaseaseCheck>();
    private SybaseaseTablePartition tablePartition;

    public SybaseaseTable(SybaseaseSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("create table ").append(this.getDefinitionSchemaObjectName()).append(" (");
        ArrayList<ObjectDefine> subDefines = new ArrayList<ObjectDefine>();
        Iterator<SybaseaseColumn> iter = this.getColumnMapping().values().iterator();
        while (iter.hasNext()) {
            SybaseaseColumn col = iter.next();
            sb.append("\n\t").append((CharSequence)col.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        SybaseasePrimaryKey primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getUniqueMapping())) {
            for (SybaseaseUniqueKey uniqueKey : this.getUniqueMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)uniqueKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (SybaseaseCheck check : this.getCheckMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)check.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (SybaseaseForeignKey foreignKey : this.getForeignMapping().values()) {
                sb.append(",").append("\n\t").append((CharSequence)foreignKey.buildGrammar());
            }
        }
        sb.append("\n").append(")").append((CharSequence)this.appendAttributeClause());
        SybaseaseTablePartition partition = this.getTablePartition();
        if (partition != null) {
            sb.append("\n").append((CharSequence)partition.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (SybaseaseIndex index : this.getIndexMapping().values()) {
                subDefines.addAll(index.buildDefinition());
            }
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines)});
    }

    private StringBuilder appendAttributeClause() {
        StringBuilder sb = new StringBuilder();
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTable other) {
        if (!(other instanceof SybaseaseTable)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLogiName() {
        return this.logiName;
    }

    public void setLogiName(String logiName) {
        this.logiName = logiName;
    }

    public SybaseasePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(SybaseasePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map<String, SybaseaseColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, SybaseaseIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, SybaseaseUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, SybaseaseForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public Map<String, SybaseaseCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public SybaseaseTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(SybaseaseTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

