/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model.sybasease;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractTablePartition;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class SybaseaseTablePartition
extends AbstractTablePartition {
    private String partitionType;
    private String partitionKeys;
    private int partitions;
    private List<SybaseaseTablePartitionItem> partitionItems = new ArrayList<SybaseaseTablePartitionItem>();

    public SybaseaseTablePartition(SybaseaseSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("partition by ").append(this.getPartitionType());
        if (!"ROUNDROBIN".equalsIgnoreCase(this.getPartitionType())) {
            sb.append("(").append(this.getPartitionKeys()).append(")");
        }
        if (this.isHasPartitionItems()) {
            sb.append("\n(").append((CharSequence)this.buildPartitionItem()).append("\n)");
        } else {
            sb.append(" ").append(this.getPartitions());
        }
        return sb;
    }

    private StringBuilder buildPartitionItem() {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.getPartitionItems())) {
            Iterator<SybaseaseTablePartitionItem> iter = this.getPartitionItems().iterator();
            while (iter.hasNext()) {
                SybaseaseTablePartitionItem item = iter.next();
                sb.append("\n\t").append(item.getPartitionName());
                sb.append(" ").append(item.getPartitionExpr());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb;
    }

    @Override
    public List<ObjectDefine> compareTo(AbstractTablePartition other) {
        if (!(other instanceof SybaseaseTablePartition)) {
            throw new UnmatchedObjectTypeException("Raw type is not matched");
        }
        return null;
    }

    public boolean isHasPartitionItems() {
        return "RANGE".equalsIgnoreCase(this.getPartitionType()) || "LIST".equalsIgnoreCase(this.getPartitionType());
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public String getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(String partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public List<SybaseaseTablePartitionItem> getPartitionItems() {
        return this.partitionItems;
    }

    public static class SybaseaseTablePartitionItem {
        private String partitionName;
        private String partitionExpr;
        private int partitionPosition;

        public int hashCode() {
            return Objects.hash(this.partitionName, this.partitionExpr, this.partitionPosition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SybaseaseTablePartitionItem other = (SybaseaseTablePartitionItem)obj;
            return Objects.deepEquals(other.partitionName, this.partitionName) && Objects.deepEquals(other.partitionExpr, this.partitionExpr) && Objects.deepEquals(other.partitionPosition, this.partitionPosition);
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public String getPartitionExpr() {
            return this.partitionExpr;
        }

        public void setPartitionExpr(String partitionExpr) {
            this.partitionExpr = partitionExpr;
        }

        public int getPartitionPosition() {
            return this.partitionPosition;
        }

        public void setPartitionPosition(int partitionPosition) {
            this.partitionPosition = partitionPosition;
        }
    }
}

