/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.resolver;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.antlr.listener.BaseAntlrErrorListener;
import com.oceanbase.obtools.dbdiff.antlr.listener.LexerErrorListener;
import com.oceanbase.obtools.dbdiff.antlr.listener.ParserErrorListener;
import com.oceanbase.obtools.dbdiff.exception.AntlrGrammarException;
import com.oceanbase.obtools.dbdiff.resolver.DdlMetaResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public abstract class AbstractDdlMetaResolver
implements DdlMetaResolver {
    private final BaseAntlrErrorListener lexerErrorListener = new LexerErrorListener();
    private final BaseAntlrErrorListener parserErrorListener = new ParserErrorListener();

    @Override
    public void resolveMetaData(String sql) throws AntlrGrammarException {
        Parser parser = this.initParser(sql);
        ParseTree parseTree = (ParseTree)this.doInvoke(parser, this.parserTreeRootName());
        List<AntlrGrammarException> lexerErrors = this.lexerErrorListener.getErrorMessages();
        List<AntlrGrammarException> parserErrors = this.parserErrorListener.getErrorMessages();
        if (CollectionUtils.isNotEmpty(lexerErrors) || CollectionUtils.isNotEmpty(parserErrors)) {
            AntlrGrammarException grammarException = new AntlrGrammarException("Lexer or Grammar error in sql.");
            grammarException.getLexerExceptions().addAll(lexerErrors);
            grammarException.getGrammarExceptions().addAll(parserErrors);
            this.lexerErrorListener.cleanError();
            this.parserErrorListener.cleanError();
            throw grammarException;
        }
        ParseTreeWalker.DEFAULT.walk(this.parserTreeListener(), parseTree);
    }

    private Parser initParser(String sql) {
        CodePointCharStream charStream = CharStreams.fromString((String)sql);
        Lexer lexer = this.sqlLexer(this.additionalCharProcessor((CharStream)charStream));
        lexer.addErrorListener((ANTLRErrorListener)this.lexerErrorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Parser parser = this.sqlParser(tokens);
        parser.addErrorListener((ANTLRErrorListener)this.parserErrorListener);
        return parser;
    }

    private Object doInvoke(Parser parser, String entrypoint) {
        Class<?> clazz = parser.getClass();
        try {
            Method method = clazz.getMethod(entrypoint, new Class[0]);
            return method.invoke((Object)parser, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private CharStream additionalCharProcessor(CharStream charStream) {
        return charStream;
    }

    protected abstract ParseTreeListener parserTreeListener();

    protected abstract Lexer sqlLexer(CharStream var1);

    protected abstract Parser sqlParser(CommonTokenStream var1);

    protected abstract String parserTreeRootName();
}

