/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.resolver.drds;

import com.alipay.oceanbase.g4.mysql.MySQLParser;
import com.alipay.oceanbase.g4.mysql.MySQLParserBaseListener;
import com.oceanbase.obtools.common.model.Pair;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.drds.AbstractDrdsPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndex;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsSchema;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTable;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTablePartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsUniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.resolver.mysql.AbstractMysqlTableMetaResolver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.lang.StringUtils;

public class DRDSTableMetaResolver
extends AbstractMysqlTableMetaResolver {
    private final DrdsTable table;

    public DRDSTableMetaResolver(AbstractMySqlTable table) {
        super(table);
        this.table = (DrdsTable)table;
    }

    @Override
    protected ParseTreeListener parserTreeListener() {
        return new DRDSResolver();
    }

    protected class DRDSResolver
    extends MySQLParserBaseListener {
        private static final String GEN_INDEX_NAME = "_gen_index_name_";
        private static final String GEN_PRIMARY_NAME = "_gen_primary_name";
        private static final String GEN_UNIQUE_NAME = "_gen_unique_name_";
        private static final String GEN_FOREIGN_NAME = "_gen_foreign_name_";
        private static final String GEN_CHECK_NAME = "_gen_check_name_";
        private final DrdsTable table;
        private DrdsColumn currentColumn;
        private boolean inFieldDefinition;
        private int genUniqueId = 0;
        private int genCheckId = 0;
        private int genForeignId = 0;
        private int genIndexId = 0;

        public DRDSResolver() {
            this.table = DRDSTableMetaResolver.this.table;
        }

        public void enterTableName(MySQLParser.TableNameContext ctx) {
            String tableName;
            String schemaName = null;
            MySQLParser.DotIdentifierContext dotIdentifierContext = ctx.dotIdentifier();
            if (dotIdentifierContext != null) {
                tableName = DRDSTableMetaResolver.this.parseTextOrIdentifier(dotIdentifierContext.identifier().getText());
            } else {
                MySQLParser.QualifiedIdentifierContext qualifiedIdentifierContext = ctx.qualifiedIdentifier();
                tableName = DRDSTableMetaResolver.this.parseTextOrIdentifier(qualifiedIdentifierContext.identifier().getText());
                dotIdentifierContext = qualifiedIdentifierContext.dotIdentifier();
                if (dotIdentifierContext != null) {
                    schemaName = tableName;
                    tableName = DRDSTableMetaResolver.this.parseTextOrIdentifier(dotIdentifierContext.identifier().getText());
                }
            }
            if (StringUtils.isNotBlank(schemaName)) {
                this.table.getSchema().setSchemaName(schemaName);
            }
            this.table.setObjectName(tableName);
        }

        public void enterColumnDefinition(MySQLParser.ColumnDefinitionContext ctx) {
            this.currentColumn = new DrdsColumn(this.table.getSchema());
            this.currentColumn.setObjectName(this.table.getObjectName());
            this.currentColumn.setNullable("YES");
            String columnName = ctx.columnName().getText();
            this.currentColumn.setColumnName(DRDSTableMetaResolver.this.parseTextOrIdentifier(columnName));
        }

        public void exitCreateTable(MySQLParser.CreateTableContext ctx) {
            DrdsTablePartition tablePartition = this.table.getTablePartition();
            if (tablePartition != null) {
                tablePartition.setColumnMapping(this.table.getColumnMapping());
                tablePartition.getDbPartition().setNamePattern(this.table.getSchemaName() + "_{0000}");
                if (tablePartition.getTablePartition() != null) {
                    tablePartition.getTablePartition().setNamePattern(this.table.getObjectName() + "_{0000}");
                }
            }
        }

        public void exitColumnDefinition(MySQLParser.ColumnDefinitionContext ctx) {
            this.convertSynonymsDataType(this.currentColumn);
            this.fillColumnType(this.currentColumn);
            this.table.getColumnMapping().put(this.currentColumn.getColumnName(), this.currentColumn);
            this.currentColumn = null;
        }

        public void enterFieldDefinition(MySQLParser.FieldDefinitionContext ctx) {
            this.inFieldDefinition = true;
            if (ctx.AS_SYMBOL() != null) {
                MySQLParser.ExprWithParenthesesContext exprContext = ctx.exprWithParentheses();
                String expr = DRDSTableMetaResolver.this.parseTextOrIdentifier(exprContext.getText());
                String extra = "VIRTUAL GENERATED";
                if (ctx.STORED_SYMBOL() != null) {
                    extra = "STORED GENERATED";
                }
                this.currentColumn.setGenerationExpression(expr);
                this.currentColumn.setExtra(extra);
            }
        }

        public void exitFieldDefinition(MySQLParser.FieldDefinitionContext ctx) {
            this.inFieldDefinition = false;
        }

        public void enterDataType(MySQLParser.DataTypeContext ctx) {
            String dataType = ctx.type.getText().toLowerCase(Locale.getDefault());
            this.currentColumn.setDataType(dataType);
        }

        public void enterFieldLength(MySQLParser.FieldLengthContext ctx) {
            if (this.currentColumn != null) {
                String dataType;
                Long filedLength = this.resolveFiledLength(ctx);
                switch (dataType = this.currentColumn.getDataType().toUpperCase(Locale.getDefault())) {
                    case "INT": 
                    case "INTEGER": 
                    case "TINYINT": 
                    case "SMALLINT": 
                    case "MEDIUMINT": 
                    case "BIGINT": 
                    case "BIT": 
                    case "FLOAT": 
                    case "DECIMAL": 
                    case "NUMERIC": 
                    case "FIXED": {
                        this.currentColumn.setNumericPrecision(filedLength.intValue());
                        break;
                    }
                    case "CHAR": 
                    case "VARCHAR": 
                    case "BINARY": 
                    case "VARBINARY": {
                        this.currentColumn.setCharacterMaximumLength(filedLength);
                    }
                }
            }
        }

        public void enterTypeDatetimePrecision(MySQLParser.TypeDatetimePrecisionContext ctx) {
            Integer precision = Integer.parseInt(ctx.INT_NUMBER().getText());
            this.currentColumn.setDateTimePrecision(precision);
        }

        public void enterFieldOptions(MySQLParser.FieldOptionsContext ctx) {
            this.currentColumn.setSigned(CollectionUtils.isNotEmpty((Collection)ctx.SIGNED_SYMBOL()));
            this.currentColumn.setUnsigned(CollectionUtils.isNotEmpty((Collection)ctx.UNSIGNED_SYMBOL()));
            this.currentColumn.setZerofill(CollectionUtils.isNotEmpty((Collection)ctx.ZEROFILL_SYMBOL()));
        }

        public void enterCharsetWithOptBinary(MySQLParser.CharsetWithOptBinaryContext ctx) {
            MySQLParser.CharsetNameContext charsetNameContext;
            MySQLParser.UnicodeContext unicode;
            if (!this.inFieldDefinition) {
                return;
            }
            this.currentColumn.setBinary(ctx.BINARY_SYMBOL() != null);
            this.currentColumn.setByte(ctx.BYTE_SYMBOL() != null);
            MySQLParser.AsciiContext ascii = ctx.ascii();
            if (ascii != null) {
                this.currentColumn.setAscii(ascii.ASCII_SYMBOL() != null);
                this.currentColumn.setBinary(ascii.BINARY_SYMBOL() != null);
            }
            if ((unicode = ctx.unicode()) != null) {
                this.currentColumn.setUnicode(unicode.UNICODE_SYMBOL() != null);
                this.currentColumn.setBinary(unicode.BINARY_SYMBOL() != null);
            }
            if ((charsetNameContext = ctx.charsetName()) != null) {
                this.currentColumn.setBinary(charsetNameContext.BINARY_SYMBOL() != null);
                MySQLParser.TextOrIdentifierContext textContext = charsetNameContext.textOrIdentifier();
                if (textContext != null) {
                    String charsetName = textContext.getText();
                    this.currentColumn.setCharacterSetName(DRDSTableMetaResolver.this.parseTextOrIdentifier(charsetName));
                }
            }
        }

        public void enterStringList(MySQLParser.StringListContext ctx) {
            String dataType;
            switch (dataType = this.currentColumn.getDataType().toUpperCase(Locale.getDefault())) {
                case "ENUM": 
                case "SET": {
                    List items = ctx.textString();
                    items.stream().map(item -> item.getText().substring(1, item.getText().length() - 1)).forEach(item -> this.currentColumn.getTypeValues().add((String)item));
                }
            }
        }

        public void enterColumnAttribute(MySQLParser.ColumnAttributeContext ctx) {
            String extra;
            if (ctx.NOT_SYMBOL() != null && ctx.nullLiteral() != null) {
                this.currentColumn.setNullable("NO");
            }
            String defaultValue = null;
            String string = extra = StringUtils.isNotBlank((String)this.currentColumn.getExtra()) ? this.currentColumn.getExtra() : " ";
            if (ctx.DEFAULT_SYMBOL() != null) {
                if (ctx.signedLiteral() != null) {
                    defaultValue = DRDSTableMetaResolver.this.parseTextOrIdentifier(ctx.signedLiteral().getText());
                } else if (ctx.NOW_SYMBOL() != null) {
                    defaultValue = "CURRENT_TIMESTAMP";
                    if (ctx.timeFunctionParameters() != null) {
                        defaultValue = defaultValue + ctx.timeFunctionParameters().getText();
                    }
                    extra = extra + " " + "DEFAULT_GENERATED";
                } else if (ctx.exprWithParentheses() != null) {
                    MySQLParser.ExprWithParenthesesContext exprContext = ctx.exprWithParentheses();
                    defaultValue = DRDSTableMetaResolver.this.parseTextOrIdentifier(exprContext.getText());
                    extra = extra + " " + "DEFAULT_GENERATED";
                }
                if (ctx.signedLiteral() != null && ctx.signedLiteral().literal() != null && ctx.signedLiteral().literal().nullLiteral() != null) {
                    defaultValue = null;
                }
                this.currentColumn.setColumnDefault(defaultValue);
            }
            if (ctx.ON_SYMBOL() != null && ctx.UPDATE_SYMBOL() != null && ctx.NOW_SYMBOL() != null) {
                extra = extra + " " + "ON UPDATE CURRENT_TIMESTAMP";
                if (ctx.timeFunctionParameters() != null) {
                    extra = extra + ctx.timeFunctionParameters().getText();
                }
            }
            if (ctx.AUTO_INCREMENT_SYMBOL() != null) {
                extra = "auto_increment";
            }
            if (ctx.UNIQUE_SYMBOL() != null) {
                DrdsUniqueKey unique = this.generateUniqueForCurrentColumn();
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            } else if (ctx.KEY_SYMBOL() != null) {
                DrdsPrimaryKey primary = this.generatePrimaryForCurrentColumn();
                this.table.setPrimaryKey(primary);
            }
            if (ctx.COMMENT_SYMBOL() != null) {
                String comment = ctx.textLiteral().getText();
                this.currentColumn.setColumnComment(DRDSTableMetaResolver.this.parseTextOrIdentifier(comment));
            }
            if (ctx.collate() != null) {
                String collate = ctx.collate().getText();
                this.currentColumn.setCollationName(DRDSTableMetaResolver.this.parseTextOrIdentifier(collate));
            }
            if (ctx.SRID_SYMBOL() != null) {
                this.currentColumn.setSrid(Integer.parseInt(ctx.getText()));
            }
            this.currentColumn.setExtra(StringUtils.isNotBlank((String)extra) ? extra.trim() : null);
        }

        public void enterGcolAttribute(MySQLParser.GcolAttributeContext ctx) {
            if (ctx.UNIQUE_SYMBOL() != null) {
                DrdsUniqueKey unique = this.generateUniqueForCurrentColumn();
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            } else if (ctx.KEY_SYMBOL() != null) {
                DrdsPrimaryKey primary = this.generatePrimaryForCurrentColumn();
                this.table.setPrimaryKey(primary);
            }
            if (ctx.COMMENT_SYMBOL() != null) {
                String comment = ctx.COMMENT_SYMBOL().getText();
                this.currentColumn.setColumnComment(DRDSTableMetaResolver.this.parseTextOrIdentifier(comment));
            }
            if (ctx.NULL_SYMBOL() != null) {
                if (ctx.notRule() != null) {
                    this.currentColumn.setNullable("NO");
                }
                this.currentColumn.setNullable("YES");
            }
        }

        public void enterTableConstraintDef(MySQLParser.TableConstraintDefContext ctx) {
            DrdsIndex index;
            if ((ctx.KEY_SYMBOL() != null || ctx.INDEX_SYMBOL() != null) && ctx.FOREIGN_SYMBOL() == null && ctx.PRIMARY_SYMBOL() == null) {
                index = this.resolveIndex(ctx);
                this.table.getIndexMapping().put(index.getIndexName(), index);
            }
            if (ctx.FULLTEXT_SYMBOL() != null || ctx.SPATIAL_SYMBOL() != null) {
                index = this.resolveFullTextAndSpatialIndex(ctx);
                this.table.getIndexMapping().put(index.getIndexName(), index);
            }
            if (ctx.PRIMARY_SYMBOL() != null) {
                DrdsPrimaryKey primaryKey = (DrdsPrimaryKey)this.resolvePrimaryOrUnique(ctx);
                this.table.setPrimaryKey(primaryKey);
            }
            if (ctx.UNIQUE_SYMBOL() != null && ctx.GLOBAL_SYMBOL() == null) {
                DrdsUniqueKey unique = (DrdsUniqueKey)this.resolvePrimaryOrUnique(ctx);
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            }
            if (ctx.GLOBAL_SYMBOL() != null) {
                index = this.resolveIndex(ctx);
                this.table.getIndexMapping().put(index.getIndexName(), index);
            }
        }

        public void enterDrdsPartitionClause(MySQLParser.DrdsPartitionClauseContext ctx) {
            DrdsTablePartition drdsTablePartition = new DrdsTablePartition((DrdsSchema)this.table.getSchema());
            drdsTablePartition.setObjectName(this.table.getObjectName());
            String partitionMethod = this.getPartitionMethod(ctx.drdsPartitionAlgorithm().getText());
            List<String> partitionColumns = this.getPartitionColumns(ctx.drdsPartitionAlgorithm());
            String partitionExpress = this.getPartitionExpress(ctx.drdsPartitionAlgorithm());
            String tbPartitionMethod = null;
            List<String> tbPartitionColumns = null;
            String subPartitionExpress = null;
            int tbPartitionNum = 0;
            if (ctx.tbPartitionOption() != null) {
                tbPartitionMethod = this.getPartitionMethod(ctx.tbPartitionOption().drdsPartitionAlgorithm().getText());
                tbPartitionColumns = this.getPartitionColumns(ctx.tbPartitionOption().drdsPartitionAlgorithm());
                subPartitionExpress = this.getPartitionExpress(ctx.tbPartitionOption().drdsPartitionAlgorithm());
                if (ctx.tbPartitionOption().real_ulong_number() != null) {
                    tbPartitionNum = Integer.parseInt(ctx.tbPartitionOption().real_ulong_number().getText());
                }
            }
            AbstractDrdsPartition.Partition dbPartition = new AbstractDrdsPartition.Partition(partitionMethod, partitionColumns, 8);
            AbstractDrdsPartition.Partition tbPartition = null;
            if (tbPartitionMethod != null) {
                tbPartition = new AbstractDrdsPartition.Partition(tbPartitionMethod, tbPartitionColumns, tbPartitionNum);
                tbPartition.setPartitionExpress(subPartitionExpress);
            }
            drdsTablePartition.setDbPartition(dbPartition);
            dbPartition.setPartitionExpress(partitionExpress);
            if (tbPartition != null) {
                drdsTablePartition.setTablePartition(tbPartition);
            }
            this.table.setTablePartition(drdsTablePartition);
        }

        private String getPartitionExpress(MySQLParser.DrdsPartitionAlgorithmContext drdsPartitionAlgorithm) {
            String text = drdsPartitionAlgorithm.getText();
            return text.substring(text.indexOf("(") + 1, text.lastIndexOf(")"));
        }

        private List<String> getPartitionColumns(MySQLParser.DrdsPartitionAlgorithmContext drdsPartitionAlgorithm) {
            if (CollectionUtils.isNotEmpty((Collection)drdsPartitionAlgorithm.columnName())) {
                return drdsPartitionAlgorithm.columnName().stream().map(v -> DRDSTableMetaResolver.this.parseTextOrIdentifier(v.getText())).collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }

        private String getPartitionMethod(String text) {
            return text.substring(0, text.indexOf("(")).toUpperCase(Locale.ROOT);
        }

        private <T> T resolvePrimaryOrUnique(MySQLParser.TableConstraintDefContext ctx) {
            boolean isPrimary = ctx.PRIMARY_SYMBOL() != null;
            String indexName = isPrimary ? this.table.getObjectName() + GEN_PRIMARY_NAME : this.table.getObjectName() + GEN_UNIQUE_NAME + ++this.genUniqueId;
            MySQLParser.IndexNameAndTypeContext indexNameContext = ctx.indexNameAndType();
            if (indexNameContext != null) {
                indexName = DRDSTableMetaResolver.this.parseTextOrIdentifier(indexNameContext.getText());
            }
            String constraintName = indexName;
            MySQLParser.ConstraintNameContext constraintNameContext = ctx.constraintName();
            if (constraintNameContext != null) {
                constraintName = DRDSTableMetaResolver.this.parseTextOrIdentifier(constraintNameContext.getText());
            }
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(ctx.keyListVariants());
            String comment = null;
            String indexType = "BTREE";
            List indexOptionCtx = ctx.indexOption();
            for (int i = 0; i < indexOptionCtx.size(); ++i) {
                MySQLParser.IndexTypeClauseContext indexTypeCtx;
                MySQLParser.IndexOptionContext indexCtx = (MySQLParser.IndexOptionContext)indexOptionCtx.get(i);
                MySQLParser.CommonIndexOptionContext commonIdxCtx = indexCtx.commonIndexOption();
                if (commonIdxCtx != null && commonIdxCtx.COMMENT_SYMBOL() != null) {
                    comment = DRDSTableMetaResolver.this.parseTextOrIdentifier(commonIdxCtx.textLiteral().getText());
                }
                if ((indexTypeCtx = indexCtx.indexTypeClause()) == null) continue;
                indexType = indexTypeCtx.indexType().algorithm.getText();
            }
            AbstractMySqlConstraint constraint = isPrimary ? new DrdsPrimaryKey((DrdsSchema)this.table.getSchema()) : new DrdsUniqueKey((DrdsSchema)this.table.getSchema());
            constraint.setObjectName(this.table.getObjectName());
            constraint.setConstraintName(constraintName);
            constraint.setIndexName(indexName);
            constraint.getConstraintColumns().addAll(keyColumns);
            constraint.setComment(comment);
            constraint.setIndexType(indexType);
            return (T)constraint;
        }

        private DrdsIndex resolveFullTextAndSpatialIndex(MySQLParser.TableConstraintDefContext ctx) {
            String indexType;
            String indexName = this.table.getObjectName() + GEN_INDEX_NAME + ++this.genIndexId;
            String comment = null;
            String isVisible = "YES";
            MySQLParser.IndexNameContext indexNameContext = ctx.indexName();
            if (indexNameContext != null) {
                indexName = DRDSTableMetaResolver.this.parseTextOrIdentifier(indexNameContext.getText());
            }
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(ctx.keyListVariants());
            ArrayList commonIndexOptionContexts = new ArrayList();
            if (ctx.FULLTEXT_SYMBOL() != null) {
                indexType = "FULLTEXT";
                ctx.fulltextIndexOption().stream().map(MySQLParser.FulltextIndexOptionContext::commonIndexOption).forEach(commonIndexOptionContexts::add);
            } else if (ctx.SPATIAL_SYMBOL() != null) {
                indexType = "SPATIAL";
                ctx.spatialIndexOption().stream().map(MySQLParser.SpatialIndexOptionContext::commonIndexOption).forEach(commonIndexOptionContexts::add);
            } else {
                throw new IllegalArgumentException("Failed to resolve meta data, can't resolve non-fulltext and non-spatial index");
            }
            for (MySQLParser.CommonIndexOptionContext commonContext : commonIndexOptionContexts) {
                if (commonContext.COMMENT_SYMBOL() != null) {
                    comment = DRDSTableMetaResolver.this.parseTextOrIdentifier(commonContext.textLiteral().textStringLiteral(0).getText());
                }
                if (commonContext.visibility() == null || commonContext.visibility().INVISIBLE_SYMBOL() == null) continue;
                isVisible = "NO";
            }
            DrdsIndex index = new DrdsIndex((DrdsSchema)this.table.getSchema());
            index.setObjectName(this.table.getObjectName());
            index.setIndexSchema(this.table.getSchemaName());
            index.setNonunique(1);
            index.setIndexName(indexName);
            index.setIndexType(indexType);
            index.setIndexComment(comment);
            index.setVisible(isVisible);
            index.getIndexColumns().addAll(keyColumns);
            return index;
        }

        private DrdsIndex resolveIndex(MySQLParser.TableConstraintDefContext ctx) {
            String indexName = this.table.getObjectName() + GEN_INDEX_NAME + ++this.genIndexId;
            String indexType = "BTREE";
            String comment = null;
            String isVisible = "YES";
            MySQLParser.IndexNameAndTypeContext indexNameAndTypeContext = ctx.indexNameAndType();
            if (indexNameAndTypeContext != null) {
                Pair<String, String> indexNameAndType = this.resolveIndexNameAndType(indexNameAndTypeContext);
                indexName = (String)indexNameAndType.getLeft();
                indexType = (String)indexNameAndType.getRight();
            }
            if (ctx.USING_SYMBOL() != null) {
                indexType = ctx.indexType().algorithm.getText();
            }
            MySQLParser.KeyListVariantsContext keyListVariants = ctx.keyListVariants();
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(keyListVariants);
            List indexOptionContexts = ctx.indexOption();
            for (int i = 0; i < indexOptionContexts.size(); ++i) {
                MySQLParser.IndexTypeClauseContext indexTypeClauseContext;
                MySQLParser.IndexOptionContext indexOptionContext = (MySQLParser.IndexOptionContext)indexOptionContexts.get(i);
                MySQLParser.CommonIndexOptionContext commonContext = indexOptionContext.commonIndexOption();
                if (commonContext != null) {
                    if (commonContext.COMMENT_SYMBOL() != null) {
                        comment = DRDSTableMetaResolver.this.parseTextOrIdentifier(commonContext.textLiteral().textStringLiteral(0).getText());
                    }
                    if (commonContext.visibility() != null && commonContext.visibility().INVISIBLE_SYMBOL() != null) {
                        isVisible = "NO";
                    }
                }
                if ((indexTypeClauseContext = indexOptionContext.indexTypeClause()) == null) continue;
                indexType = indexTypeClauseContext.indexType().algorithm.getText();
            }
            DrdsIndex index = new DrdsIndex((DrdsSchema)this.table.getSchema());
            index.setObjectName(this.table.getObjectName());
            index.setIndexSchema(this.table.getSchemaName());
            index.setNonunique(ctx.UNIQUE_SYMBOL() == null ? 1 : 0);
            index.setIndexName(indexName);
            index.setIndexType(indexType);
            index.setGlobal(ctx.GLOBAL_SYMBOL() != null);
            index.setIndexComment(comment);
            index.setVisible(isVisible);
            index.getIndexColumns().addAll(keyColumns);
            return index;
        }

        private List<KeyColumn> resolveKeyListVariantsContext(MySQLParser.KeyListVariantsContext context) {
            ArrayList<KeyColumn> keyColumns;
            block5: {
                block4: {
                    keyColumns = new ArrayList<KeyColumn>();
                    MySQLParser.KeyListWithExpressionContext keyListWithExpressionContext = context.keyListWithExpression();
                    if (keyListWithExpressionContext == null) break block4;
                    List keyContexts = keyListWithExpressionContext.keyPartOrExpression();
                    for (int i = 0; i < keyContexts.size(); ++i) {
                        MySQLParser.KeyPartOrExpressionContext keyContext = (MySQLParser.KeyPartOrExpressionContext)keyContexts.get(i);
                        KeyColumn keyColumn = null;
                        if (keyContext.keyPart() != null) {
                            keyColumn = this.resolveKeyPart(keyContext.keyPart(), i);
                        }
                        if (keyContext.exprWithParentheses() != null) {
                            String expr = keyContext.exprWithParentheses().getText();
                            keyColumn = new KeyColumn(expr, 1);
                            keyColumn.setExpression(true);
                        }
                        keyColumns.add(keyColumn);
                    }
                    break block5;
                }
                MySQLParser.KeyListContext keyListContext = context.keyList();
                if (keyListContext == null) break block5;
                List keyPartContexts = keyListContext.keyPart();
                for (int i = 0; i < keyPartContexts.size(); ++i) {
                    MySQLParser.KeyPartContext keyPartContext = (MySQLParser.KeyPartContext)keyPartContexts.get(i);
                    KeyColumn keyColumn = this.resolveKeyPart(keyPartContext, i);
                    keyColumns.add(keyColumn);
                }
            }
            return keyColumns;
        }

        private KeyColumn resolveKeyPart(MySQLParser.KeyPartContext keyPart, int columnIndex) {
            String columnName = DRDSTableMetaResolver.this.parseTextOrIdentifier(keyPart.identifier().getText());
            String subPart = null;
            if (keyPart.fieldLength() != null) {
                subPart = DRDSTableMetaResolver.this.parseTextOrIdentifier(keyPart.fieldLength().getText());
            }
            String collection = "ASC";
            if (keyPart.direction() != null && keyPart.direction().DESC_SYMBOL() != null) {
                collection = "DESC";
            }
            return new KeyColumn(columnName, columnIndex, subPart, collection);
        }

        private Pair<String, String> resolveIndexNameAndType(MySQLParser.IndexNameAndTypeContext context) {
            String indexName = DRDSTableMetaResolver.this.parseTextOrIdentifier(context.indexName().getText());
            String indexType = "BTREE";
            MySQLParser.IndexTypeContext indexTypeContext = context.indexType();
            if (indexTypeContext != null) {
                indexType = indexTypeContext.algorithm.getText();
            }
            return new Pair((Object)indexName, (Object)indexType);
        }

        public void enterCreateTableOptions(MySQLParser.CreateTableOptionsContext ctx) {
            List tableOptions = ctx.createTableOption();
            for (MySQLParser.CreateTableOptionContext oCtx : tableOptions) {
                MySQLParser.DefaultCollationContext collationContext;
                MySQLParser.DefaultCharsetContext charsetContext;
                if (oCtx.option != null) {
                    String option;
                    switch (option = oCtx.option.getText()) {
                        case "ENGINE": {
                            String engine = DRDSTableMetaResolver.this.parseTextOrIdentifier(oCtx.engineRef().textOrIdentifier().getText());
                            this.table.setEngine(engine);
                            break;
                        }
                        case "ROW_FORMAT": {
                            String rowFormat = oCtx.format.getText();
                            this.table.setRowFormat(rowFormat);
                            break;
                        }
                        case "AUTO_INCREMENT": {
                            BigDecimal autoIncr = new BigDecimal(oCtx.ulonglong_number().getText());
                            this.table.setAutoIncrement(autoIncr);
                            break;
                        }
                        case "COMMENT": {
                            String comment = DRDSTableMetaResolver.this.parseTextOrIdentifier(oCtx.textStringLiteral().value.getText());
                            this.table.setTableComment(comment);
                            break;
                        }
                    }
                }
                if ((charsetContext = oCtx.defaultCharset()) != null) {
                    String charset = DRDSTableMetaResolver.this.parseTextOrIdentifier(charsetContext.charsetName().getText());
                    this.table.setCharacterSetName(charset);
                }
                if ((collationContext = oCtx.defaultCollation()) == null) continue;
                String collation = DRDSTableMetaResolver.this.parseTextOrIdentifier(collationContext.collationName().getText());
                this.table.setTableCollation(collation);
            }
        }

        private DrdsUniqueKey generateUniqueForCurrentColumn() {
            DrdsUniqueKey unique = new DrdsUniqueKey((DrdsSchema)this.table.getSchema());
            unique.setObjectName(this.table.getObjectName());
            unique.setConstraintName(this.table.getObjectName() + GEN_UNIQUE_NAME + ++this.genUniqueId);
            KeyColumn keyColumn = new KeyColumn(this.currentColumn.getColumnName(), 1);
            unique.getConstraintColumns().add(keyColumn);
            return unique;
        }

        private DrdsPrimaryKey generatePrimaryForCurrentColumn() {
            DrdsPrimaryKey primary = new DrdsPrimaryKey((DrdsSchema)this.table.getSchema());
            primary.setObjectName(this.table.getObjectName());
            primary.setConstraintName(this.table.getObjectName() + GEN_PRIMARY_NAME);
            KeyColumn keyColumn = new KeyColumn(this.currentColumn.getColumnName(), 1);
            primary.getConstraintColumns().add(keyColumn);
            return primary;
        }

        private void convertSynonymsDataType(DrdsColumn column) {
            String dataType;
            switch (dataType = column.getDataType().toUpperCase(Locale.getDefault())) {
                case "CHAR VARYING": {
                    dataType = "VARCHAR";
                    break;
                }
                case "DEC": 
                case "NUMERIC": 
                case "FIXED": {
                    dataType = "DECIMAL";
                    break;
                }
                case "INTEGER": {
                    dataType = "INT";
                    break;
                }
                case "REAL": 
                case "DOUBLE PRECISION": {
                    dataType = "DOUBLE";
                    break;
                }
                default: {
                    if (!column.isBinary()) break;
                    if ("CHAR".equalsIgnoreCase(dataType)) {
                        dataType = "BINARY";
                        break;
                    }
                    if ("VARCHAR".equalsIgnoreCase(dataType)) {
                        dataType = "VARBINARY";
                        break;
                    }
                    if (!"TEXT".equalsIgnoreCase(dataType)) break;
                    dataType = "BLOB";
                }
            }
            column.setDataType(dataType.toLowerCase(Locale.getDefault()));
        }

        private void fillColumnType(DrdsColumn column) {
            if (StringUtils.isNotBlank((String)column.getColumnType())) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String dataType = column.getDataType();
            sb.append(dataType);
            switch (dataType = dataType.toUpperCase(Locale.getDefault())) {
                case "BIT": {
                    if (column.getNumericPrecision() == null) {
                        column.setNumericPrecision(1);
                    }
                    sb.append("(").append(column.getNumericPrecision()).append(")");
                    break;
                }
                case "SMALLINT": 
                case "MEDIUMINT": 
                case "INT": 
                case "INTEGER": 
                case "BIGINT": {
                    if (column.getNumericPrecision() == null) break;
                    sb.append("(").append(column.getNumericPrecision()).append(")");
                    break;
                }
                case "DECIMAL": 
                case "DEC": 
                case "FIXED": {
                    if (column.getNumericPrecision() == null) {
                        column.setNumericPrecision(10);
                    }
                    if (column.getNumericScale() == null) {
                        column.setNumericScale(0);
                    }
                    sb.append("(").append(column.getNumericPrecision()).append(",").append(column.getNumericScale()).append(")");
                    break;
                }
                case "FLOAT": 
                case "DOUBLE": 
                case "DOUBLE PRECISION": 
                case "REAL": {
                    if (column.getNumericScale() == null) break;
                    sb.append("(").append(column.getNumericPrecision()).append(",").append(column.getNumericScale()).append(")");
                    break;
                }
                case "BOOLEAN": 
                case "BOOL": {
                    column.setDataType("TINYINT".toLowerCase(Locale.getDefault()));
                    sb = new StringBuilder("tinyint(1)");
                    break;
                }
                case "DATETIME": 
                case "TIMESTAMP": 
                case "TIME": {
                    if (column.getDateTimePrecision() == null) break;
                    sb.append("(").append(column.getDateTimePrecision()).append(")");
                    break;
                }
                case "CHAR": 
                case "BINARY": 
                case "VARCHAR": 
                case "VARBINARY": {
                    if (column.getCharacterMaximumLength() == null) {
                        column.setCharacterMaximumLength(1L);
                    }
                    sb.append("(").append(column.getCharacterMaximumLength()).append(")");
                    break;
                }
                case "ENUM": 
                case "SET": {
                    List<String> values = column.getTypeValues();
                    sb.append("(");
                    values = values.stream().map(v -> "'" + v + "'").collect(Collectors.toList());
                    sb.append(String.join((CharSequence)",", values));
                    sb.append(")");
                    break;
                }
            }
            if (column.isUnsigned()) {
                sb.append(" ").append("UNSIGNED".toLowerCase(Locale.getDefault()));
            }
            if (column.isZerofill()) {
                sb.append(" ").append("ZEROFILL".toLowerCase(Locale.getDefault()));
            }
            column.setColumnType(sb.toString());
        }

        private Long resolveFiledLength(MySQLParser.FieldLengthContext ctx) {
            String filedLength = ctx.getText();
            return Long.parseLong(filedLength.substring(1, filedLength.length() - 1));
        }
    }
}

