/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.resolver.mysql;

import com.alipay.oceanbase.antlr.constant.DBVersion;
import com.alipay.oceanbase.antlr.util.OBUtil;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTable;
import com.oceanbase.obtools.dbdiff.resolver.AbstractDdlMetaResolver;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMysqlTableMetaResolver
extends AbstractDdlMetaResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractMysqlTableMetaResolver.class);
    private final long serverVersion;
    private static final long polarDbDefaultVersion = 80000L;

    public AbstractMysqlTableMetaResolver(AbstractMySqlTable table) {
        this.serverVersion = this.parseMysqlAntlrVersion(table.getDbType());
    }

    protected long parseMysqlAntlrVersion(DbType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException("dbType is null.");
        }
        if (DbType.MYSQL_55.getType().equals(dbType.getType())) {
            String[] s = dbType.getRealVersion().toString().split("\\.");
            String antlrVersion = s[0];
            if (s.length == 1) {
                antlrVersion = antlrVersion + "0000";
            } else if (s.length == 2) {
                antlrVersion = antlrVersion + (s[1].length() == 1 ? "0" + s[1] : s[1]);
                antlrVersion = antlrVersion + "00";
            } else {
                antlrVersion = antlrVersion + (s[1].length() == 1 ? "0" + s[1] : s[1]);
                antlrVersion = antlrVersion + (s[2].length() == 1 ? "0" + s[2] : s[2]);
            }
            if (StringUtils.isNumeric((String)antlrVersion)) {
                return Long.parseLong(antlrVersion);
            }
            throw new IllegalArgumentException(String.format("failed to parse antlr mysql with [%s] and mysql antlr version [%s]", dbType, antlrVersion));
        }
        if (DbType.POLARX_10.getType().equals(dbType.getType())) {
            return 80000L;
        }
        throw new IllegalArgumentException("unsupported to parse antlr mysql version with " + dbType);
    }

    @Override
    protected Lexer sqlLexer(CharStream charStream) {
        return OBUtil.getMySQLSqlLexer((DBVersion)DBVersion.MYSQL, (CharStream)charStream, (long)this.serverVersion);
    }

    @Override
    protected Parser sqlParser(CommonTokenStream tokens) {
        return OBUtil.getSqlParser((DBVersion)DBVersion.MYSQL, (TokenStream)tokens);
    }

    @Override
    protected String parserTreeRootName() {
        return "query";
    }

    protected String parseTextOrIdentifier(String str) {
        if (StringUtils.isEmpty((String)str) || str.length() < 2) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("`") && str.endsWith("`") || str.startsWith("'") && str.endsWith("'") || str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }
}

