/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.resolver.mysql;

import com.alipay.oceanbase.g4.mysql.MySQLParser;
import com.alipay.oceanbase.g4.mysql.MySQLParserBaseListener;
import com.oceanbase.obtools.common.model.Pair;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.exception.AntlrResolveException;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlConstraint;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Column;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56ForeignKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56PrimaryKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Table;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56TablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56UniqueKey;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql80Check;
import com.oceanbase.obtools.dbdiff.resolver.mysql.AbstractMysqlTableMetaResolver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.lang.StringUtils;

public class MysqlTableMetaResolver
extends AbstractMysqlTableMetaResolver {
    private final MySql56Table table;

    public MysqlTableMetaResolver(MySql56Table table) {
        super(table);
        this.table = table;
    }

    @Override
    protected ParseTreeListener parserTreeListener() {
        return new Resolver();
    }

    protected class Resolver
    extends MySQLParserBaseListener {
        private static final String GEN_INDEX_NAME = "_gen_index_name_";
        private static final String GEN_PRIMARY_NAME = "_gen_primary_name";
        private static final String GEN_UNIQUE_NAME = "_gen_unique_name_";
        private static final String GEN_FOREIGN_NAME = "_gen_foreign_name_";
        private static final String GEN_CHECK_NAME = "_gen_check_name_";
        private static final String DEFAULT_PARTITION_NAME_FORMAT = "p%s";
        private static final String DEFAULT_SUB_PARTITION_NAME_FORMAT = "sp%s";
        private final MySql56Table table;
        private MySql56Column currentColumn;
        private boolean inFieldDefinition;
        private int genUniqueId = 0;
        private int genCheckId = 0;
        private int genForeignId = 0;
        private int genIndexId = 0;

        public Resolver() {
            this.table = MysqlTableMetaResolver.this.table;
        }

        public void exitCreateTable(MySQLParser.CreateTableContext ctx) {
            MySql56TablePartition partition = this.table.getTablePartition();
            if (partition != null) {
                partition.setColumnSet(this.table.getColumnMapping().keySet());
            }
        }

        public void enterTableName(MySQLParser.TableNameContext ctx) {
            String tableName;
            String schemaName = null;
            MySQLParser.DotIdentifierContext dotIdentifierContext = ctx.dotIdentifier();
            if (dotIdentifierContext != null) {
                tableName = MysqlTableMetaResolver.this.parseTextOrIdentifier(dotIdentifierContext.identifier().getText());
            } else {
                MySQLParser.QualifiedIdentifierContext qualifiedIdentifierContext = ctx.qualifiedIdentifier();
                tableName = MysqlTableMetaResolver.this.parseTextOrIdentifier(qualifiedIdentifierContext.identifier().getText());
                dotIdentifierContext = qualifiedIdentifierContext.dotIdentifier();
                if (dotIdentifierContext != null) {
                    schemaName = tableName;
                    tableName = MysqlTableMetaResolver.this.parseTextOrIdentifier(dotIdentifierContext.identifier().getText());
                }
            }
            if (StringUtils.isNotBlank(schemaName)) {
                this.table.getSchema().setSchemaName(schemaName);
            }
            this.table.setObjectName(tableName);
        }

        public void enterColumnDefinition(MySQLParser.ColumnDefinitionContext ctx) {
            this.currentColumn = new MySql56Column((MySql56Schema)this.table.getSchema());
            this.currentColumn.setObjectName(this.table.getObjectName());
            this.currentColumn.setNullable("YES");
            String columnName = ctx.columnName().getText();
            this.currentColumn.setColumnName(MysqlTableMetaResolver.this.parseTextOrIdentifier(columnName));
        }

        public void exitColumnDefinition(MySQLParser.ColumnDefinitionContext ctx) {
            this.convertSynonymsDataType(this.currentColumn);
            this.fillColumnType(this.currentColumn);
            this.table.getColumnMapping().put(this.currentColumn.getColumnName(), this.currentColumn);
            this.currentColumn = null;
        }

        private void convertSynonymsDataType(MySql56Column column) {
            String dataType;
            switch (dataType = column.getDataType().toUpperCase(Locale.getDefault())) {
                case "CHAR VARYING": {
                    dataType = "VARCHAR";
                    break;
                }
                case "DEC": 
                case "NUMERIC": 
                case "FIXED": {
                    dataType = "DECIMAL";
                    break;
                }
                case "INTEGER": {
                    dataType = "INT";
                    break;
                }
                case "REAL": 
                case "DOUBLE PRECISION": {
                    dataType = "DOUBLE";
                    break;
                }
                default: {
                    if (!column.isBinary()) break;
                    if ("CHAR".equalsIgnoreCase(dataType)) {
                        dataType = "BINARY";
                        break;
                    }
                    if ("VARCHAR".equalsIgnoreCase(dataType)) {
                        dataType = "VARBINARY";
                        break;
                    }
                    if (!"TEXT".equalsIgnoreCase(dataType)) break;
                    dataType = "BLOB";
                }
            }
            column.setDataType(dataType.toLowerCase(Locale.getDefault()));
        }

        public void enterFieldDefinition(MySQLParser.FieldDefinitionContext ctx) {
            this.inFieldDefinition = true;
            if (ctx.AS_SYMBOL() != null) {
                MySQLParser.ExprWithParenthesesContext exprContext = ctx.exprWithParentheses();
                String expr = MysqlTableMetaResolver.this.parseTextOrIdentifier(exprContext.getText());
                String extra = "VIRTUAL GENERATED";
                if (ctx.STORED_SYMBOL() != null) {
                    extra = "STORED GENERATED";
                }
                this.currentColumn.setGenerationExpression(expr);
                this.currentColumn.setExtra(extra);
            }
        }

        public void exitFieldDefinition(MySQLParser.FieldDefinitionContext ctx) {
            this.inFieldDefinition = false;
        }

        public void enterDataType(MySQLParser.DataTypeContext ctx) {
            String dataType = ctx.type.getText().toLowerCase(Locale.getDefault());
            this.currentColumn.setDataType(dataType);
        }

        public void enterFieldLength(MySQLParser.FieldLengthContext ctx) {
            String dataType;
            Long filedLength = this.resolveFiledLength(ctx);
            switch (dataType = this.currentColumn.getDataType().toUpperCase(Locale.getDefault())) {
                case "INT": 
                case "INTEGER": 
                case "TINYINT": 
                case "SMALLINT": 
                case "MEDIUMINT": 
                case "BIGINT": 
                case "BIT": 
                case "FLOAT": 
                case "DECIMAL": 
                case "NUMERIC": 
                case "FIXED": {
                    this.currentColumn.setNumericPrecision(filedLength.intValue());
                    break;
                }
                case "CHAR": 
                case "VARCHAR": 
                case "BINARY": 
                case "VARBINARY": {
                    this.currentColumn.setCharacterMaximumLength(filedLength);
                }
            }
        }

        private Long resolveFiledLength(MySQLParser.FieldLengthContext ctx) {
            String filedLength = ctx.getText();
            return Long.parseLong(filedLength.substring(1, filedLength.length() - 1));
        }

        public void enterPrecision(MySQLParser.PrecisionContext ctx) {
            String dataType;
            switch (dataType = this.currentColumn.getDataType().toUpperCase(Locale.getDefault())) {
                case "REAL": 
                case "DOUBLE PRECISION": 
                case "DEC": 
                case "DOUBLE": 
                case "FLOAT": 
                case "DECIMAL": 
                case "NUMERIC": 
                case "FIXED": {
                    this.currentColumn.setNumericPrecision(Integer.parseInt(ctx.INT_NUMBER(0).getText()));
                    this.currentColumn.setNumericScale(Integer.parseInt(ctx.INT_NUMBER(1).getText()));
                }
            }
        }

        public void enterTypeDatetimePrecision(MySQLParser.TypeDatetimePrecisionContext ctx) {
            Integer precision = Integer.parseInt(ctx.INT_NUMBER().getText());
            this.currentColumn.setDateTimePrecision(precision);
        }

        public void enterStringList(MySQLParser.StringListContext ctx) {
            String dataType;
            switch (dataType = this.currentColumn.getDataType().toUpperCase(Locale.getDefault())) {
                case "ENUM": 
                case "SET": {
                    List items = ctx.textString();
                    items.stream().map(item -> item.getText().substring(1, item.getText().length() - 1)).forEach(item -> this.currentColumn.getTypeValues().add((String)item));
                }
            }
        }

        public void enterFieldOptions(MySQLParser.FieldOptionsContext ctx) {
            this.currentColumn.setSigned(CollectionUtils.isNotEmpty((Collection)ctx.SIGNED_SYMBOL()));
            this.currentColumn.setUnsigned(CollectionUtils.isNotEmpty((Collection)ctx.UNSIGNED_SYMBOL()));
            this.currentColumn.setZerofill(CollectionUtils.isNotEmpty((Collection)ctx.ZEROFILL_SYMBOL()));
        }

        public void enterCharsetWithOptBinary(MySQLParser.CharsetWithOptBinaryContext ctx) {
            MySQLParser.CharsetNameContext charsetNameContext;
            MySQLParser.UnicodeContext unicode;
            if (!this.inFieldDefinition) {
                return;
            }
            this.currentColumn.setBinary(ctx.BINARY_SYMBOL() != null);
            this.currentColumn.setByte(ctx.BYTE_SYMBOL() != null);
            MySQLParser.AsciiContext ascii = ctx.ascii();
            if (ascii != null) {
                this.currentColumn.setAscii(ascii.ASCII_SYMBOL() != null);
                this.currentColumn.setBinary(ascii.BINARY_SYMBOL() != null);
            }
            if ((unicode = ctx.unicode()) != null) {
                this.currentColumn.setUnicode(unicode.UNICODE_SYMBOL() != null);
                this.currentColumn.setBinary(unicode.BINARY_SYMBOL() != null);
            }
            if ((charsetNameContext = ctx.charsetName()) != null) {
                this.currentColumn.setBinary(charsetNameContext.BINARY_SYMBOL() != null);
                MySQLParser.TextOrIdentifierContext textContext = charsetNameContext.textOrIdentifier();
                if (textContext != null) {
                    String charsetName = textContext.getText();
                    this.currentColumn.setCharacterSetName(MysqlTableMetaResolver.this.parseTextOrIdentifier(charsetName));
                }
            }
        }

        public void enterColumnAttribute(MySQLParser.ColumnAttributeContext ctx) {
            String extra;
            if (ctx.NOT_SYMBOL() != null && ctx.nullLiteral() != null) {
                this.currentColumn.setNullable("NO");
            }
            String defaultValue = null;
            String string = extra = StringUtils.isNotBlank((String)this.currentColumn.getExtra()) ? this.currentColumn.getExtra() : " ";
            if (ctx.DEFAULT_SYMBOL() != null) {
                if (ctx.signedLiteral() != null) {
                    defaultValue = MysqlTableMetaResolver.this.parseTextOrIdentifier(ctx.signedLiteral().getText());
                } else if (ctx.NOW_SYMBOL() != null) {
                    defaultValue = "CURRENT_TIMESTAMP";
                    if (ctx.timeFunctionParameters() != null) {
                        defaultValue = defaultValue + ctx.timeFunctionParameters().getText();
                    }
                    extra = extra + " " + "DEFAULT_GENERATED";
                } else if (ctx.exprWithParentheses() != null) {
                    MySQLParser.ExprWithParenthesesContext exprContext = ctx.exprWithParentheses();
                    defaultValue = MysqlTableMetaResolver.this.parseTextOrIdentifier(exprContext.getText());
                    extra = extra + " " + "DEFAULT_GENERATED";
                }
                if (ctx.signedLiteral() != null && ctx.signedLiteral().literal() != null && ctx.signedLiteral().literal().nullLiteral() != null) {
                    defaultValue = null;
                }
                this.currentColumn.setColumnDefault(defaultValue);
            }
            if (ctx.ON_SYMBOL() != null && ctx.UPDATE_SYMBOL() != null && ctx.NOW_SYMBOL() != null) {
                extra = extra + " " + "ON UPDATE CURRENT_TIMESTAMP";
                if (ctx.timeFunctionParameters() != null) {
                    extra = extra + ctx.timeFunctionParameters().getText();
                }
            }
            if (ctx.AUTO_INCREMENT_SYMBOL() != null) {
                extra = "auto_increment";
            }
            if (ctx.UNIQUE_SYMBOL() != null) {
                MySql56UniqueKey unique = this.generateUniqueForCurrentColumn();
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            } else if (ctx.KEY_SYMBOL() != null) {
                MySql56PrimaryKey primary = this.generatePrimaryForCurrentColumn();
                this.table.setPrimaryKey(primary);
            }
            if (ctx.COMMENT_SYMBOL() != null) {
                String comment = ctx.textLiteral().getText();
                this.currentColumn.setColumnComment(MysqlTableMetaResolver.this.parseTextOrIdentifier(comment));
            }
            if (ctx.collate() != null) {
                String collate = ctx.collate().getText();
                this.currentColumn.setCollationName(MysqlTableMetaResolver.this.parseTextOrIdentifier(collate));
            }
            if (ctx.SRID_SYMBOL() != null) {
                this.currentColumn.setSrid(Integer.parseInt(ctx.getText()));
            }
            if (ctx.checkConstraint() != null) {
                String constraintName = ctx.constraintName() != null ? ctx.constraintName().identifier().getText() : this.table.getObjectName() + GEN_CHECK_NAME + ++this.genCheckId;
                MySql80Check check = this.generateCheck(constraintName, ctx.checkConstraint().exprWithParentheses().getText());
                this.table.getCheckMapping().put(check.getConstraintName(), check);
            }
            this.currentColumn.setExtra(StringUtils.isNotBlank((String)extra) ? extra.trim() : null);
        }

        public void enterCollate(MySQLParser.CollateContext ctx) {
            if (!this.inFieldDefinition) {
                return;
            }
            String collation = ctx.collationName().getText();
            this.currentColumn.setCollationName(MysqlTableMetaResolver.this.parseTextOrIdentifier(collation));
        }

        public void enterGcolAttribute(MySQLParser.GcolAttributeContext ctx) {
            if (ctx.UNIQUE_SYMBOL() != null) {
                MySql56UniqueKey unique = this.generateUniqueForCurrentColumn();
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            } else if (ctx.KEY_SYMBOL() != null) {
                MySql56PrimaryKey primary = this.generatePrimaryForCurrentColumn();
                this.table.setPrimaryKey(primary);
            }
            if (ctx.COMMENT_SYMBOL() != null) {
                String comment = ctx.COMMENT_SYMBOL().getText();
                this.currentColumn.setColumnComment(MysqlTableMetaResolver.this.parseTextOrIdentifier(comment));
            }
            if (ctx.NULL_SYMBOL() != null) {
                if (ctx.notRule() != null) {
                    this.currentColumn.setNullable("NO");
                }
                this.currentColumn.setNullable("YES");
            }
        }

        public void enterCheckOrReferences(MySQLParser.CheckOrReferencesContext ctx) {
            MySQLParser.ReferencesContext refContext;
            MySQLParser.CheckConstraintContext checkContext = ctx.checkConstraint();
            if (checkContext != null) {
                String constraintName = this.table.getObjectName() + GEN_CHECK_NAME + ++this.genCheckId;
                String expr = ctx.checkConstraint().exprWithParentheses().getText();
                MySql80Check check = this.generateCheck(constraintName, expr);
                this.table.getCheckMapping().put(check.getConstraintName(), check);
            }
            if ((refContext = ctx.references()) != null) {
                MySql56ForeignKey foreignKey = new MySql56ForeignKey((MySql56Schema)this.table.getSchema());
                foreignKey.getConstraintColumns().add(new KeyColumn(this.currentColumn.getColumnName(), 0));
                this.fillForeignKey(foreignKey, refContext);
                foreignKey.setObjectName(this.table.getObjectName());
                foreignKey.setConstraintName(this.table.getObjectName() + GEN_FOREIGN_NAME + ++this.genForeignId);
                this.table.getForeignMapping().put(foreignKey.getConstraintName(), foreignKey);
            }
        }

        public void enterTableConstraintDef(MySQLParser.TableConstraintDefContext ctx) {
            MySQLParser.CheckConstraintContext checkContext;
            MySql56Index index;
            if ((ctx.KEY_SYMBOL() != null || ctx.INDEX_SYMBOL() != null) && ctx.FOREIGN_SYMBOL() == null && ctx.PRIMARY_SYMBOL() == null) {
                index = this.resolveIndex(ctx);
                this.table.getIndexMapping().put(index.getIndexName(), index);
            }
            if (ctx.FULLTEXT_SYMBOL() != null || ctx.SPATIAL_SYMBOL() != null) {
                index = this.resolveFullTextAndSpatialIndex(ctx);
                this.table.getIndexMapping().put(index.getIndexName(), index);
            }
            if (ctx.PRIMARY_SYMBOL() != null) {
                MySql56PrimaryKey primaryKey = (MySql56PrimaryKey)this.resolvePrimaryOrUnique(ctx);
                this.table.setPrimaryKey(primaryKey);
            }
            if (ctx.UNIQUE_SYMBOL() != null) {
                MySql56UniqueKey unique = (MySql56UniqueKey)this.resolvePrimaryOrUnique(ctx);
                this.table.getUniqueMapping().put(unique.getConstraintName(), unique);
            }
            if (ctx.FOREIGN_SYMBOL() != null) {
                MySql56ForeignKey foreignKey = this.resolveForeignKey(ctx);
                this.table.getForeignMapping().put(foreignKey.getConstraintName(), foreignKey);
            }
            if ((checkContext = ctx.checkConstraint()) != null) {
                MySql80Check check = this.resolveCheck(ctx);
                this.table.getCheckMapping().put(check.getConstraintName(), check);
            }
        }

        public void enterCreateTableOptions(MySQLParser.CreateTableOptionsContext ctx) {
            List tableOptions = ctx.createTableOption();
            for (MySQLParser.CreateTableOptionContext oCtx : tableOptions) {
                MySQLParser.DefaultCollationContext collationContext;
                MySQLParser.DefaultCharsetContext charsetContext;
                if (oCtx.option != null) {
                    String option;
                    switch (option = oCtx.option.getText()) {
                        case "ENGINE": {
                            String engine = MysqlTableMetaResolver.this.parseTextOrIdentifier(oCtx.engineRef().textOrIdentifier().getText());
                            this.table.setEngine(engine);
                            break;
                        }
                        case "ROW_FORMAT": {
                            String rowFormat = oCtx.format.getText();
                            this.table.setRowFormat(rowFormat);
                            break;
                        }
                        case "AUTO_INCREMENT": {
                            BigDecimal autoIncr = new BigDecimal(oCtx.ulonglong_number().getText());
                            this.table.setAutoIncrement(autoIncr);
                            break;
                        }
                        case "COMMENT": {
                            String comment = MysqlTableMetaResolver.this.parseTextOrIdentifier(oCtx.textStringLiteral().value.getText());
                            this.table.setTableComment(comment);
                            break;
                        }
                    }
                }
                if ((charsetContext = oCtx.defaultCharset()) != null) {
                    String charset = MysqlTableMetaResolver.this.parseTextOrIdentifier(charsetContext.charsetName().getText());
                    this.table.setCharacterSetName(charset);
                }
                if ((collationContext = oCtx.defaultCollation()) == null) continue;
                String collation = MysqlTableMetaResolver.this.parseTextOrIdentifier(collationContext.collationName().getText());
                this.table.setTableCollation(collation);
            }
        }

        public void enterPartitionClause(MySQLParser.PartitionClauseContext ctx) {
            MySQLParser.SubPartitionsContext subPartitionsContext;
            String partitionExpr;
            String partitionMethod;
            MySql56TablePartition partition = new MySql56TablePartition((MySql56Schema)this.table.getSchema());
            partition.setObjectName(this.table.getObjectName());
            String subpartitionMethod = null;
            String subpartitionExpr = null;
            MySQLParser.PartitionTypeDefContext partTypeDefContext = ctx.partitionTypeDef();
            if (partTypeDefContext.KEY_SYMBOL() != null) {
                partitionMethod = "KEY";
            } else if (partTypeDefContext.HASH_SYMBOL() != null) {
                partitionMethod = "HASH";
            } else if (partTypeDefContext.RANGE_SYMBOL() != null) {
                partitionMethod = "RANGE";
            } else if (partTypeDefContext.LIST_SYMBOL() != null) {
                partitionMethod = "LIST";
            } else {
                throw new AntlrResolveException("Failed to resolve partition method. grammar: " + partTypeDefContext.getText());
            }
            if (partTypeDefContext.LINEAR_SYMBOL() != null) {
                partitionMethod = "LINEAR " + partitionMethod;
            } else if (partTypeDefContext.COLUMNS_SYMBOL() != null) {
                partitionMethod = partitionMethod + " COLUMNS";
            }
            if (partTypeDefContext.identifierList() != null) {
                partitionExpr = partTypeDefContext.identifierList().getText();
            } else if (partTypeDefContext.bitExpr() != null) {
                partitionExpr = partTypeDefContext.bitExpr().getText();
            } else {
                throw new AntlrResolveException("Failed to resolve partition expression. grammar: " + partTypeDefContext.getText());
            }
            if (ctx.PARTITIONS_SYMBOL() != null) {
                long partitionNum = Long.parseLong(ctx.real_ulong_number().getText());
                int i = 0;
                while ((long)i < partitionNum) {
                    AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    String partName = String.format(DEFAULT_PARTITION_NAME_FORMAT, i);
                    partItem.setPartitionName(partName);
                    partItem.setPartitionOrdinalPosition(i + 1);
                    partition.getTablePartitions().add(partItem);
                    ++i;
                }
            }
            if (ctx.partitionDefinitions() != null) {
                this.resolvePartitionDefinitions(partition, ctx.partitionDefinitions());
            }
            if ((subPartitionsContext = ctx.subPartitions()) != null) {
                if (subPartitionsContext.HASH_SYMBOL() != null) {
                    subpartitionMethod = "HASH";
                    subpartitionExpr = subPartitionsContext.bitExpr().getText();
                }
                if (subPartitionsContext.KEY_SYMBOL() != null) {
                    subpartitionMethod = "KEY";
                    subpartitionExpr = subPartitionsContext.identifierListWithParentheses().identifierList().getText();
                }
                if (subPartitionsContext.SUBPARTITIONS_SYMBOL() != null) {
                    long subpartitionNum = Long.parseLong(subPartitionsContext.real_ulong_number().getText());
                    Collection<AbstractMySqlTablePartition.MySqlPartitionItem> tablePartitions = partition.getTablePartitions();
                    for (AbstractMySqlTablePartition.MySqlPartitionItem partitionItem : tablePartitions) {
                        ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> subpartitionItems = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
                        int i = 0;
                        while ((long)i < subpartitionNum) {
                            AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                            String partName = String.format(DEFAULT_SUB_PARTITION_NAME_FORMAT, i);
                            partItem.setPartitionName(partName);
                            partItem.setPartitionOrdinalPosition(i + 1);
                            subpartitionItems.add(partItem);
                            ++i;
                        }
                        partition.getTableSubPartitionMapping().put(partitionItem.getPartitionName(), subpartitionItems);
                    }
                }
            }
            partition.setPartitionMethod(partitionMethod);
            partition.setPartitionExpression(partitionExpr);
            partition.setSubPartitionMethod(subpartitionMethod);
            partition.setSubPartitionExpression(subpartitionExpr);
            this.table.setTablePartition(partition);
        }

        private void resolvePartitionDefinitions(MySql56TablePartition partition, MySQLParser.PartitionDefinitionsContext ctx) {
            List partDefineContexts = ctx.partitionDefinition();
            ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> partitionItems = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
            for (int i = 0; i < partDefineContexts.size(); ++i) {
                MySQLParser.PartitionDefinitionContext partDefine = (MySQLParser.PartitionDefinitionContext)partDefineContexts.get(i);
                String partName = MysqlTableMetaResolver.this.parseTextOrIdentifier(partDefine.identifier().getText());
                String partitionDescription = null;
                if (partDefine.partitionValueItemListParen() != null) {
                    partitionDescription = MysqlTableMetaResolver.this.parseTextOrIdentifier(partDefine.partitionValueItemListParen().getText());
                } else if (partDefine.partitionValuesIn() != null) {
                    partitionDescription = MysqlTableMetaResolver.this.parseTextOrIdentifier(partDefine.partitionValuesIn().getText());
                } else if (partDefine.MAXVALUE_SYMBOL() != null) {
                    partitionDescription = "MAXVALUE";
                }
                String comment = null;
                String tablespace = null;
                List partitionOptionContexts = partDefine.partitionOption();
                for (MySQLParser.PartitionOptionContext option : partitionOptionContexts) {
                    if (option.COMMENT_SYMBOL() != null) {
                        comment = MysqlTableMetaResolver.this.parseTextOrIdentifier(option.textLiteral().getText());
                    }
                    if (option.TABLESPACE_SYMBOL() == null) continue;
                    tablespace = MysqlTableMetaResolver.this.parseTextOrIdentifier(option.identifier().getText());
                }
                AbstractMySqlTablePartition.MySqlPartitionItem partItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                partItem.setPartitionName(partName);
                partItem.setPartitionDescription(partitionDescription);
                partItem.setPartitionOrdinalPosition(i + 1);
                partItem.setTablespaceName(tablespace);
                partItem.setPartitionComment(comment);
                partitionItems.add(partItem);
                List subpartitionContexts = partDefine.subpartitionDefinition();
                ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> subPartitions = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
                for (int j = 0; j < subpartitionContexts.size(); ++j) {
                    MySQLParser.SubpartitionDefinitionContext subPartContext = (MySQLParser.SubpartitionDefinitionContext)subpartitionContexts.get(j);
                    MySQLParser.TextOrIdentifierContext subPartNameContext = subPartContext.textOrIdentifier();
                    String subPartitionName = MysqlTableMetaResolver.this.parseTextOrIdentifier(subPartNameContext.getText());
                    String subpartComment = null;
                    String subpartTablespace = null;
                    List subPartOption = subPartContext.partitionOption();
                    for (MySQLParser.PartitionOptionContext option : subPartOption) {
                        if (option.COMMENT_SYMBOL() != null) {
                            subpartComment = MysqlTableMetaResolver.this.parseTextOrIdentifier(option.textLiteral().getText());
                        }
                        if (option.TABLESPACE_SYMBOL() == null) continue;
                        subpartTablespace = MysqlTableMetaResolver.this.parseTextOrIdentifier(option.identifier().getText());
                    }
                    AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    subPartItem.setSubPartitionName(subPartitionName);
                    subPartItem.setTablespaceName(subpartTablespace);
                    subPartItem.setPartitionComment(subpartComment);
                    subPartItem.setSubPartitionOrdinalPosition(j + 1);
                    subPartitions.add(subPartItem);
                }
                if (!CollectionUtils.isNotEmpty(subPartitions)) continue;
                partition.getTableSubPartitionMapping().put(partName, subPartitions);
            }
            partition.getTablePartitions().addAll(partitionItems);
        }

        private MySql56UniqueKey generateUniqueForCurrentColumn() {
            MySql56UniqueKey unique = new MySql56UniqueKey((MySql56Schema)this.table.getSchema());
            unique.setObjectName(this.table.getObjectName());
            unique.setConstraintName(this.table.getObjectName() + GEN_UNIQUE_NAME + ++this.genUniqueId);
            KeyColumn keyColumn = new KeyColumn(this.currentColumn.getColumnName(), 1);
            unique.getConstraintColumns().add(keyColumn);
            return unique;
        }

        private MySql56PrimaryKey generatePrimaryForCurrentColumn() {
            MySql56PrimaryKey primary = new MySql56PrimaryKey((MySql56Schema)this.table.getSchema());
            primary.setObjectName(this.table.getObjectName());
            primary.setConstraintName(this.table.getObjectName() + GEN_PRIMARY_NAME);
            KeyColumn keyColumn = new KeyColumn(this.currentColumn.getColumnName(), 1);
            primary.getConstraintColumns().add(keyColumn);
            return primary;
        }

        private MySql80Check generateCheck(String constraintName, String expr) {
            MySql80Check check = new MySql80Check((MySql56Schema)this.table.getSchema());
            check.setObjectName(this.table.getObjectName());
            check.setConstraintName(MysqlTableMetaResolver.this.parseTextOrIdentifier(constraintName));
            check.setCheckClause(MysqlTableMetaResolver.this.parseTextOrIdentifier(expr));
            return check;
        }

        private Pair<String, String> resolveIndexNameAndType(MySQLParser.IndexNameAndTypeContext context) {
            String indexName = MysqlTableMetaResolver.this.parseTextOrIdentifier(context.indexName().getText());
            String indexType = "BTREE";
            MySQLParser.IndexTypeContext indexTypeContext = context.indexType();
            if (indexTypeContext != null) {
                indexType = indexTypeContext.algorithm.getText();
            }
            return new Pair((Object)indexName, (Object)indexType);
        }

        private List<KeyColumn> resolveKeyListVariantsContext(MySQLParser.KeyListVariantsContext context) {
            ArrayList<KeyColumn> keyColumns;
            block5: {
                block4: {
                    keyColumns = new ArrayList<KeyColumn>();
                    MySQLParser.KeyListWithExpressionContext keyListWithExpressionContext = context.keyListWithExpression();
                    if (keyListWithExpressionContext == null) break block4;
                    List keyContexts = keyListWithExpressionContext.keyPartOrExpression();
                    for (int i = 0; i < keyContexts.size(); ++i) {
                        MySQLParser.KeyPartOrExpressionContext keyContext = (MySQLParser.KeyPartOrExpressionContext)keyContexts.get(i);
                        KeyColumn keyColumn = null;
                        if (keyContext.keyPart() != null) {
                            keyColumn = this.resolveKeyPart(keyContext.keyPart(), i);
                        }
                        if (keyContext.exprWithParentheses() != null) {
                            String expr = keyContext.exprWithParentheses().getText();
                            keyColumn = new KeyColumn(expr, 1);
                            keyColumn.setExpression(true);
                        }
                        keyColumns.add(keyColumn);
                    }
                    break block5;
                }
                MySQLParser.KeyListContext keyListContext = context.keyList();
                if (keyListContext == null) break block5;
                List keyPartContexts = keyListContext.keyPart();
                for (int i = 0; i < keyPartContexts.size(); ++i) {
                    MySQLParser.KeyPartContext keyPartContext = (MySQLParser.KeyPartContext)keyPartContexts.get(i);
                    KeyColumn keyColumn = this.resolveKeyPart(keyPartContext, i);
                    keyColumns.add(keyColumn);
                }
            }
            return keyColumns;
        }

        private MySql56Index resolveIndex(MySQLParser.TableConstraintDefContext ctx) {
            String indexName = this.table.getObjectName() + GEN_INDEX_NAME + ++this.genIndexId;
            String indexType = "BTREE";
            String comment = null;
            String isVisible = "YES";
            MySQLParser.IndexNameAndTypeContext indexNameAndTypeContext = ctx.indexNameAndType();
            if (indexNameAndTypeContext != null) {
                Pair<String, String> indexNameAndType = this.resolveIndexNameAndType(indexNameAndTypeContext);
                indexName = (String)indexNameAndType.getLeft();
                indexType = (String)indexNameAndType.getRight();
            }
            if (ctx.USING_SYMBOL() != null) {
                indexType = ctx.indexType().algorithm.getText();
            }
            MySQLParser.KeyListVariantsContext keyListVariants = ctx.keyListVariants();
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(keyListVariants);
            List indexOptionContexts = ctx.indexOption();
            for (int i = 0; i < indexOptionContexts.size(); ++i) {
                MySQLParser.IndexTypeClauseContext indexTypeClauseContext;
                MySQLParser.IndexOptionContext indexOptionContext = (MySQLParser.IndexOptionContext)indexOptionContexts.get(i);
                MySQLParser.CommonIndexOptionContext commonContext = indexOptionContext.commonIndexOption();
                if (commonContext != null) {
                    if (commonContext.COMMENT_SYMBOL() != null) {
                        comment = MysqlTableMetaResolver.this.parseTextOrIdentifier(commonContext.textLiteral().textStringLiteral(0).getText());
                    }
                    if (commonContext.visibility() != null && commonContext.visibility().INVISIBLE_SYMBOL() != null) {
                        isVisible = "NO";
                    }
                }
                if ((indexTypeClauseContext = indexOptionContext.indexTypeClause()) == null) continue;
                indexType = indexTypeClauseContext.indexType().algorithm.getText();
            }
            MySql56Index index = new MySql56Index((MySql56Schema)this.table.getSchema());
            index.setObjectName(this.table.getObjectName());
            index.setIndexSchema(this.table.getSchemaName());
            index.setNonunique(1);
            index.setIndexName(indexName);
            index.setIndexType(indexType);
            index.setIndexComment(comment);
            index.setVisible(isVisible);
            index.getIndexColumns().addAll(keyColumns);
            return index;
        }

        private MySql56Index resolveFullTextAndSpatialIndex(MySQLParser.TableConstraintDefContext ctx) {
            String indexType;
            String indexName = this.table.getObjectName() + GEN_INDEX_NAME + ++this.genIndexId;
            String comment = null;
            String isVisible = "YES";
            MySQLParser.IndexNameContext indexNameContext = ctx.indexName();
            if (indexNameContext != null) {
                indexName = MysqlTableMetaResolver.this.parseTextOrIdentifier(indexNameContext.getText());
            }
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(ctx.keyListVariants());
            ArrayList commonIndexOptionContexts = new ArrayList();
            if (ctx.FULLTEXT_SYMBOL() != null) {
                indexType = "FULLTEXT";
                ctx.fulltextIndexOption().stream().map(MySQLParser.FulltextIndexOptionContext::commonIndexOption).forEach(commonIndexOptionContexts::add);
            } else if (ctx.SPATIAL_SYMBOL() != null) {
                indexType = "SPATIAL";
                ctx.spatialIndexOption().stream().map(MySQLParser.SpatialIndexOptionContext::commonIndexOption).forEach(commonIndexOptionContexts::add);
            } else {
                throw new IllegalArgumentException("Failed to resolve meta data, can't resolve non-fulltext and non-spatial index");
            }
            for (MySQLParser.CommonIndexOptionContext commonContext : commonIndexOptionContexts) {
                if (commonContext.COMMENT_SYMBOL() != null) {
                    comment = MysqlTableMetaResolver.this.parseTextOrIdentifier(commonContext.textLiteral().textStringLiteral(0).getText());
                }
                if (commonContext.visibility() == null || commonContext.visibility().INVISIBLE_SYMBOL() == null) continue;
                isVisible = "NO";
            }
            MySql56Index index = new MySql56Index((MySql56Schema)this.table.getSchema());
            index.setObjectName(this.table.getObjectName());
            index.setIndexSchema(this.table.getSchemaName());
            index.setNonunique(1);
            index.setIndexName(indexName);
            index.setIndexType(indexType);
            index.setIndexComment(comment);
            index.setVisible(isVisible);
            index.getIndexColumns().addAll(keyColumns);
            return index;
        }

        private <T> T resolvePrimaryOrUnique(MySQLParser.TableConstraintDefContext ctx) {
            boolean isPrimary = ctx.PRIMARY_SYMBOL() != null;
            String indexName = isPrimary ? this.table.getObjectName() + GEN_PRIMARY_NAME : this.table.getObjectName() + GEN_UNIQUE_NAME + ++this.genUniqueId;
            MySQLParser.IndexNameAndTypeContext indexNameContext = ctx.indexNameAndType();
            if (indexNameContext != null) {
                indexName = MysqlTableMetaResolver.this.parseTextOrIdentifier(indexNameContext.getText());
            }
            String constraintName = indexName;
            MySQLParser.ConstraintNameContext constraintNameContext = ctx.constraintName();
            if (constraintNameContext != null) {
                constraintName = MysqlTableMetaResolver.this.parseTextOrIdentifier(constraintNameContext.getText());
            }
            List<KeyColumn> keyColumns = this.resolveKeyListVariantsContext(ctx.keyListVariants());
            String comment = null;
            String indexType = "BTREE";
            List indexOptionCtx = ctx.indexOption();
            for (int i = 0; i < indexOptionCtx.size(); ++i) {
                MySQLParser.IndexTypeClauseContext indexTypeCtx;
                MySQLParser.IndexOptionContext indexCtx = (MySQLParser.IndexOptionContext)indexOptionCtx.get(i);
                MySQLParser.CommonIndexOptionContext commonIdxCtx = indexCtx.commonIndexOption();
                if (commonIdxCtx != null && commonIdxCtx.COMMENT_SYMBOL() != null) {
                    comment = MysqlTableMetaResolver.this.parseTextOrIdentifier(commonIdxCtx.textLiteral().getText());
                }
                if ((indexTypeCtx = indexCtx.indexTypeClause()) == null) continue;
                indexType = indexTypeCtx.indexType().algorithm.getText();
            }
            AbstractMySqlConstraint constraint = isPrimary ? new MySql56PrimaryKey((MySql56Schema)this.table.getSchema()) : new MySql56UniqueKey((MySql56Schema)this.table.getSchema());
            constraint.setObjectName(this.table.getObjectName());
            constraint.setConstraintName(constraintName);
            constraint.setIndexName(indexName);
            constraint.getConstraintColumns().addAll(keyColumns);
            constraint.setComment(comment);
            constraint.setIndexType(indexType);
            return (T)constraint;
        }

        private MySql56ForeignKey resolveForeignKey(MySQLParser.TableConstraintDefContext ctx) {
            String indexName = this.table.getObjectName() + GEN_INDEX_NAME + ++this.genIndexId;
            MySQLParser.IndexNameContext indexNameContext = ctx.indexName();
            if (indexNameContext != null) {
                indexName = MysqlTableMetaResolver.this.parseTextOrIdentifier(indexNameContext.getText());
            }
            String constraintName = indexName;
            MySQLParser.ConstraintNameContext constraintNameCtx = ctx.constraintName();
            if (constraintNameCtx != null && constraintNameCtx.identifier() != null) {
                constraintName = MysqlTableMetaResolver.this.parseTextOrIdentifier(constraintNameCtx.identifier().getText());
            }
            ArrayList<KeyColumn> keyColumns = new ArrayList<KeyColumn>();
            MySQLParser.KeyListContext keyListContext = ctx.keyList();
            if (keyListContext != null) {
                List keyPartContexts = keyListContext.keyPart();
                for (int i = 0; i < keyPartContexts.size(); ++i) {
                    keyColumns.add(this.resolveKeyPart((MySQLParser.KeyPartContext)keyPartContexts.get(i), i));
                }
            }
            MySql56ForeignKey foreignKey = new MySql56ForeignKey((MySql56Schema)this.table.getSchema());
            foreignKey.setObjectName(this.table.getObjectName());
            MySQLParser.ReferencesContext references = ctx.references();
            if (ctx.references() != null) {
                this.fillForeignKey(foreignKey, references);
            }
            foreignKey.setConstraintName(constraintName);
            foreignKey.setIndexName(indexName);
            foreignKey.getConstraintColumns().addAll(keyColumns);
            return foreignKey;
        }

        private MySql80Check resolveCheck(MySQLParser.TableConstraintDefContext ctx) {
            String constraintName = ctx.constraintName() != null ? ctx.constraintName().identifier().getText() : this.table.getObjectName() + GEN_CHECK_NAME + ++this.genCheckId;
            return this.generateCheck(constraintName, ctx.checkConstraint().exprWithParentheses().getText());
        }

        private void fillForeignKey(MySql56ForeignKey foreignKey, MySQLParser.ReferencesContext refContext) {
            MySQLParser.IdentifierListWithParenthesesContext refColumnContext;
            String refTableOwner = this.table.getSchemaName();
            String refTableName = null;
            MySQLParser.QualifiedIdentifierContext tableRefFullNameContext = refContext.tableRef().qualifiedIdentifier();
            if (tableRefFullNameContext != null) {
                MySQLParser.IdentifierContext identifier = tableRefFullNameContext.identifier();
                refTableName = MysqlTableMetaResolver.this.parseTextOrIdentifier(identifier.getText());
                MySQLParser.DotIdentifierContext dotIdentifierContext = tableRefFullNameContext.dotIdentifier();
                if (dotIdentifierContext != null) {
                    refTableOwner = refTableName;
                    refTableName = MysqlTableMetaResolver.this.parseTextOrIdentifier(dotIdentifierContext.identifier().getText());
                }
            }
            if ((refColumnContext = refContext.identifierListWithParentheses()) != null) {
                List columns = refColumnContext.identifierList().identifier();
                for (int i = 0; i < columns.size(); ++i) {
                    MySQLParser.IdentifierContext columnContext = (MySQLParser.IdentifierContext)columns.get(i);
                    String columnName = MysqlTableMetaResolver.this.parseTextOrIdentifier(columnContext.getText());
                    foreignKey.getReferencedColumns().add(new KeyColumn(columnName, i));
                }
            }
            List optionContexts = refContext.deleteOption();
            Function<MySQLParser.DeleteOptionContext, String> optionResolve = optionContext -> {
                if (optionContext.RESTRICT_SYMBOL() != null) {
                    return "RESTRICT";
                }
                if (optionContext.CASCADE_SYMBOL() != null) {
                    return "CASCADE";
                }
                if (optionContext.SET_SYMBOL() != null) {
                    return "SET NULL";
                }
                return "NO ACTION";
            };
            String updateRule = null;
            String deleteRule = null;
            if (CollectionUtils.isEmpty((Collection)optionContexts)) {
                deleteRule = "NO ACTION";
                updateRule = "NO ACTION";
            } else if ("UPDATE".equalsIgnoreCase(refContext.option.getText())) {
                updateRule = optionResolve.apply((MySQLParser.DeleteOptionContext)optionContexts.get(0));
                if (optionContexts.size() > 1) {
                    deleteRule = optionResolve.apply((MySQLParser.DeleteOptionContext)optionContexts.get(1));
                }
            } else {
                deleteRule = optionResolve.apply((MySQLParser.DeleteOptionContext)optionContexts.get(0));
                if (optionContexts.size() > 1) {
                    updateRule = optionResolve.apply((MySQLParser.DeleteOptionContext)optionContexts.get(1));
                }
            }
            foreignKey.setDeleteRule(deleteRule);
            foreignKey.setUpdateRule(updateRule);
            foreignKey.setRefTableOwner(refTableOwner);
            foreignKey.setRefTableName(refTableName);
        }

        private KeyColumn resolveKeyPart(MySQLParser.KeyPartContext keyPart, int columnIndex) {
            String columnName = MysqlTableMetaResolver.this.parseTextOrIdentifier(keyPart.identifier().getText());
            String subPart = null;
            if (keyPart.fieldLength() != null) {
                subPart = MysqlTableMetaResolver.this.parseTextOrIdentifier(keyPart.fieldLength().getText());
            }
            String collection = "ASC";
            if (keyPart.direction() != null && keyPart.direction().DESC_SYMBOL() != null) {
                collection = "DESC";
            }
            return new KeyColumn(columnName, columnIndex, subPart, collection);
        }

        private void fillColumnType(MySql56Column column) {
            if (StringUtils.isNotBlank((String)column.getColumnType())) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String dataType = column.getDataType();
            sb.append(dataType);
            switch (dataType = dataType.toUpperCase(Locale.getDefault())) {
                case "BIT": {
                    if (column.getNumericPrecision() == null) {
                        column.setNumericPrecision(1);
                    }
                    sb.append("(").append(column.getNumericPrecision()).append(")");
                    break;
                }
                case "SMALLINT": 
                case "MEDIUMINT": 
                case "INT": 
                case "INTEGER": 
                case "BIGINT": {
                    if (column.getNumericPrecision() == null) break;
                    sb.append("(").append(column.getNumericPrecision()).append(")");
                    break;
                }
                case "DECIMAL": 
                case "DEC": 
                case "FIXED": {
                    if (column.getNumericPrecision() == null) {
                        column.setNumericPrecision(10);
                    }
                    if (column.getNumericScale() == null) {
                        column.setNumericScale(0);
                    }
                    sb.append("(").append(column.getNumericPrecision()).append(",").append(column.getNumericScale()).append(")");
                    break;
                }
                case "FLOAT": 
                case "DOUBLE": 
                case "DOUBLE PRECISION": 
                case "REAL": {
                    if (column.getNumericScale() == null) break;
                    sb.append("(").append(column.getNumericPrecision()).append(",").append(column.getNumericScale()).append(")");
                    break;
                }
                case "BOOLEAN": 
                case "BOOL": {
                    column.setDataType("TINYINT".toLowerCase(Locale.getDefault()));
                    sb = new StringBuilder("tinyint(1)");
                    break;
                }
                case "DATETIME": 
                case "TIMESTAMP": 
                case "TIME": {
                    if (column.getDateTimePrecision() == null) break;
                    sb.append("(").append(column.getDateTimePrecision()).append(")");
                    break;
                }
                case "CHAR": 
                case "BINARY": 
                case "VARCHAR": 
                case "VARBINARY": {
                    if (column.getCharacterMaximumLength() == null) {
                        column.setCharacterMaximumLength(1L);
                    }
                    sb.append("(").append(column.getCharacterMaximumLength()).append(")");
                    break;
                }
                case "ENUM": 
                case "SET": {
                    List<String> values = column.getTypeValues();
                    sb.append("(");
                    values = values.stream().map(v -> "'" + v + "'").collect(Collectors.toList());
                    sb.append(String.join((CharSequence)",", values));
                    sb.append(")");
                    break;
                }
            }
            if (column.isUnsigned()) {
                sb.append(" ").append("UNSIGNED".toLowerCase(Locale.getDefault()));
            }
            if (column.isZerofill()) {
                sb.append(" ").append("ZEROFILL".toLowerCase(Locale.getDefault()));
            }
            column.setColumnType(sb.toString());
        }
    }
}

