/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.utils;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class ChangeUtils {
    private static final ConcurrentHashMap<String, List<ChangeInfo>> INFO_MAPPING = new ConcurrentHashMap();

    private ChangeUtils() {
    }

    public static void info(ObjectType objectType, String objectName, ChangeInfo.ChangeType changeType, String detailInfo) {
        ChangeUtils.info(objectType, objectName, changeType, detailInfo, null);
    }

    public static void info(ObjectType objectType, String objectName, ChangeInfo.ChangeType changeType, String detailInfo, String extraInfo) {
        ChangeUtils.dolog(objectType, objectName, ChangeInfo.ChangeLevel.INFO, changeType, detailInfo, extraInfo);
    }

    public static void warn(ObjectType objectType, String objectName, ChangeInfo.ChangeType changeType, String detailInfo) {
        ChangeUtils.warn(objectType, objectName, changeType, detailInfo, null);
    }

    public static void warn(ObjectType objectType, String objectName, ChangeInfo.ChangeType changeType, String detailInfo, String extraInfo) {
        ChangeUtils.dolog(objectType, objectName, ChangeInfo.ChangeLevel.WARN, changeType, detailInfo, extraInfo);
    }

    public static List<ChangeInfo> findByKey(ObjectType objectType, String objectName) {
        ArrayList changeInfos = INFO_MAPPING.remove(ChangeUtils.buildKey(objectType, objectName));
        return changeInfos == null ? new ArrayList() : changeInfos;
    }

    static String buildKey(ObjectType objectType, String objectName) {
        return objectType.getName() + "-" + objectName;
    }

    static void dolog(ObjectType objectType, String objectName, ChangeInfo.ChangeLevel changeLevel, ChangeInfo.ChangeType changeType, String detailInfo, String extraInfo) {
        String key = ChangeUtils.buildKey(objectType, objectName);
        List changeInfos = INFO_MAPPING.getOrDefault(key, new ArrayList());
        changeInfos.add(new ChangeInfo(changeLevel, changeType, detailInfo, extraInfo));
        INFO_MAPPING.putIfAbsent(key, changeInfos);
    }
}

