/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.relation.ObjectRelationGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class GraphUtil {
    public static List<LinkedList<String>> allCycleList(Collection<AbstractDependency> deps) {
        ObjectRelationGraph graph = new ObjectRelationGraph(deps.size());
        for (AbstractDependency dep : deps) {
            graph.add(dep.buildPredecessor(), dep.buildSuccessor());
        }
        return graph.findCycle();
    }

    public static List<Node> groupSortDependencies(Collection<AbstractDependency> deps) {
        if (CollectionUtils.isEmpty(deps)) {
            return Lists.newArrayList((Object[])new Node[0]);
        }
        MutableGraph<Node> graph = GraphUtil.loadGraphByDependencies(deps);
        Map<String, Node> resNodeMap = graph.nodes().stream().collect(Collectors.toMap(Node::getNode, Node2 -> Node2));
        Set nodes = graph.nodes();
        Traverser traverser = Traverser.forGraph(graph);
        HashMap groupMap = new HashMap(16);
        for (Node node : nodes) {
            if (graph.inDegree((Object)node) > graph.outDegree((Object)node)) continue;
            int sequenceId = 0;
            String groupId = UUID.randomUUID().toString();
            Iterable iterable = traverser.depthFirstPostOrder((Object)node);
            for (Node temp : iterable) {
                if (StringUtils.isNotBlank((CharSequence)temp.groupId)) {
                    groupId = temp.getGroupId();
                }
                temp.setSequenceId(sequenceId++);
                temp.setGroupId(groupId);
            }
        }
        ArrayList result = Lists.newArrayList(resNodeMap.values());
        Collections.sort(result);
        return result;
    }

    private static MutableGraph<Node> loadGraphByDependencies(Collection<AbstractDependency> deps) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(true).expectedNodeCount(deps.size()).nodeOrder(ElementOrder.insertion()).build();
        HashBasedTable table = HashBasedTable.create();
        deps.forEach(arg_0 -> GraphUtil.lambda$loadGraphByDependencies$1((Table)table, arg_0));
        for (AbstractDependency dep : deps) {
            Node predecessor = (Node)table.get((Object)dep.getObjType(), (Object)dep.getObjName());
            Node successor = (Node)table.get((Object)dep.getRefObjType(), (Object)dep.getRefObjName());
            graph.putEdge((Object)predecessor, (Object)successor);
        }
        return graph;
    }

    private static /* synthetic */ void lambda$loadGraphByDependencies$1(Table table, AbstractDependency dep) {
        if (!table.contains((Object)dep.getObjType(), (Object)dep.getObjName())) {
            table.put((Object)dep.getObjType(), (Object)dep.getObjName(), (Object)new Node(dep.buildPredecessor().toString(), dep.getObjType(), dep.getObjName()));
        }
        if (!table.contains((Object)dep.getRefObjType(), (Object)dep.getRefObjName())) {
            table.put((Object)dep.getRefObjType(), (Object)dep.getRefObjName(), (Object)new Node(dep.buildSuccessor().toString(), dep.getRefObjType(), dep.getRefObjName()));
        }
    }

    public static class Node
    implements Comparable<Node> {
        private String node;
        private String objType;
        private String objName;
        private String groupId;
        private Integer sequenceId;

        public Node() {
        }

        public Node(String node, String objType, String objName) {
            this.node = node;
            this.objType = objType;
            this.objName = objName;
        }

        @Override
        public int compareTo(Node other) {
            int res = this.groupId.compareTo(other.groupId);
            if (res != 0) {
                return res;
            }
            return this.sequenceId.compareTo(other.sequenceId);
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getObjType() {
            return this.objType;
        }

        public void setObjType(String objType) {
            this.objType = objType;
        }

        public String getObjName() {
            return this.objName;
        }

        public void setObjName(String objName) {
            this.objName = objName;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public Integer getSequenceId() {
            return this.sequenceId;
        }

        public void setSequenceId(Integer sequenceId) {
            this.sequenceId = sequenceId;
        }
    }
}

