/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.utils;

import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Monitor {
    private final Map<ObjectType, Map<String, MonitorObject>> queryMetaMonitor = new ConcurrentHashMap<ObjectType, Map<String, MonitorObject>>();

    public Long queryMetaElapsed(ObjectType objType, String objectName) {
        MonitorObject monitorObject = this.getMonitor(objType, objectName);
        return Objects.nonNull(monitorObject) ? monitorObject.getQueryTime() : null;
    }

    public void recordQueryMetadataTime(ObjectType objType, String objectName, long elapsed) {
        MonitorObject monitorObject = this.loadMonitorObject(objType, objectName);
        monitorObject.setQueryTime(elapsed);
    }

    private MonitorObject getMonitor(ObjectType objType, String objectName) {
        if (!this.queryMetaMonitor.containsKey((Object)objType)) {
            return null;
        }
        Map<String, MonitorObject> monitorMap = this.queryMetaMonitor.get((Object)objType);
        if (!monitorMap.containsKey(objectName)) {
            return null;
        }
        return monitorMap.get(objectName);
    }

    private synchronized MonitorObject loadMonitorObject(ObjectType objType, String objectName) {
        Map<String, MonitorObject> objectNameMonitorObjMap;
        if (!this.queryMetaMonitor.containsKey((Object)objType)) {
            this.queryMetaMonitor.put(objType, new ConcurrentHashMap());
        }
        if (!(objectNameMonitorObjMap = this.queryMetaMonitor.get((Object)objType)).containsKey(objectName)) {
            objectNameMonitorObjMap.put(objectName, new MonitorObject(objType, objectName));
        }
        return objectNameMonitorObjMap.get(objectName);
    }

    public static class MonitorObject {
        private final ObjectType objectType;
        private final String objectName;
        private Long queryTime;

        public MonitorObject(ObjectType objectType, String objectName) {
            this.objectType = objectType;
            this.objectName = objectName;
        }

        public ObjectType getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Long getQueryTime() {
            return this.queryTime;
        }

        public void setQueryTime(Long queryTime) {
            this.queryTime = queryTime;
        }
    }
}

