/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObUtils {
    public static final Map<String, String> OB_JAVA_CHARSET_MAPPING = new HashMap<String, String>();

    public static List<String> resolveColumnExtendedTypeInfo(byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new NullPointerException("byte array can't be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        Stream stream = new Stream(bytes);
        if (stream.available() > 0) {
            stream.readObVarInt64();
        }
        while (stream.available() > 0) {
            long byteLength = stream.readObVarInt64();
            byte[] buffer = stream.readBytes(byteLength);
            stream.skip(1L);
            result.add(new String(buffer, charset));
        }
        return result;
    }

    static {
        OB_JAVA_CHARSET_MAPPING.put("utf8mb4", "utf8");
        OB_JAVA_CHARSET_MAPPING.put("gbk", "gbk");
        OB_JAVA_CHARSET_MAPPING.put("utf16", "utf16");
        OB_JAVA_CHARSET_MAPPING.put("gb18030", "gb18030");
        OB_JAVA_CHARSET_MAPPING.put("gb18030_2022", "gb18030");
        OB_JAVA_CHARSET_MAPPING.put("latin1", "ISO-8859-1");
    }

    public static class Stream {
        private final byte[] buffer;
        private int position;

        public Stream(byte[] bytes) {
            this.buffer = bytes;
            this.position = 0;
        }

        public long readObVarInt64() {
            byte b;
            long result = 0L;
            int shift = 0;
            do {
                b = this.buffer[this.position++];
                result |= ((long)b & 0x7FL) << shift;
                shift += 7;
            } while ((b & 0x80) != 0);
            return result;
        }

        public byte[] readBytes(long length) {
            if (length > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("The read length cannot exceed Integer.MAX_VALUE");
            }
            int l = (int)length;
            byte[] bytes = new byte[l];
            System.arraycopy(this.buffer, this.position, bytes, 0, l);
            this.position += l;
            return bytes;
        }

        public void skip(long length) {
            if (length > (long)this.available()) {
                String errMsg = String.format("Available [%s] bytes is less than [%s] bytes to skip.", this.available(), length);
                throw new UnsupportedOperationException(errMsg);
            }
            this.position = (int)((long)this.position + length);
        }

        public int position() {
            return this.position;
        }

        public int available() {
            return this.buffer.length - this.position;
        }
    }
}

