/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern SNAPSHOT = Pattern.compile("^.*((?:-\\d{8}\\.\\d{6}-\\d+)|-SNAPSHOT)( \\(.*\\))?$");
    private String value;
    private String snapshot;
    private String canonical;
    private ListItem items;
    public static final Comparator<Version> DESCENDING = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return o2.compareTo(o1);
        }
    };

    public Version(String version) {
        this.parseVersion(version);
    }

    private void parseVersion(String version) {
        this.value = version;
        this.items = new ListItem();
        Matcher matcher = SNAPSHOT.matcher(version);
        if (matcher.matches()) {
            this.snapshot = matcher.group(1);
            version = version.substring(0, matcher.start(1)) + "-SNAPSHOT";
        }
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this.items;
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(Version.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if (c == '-') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(Version.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                if (!isDigit) continue;
                list.normalize();
                if (i + 1 >= version.length() || !Character.isDigit(version.charAt(i + 1))) continue;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (c == '*') {
                list.add(new WildCardItem());
                startIndex = i + 1;
                continue;
            }
            if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(new StringItem(version.substring(startIndex, i), true));
                    startIndex = i;
                }
                isDigit = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (i > startIndex) {
                    if (isDigit) {
                        list.add(Version.parseItem(true, version.substring(startIndex, i)));
                    } else {
                        list.add(new StringItem(version.substring(startIndex, i), true));
                    }
                    startIndex = i;
                }
                isDigit = false;
                continue;
            }
            if (isDigit && i > startIndex) {
                list.add(Version.parseItem(true, version.substring(startIndex, i)));
                startIndex = i;
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list.add(Version.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
    }

    @Override
    public int compareTo(Version o) {
        int i2;
        int result = this.items.compareTo(o.items);
        if (result != 0) {
            return result;
        }
        if (this.snapshot == null) {
            return o.snapshot == null ? 0 : -1;
        }
        if (o.snapshot == null) {
            return 1;
        }
        if ("-SNAPSHOT".equals(this.snapshot) || "-SNAPSHOT".equals(o.snapshot)) {
            return 0;
        }
        result = this.snapshot.substring(1, 16).compareTo(o.snapshot.substring(1, 16));
        if (result != 0) {
            return result;
        }
        int i1 = Integer.parseInt(this.snapshot.substring(17));
        return i1 < (i2 = Integer.parseInt(o.snapshot.substring(17))) ? -1 : (i1 == i2 ? 0 : 1);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version that = (Version)o;
        if (!this.canonical.equals(that.canonical)) {
            return false;
        }
        if (this.snapshot == null) {
            return that.snapshot == null;
        }
        if ("-SNAPSHOT".equals(this.snapshot) || "-SNAPSHOT".equals(that.snapshot)) {
            return true;
        }
        return this.snapshot.equals(that.snapshot);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public boolean isOlderThan(Version rhs) {
        return this.compareTo(rhs) < 0;
    }

    public boolean isNewerThan(Version rhs) {
        return this.compareTo(rhs) > 0;
    }

    public int getDigitAt(int idx) {
        int i;
        if (idx < 0) {
            return -1;
        }
        Iterator it = this.items.iterator();
        Item item = null;
        for (i = 0; i <= idx && it.hasNext(); ++i) {
            item = (Item)it.next();
            if (item instanceof IntegerItem) {
                continue;
            }
            return -1;
        }
        return idx - i >= 0 ? -1 : ((IntegerItem)item).value.intValue();
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private static final long serialVersionUID = -7082368337561511672L;

        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            Item item;
            ListIterator iterator = this.listIterator(this.size());
            while (iterator.hasPrevious() && (item = (Item)iterator.previous()).isNull()) {
                iterator.remove();
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item r = right.hasNext() ? (Item)right.next() : null;
                        int result = l == null ? -1 * r.compareTo(l) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
                case 3: {
                    return -1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("(");
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final String[] QUALIFIERS = new String[]{"snapshot", "alpha", "beta", "milestone", "rc", "", "sp"};
        private static final List<String> QUALIFIER_LIST = Arrays.asList(QUALIFIERS);
        private static final Properties ALIASES = new Properties();
        private static String RELEASE_VERSION_INDEX;
        private String value;

        public StringItem(String value, boolean followedByDigit) {
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        value = "alpha";
                        break;
                    }
                    case 'b': {
                        value = "beta";
                        break;
                    }
                    case 'm': {
                        value = "milestone";
                        break;
                    }
                }
            }
            this.value = ALIASES.getProperty(value, value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0;
        }

        public static String comparableQualifier(String qualifier) {
            int i = QUALIFIER_LIST.indexOf(qualifier);
            return i == -1 ? QUALIFIER_LIST.size() + "-" + qualifier : String.valueOf(i);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                }
                case 2: {
                    return -1;
                }
                case 3: {
                    return -1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value;
        }

        static {
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("cr", "rc");
            ALIASES.put("ea", "rc");
            RELEASE_VERSION_INDEX = String.valueOf(QUALIFIER_LIST.indexOf(""));
        }
    }

    private static class IntegerItem
    implements Item {
        private static final BigInteger BIG_INTEGER_ZERO = BigInteger.ZERO;
        private final BigInteger value;
        public static final IntegerItem ZERO = new IntegerItem();

        private IntegerItem() {
            this.value = BIG_INTEGER_ZERO;
        }

        public IntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BIG_INTEGER_ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BIG_INTEGER_ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this.value.compareTo(((IntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class WildCardItem
    implements Item {
        private WildCardItem() {
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return 1;
            }
            switch (item.getType()) {
                case 0: 
                case 1: 
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
            }
            return 1;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        public String toString() {
            return "*";
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;
        public static final int WILDCARD_ITEM = 3;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }
}

