/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.xmlparser;

import com.oceanbase.obtools.common.utils.ArrayUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.exception.InvalidStatementException;
import com.oceanbase.obtools.dbdiff.xmlparser.SqlMapper;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlParser {
    private static final Logger log = LoggerFactory.getLogger(XmlParser.class);
    public static final String DDD = "http://apache.org/xml/features/disallow-doctype-decl";
    private final String[] locations;

    public XmlParser(String ... locations) {
        this.locations = locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlMapper parse() throws Exception {
        if (ArrayUtils.isEmpty((Object[])this.locations)) {
            throw new IllegalArgumentException("sql-xml location(s) is null");
        }
        LinkedHashMap<String, String> sqlMapper = new LinkedHashMap<String, String>();
        for (String location : this.locations) {
            InputStream stream = null;
            try {
                stream = ClassLoader.getSystemResourceAsStream(location);
                if (stream == null) {
                    log.warn("ClassLoad load: \"" + location + "\" as system resource is null");
                    stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
                    if (stream == null) {
                        throw new IllegalArgumentException("ThreadContextClassLoader load: \"" + location + "\" as resource is null");
                    }
                }
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setFeature(DDD, true);
                XmlHandler xmlHandler = new XmlHandler(location);
                reader.setContentHandler(xmlHandler);
                reader.parse(new InputSource(stream));
                sqlMapper.putAll(xmlHandler.getSqlMap());
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    log.debug("Ignore close resource");
                }
            }
        }
        return new SqlMapper(sqlMapper);
    }

    static class XmlHandler
    extends DefaultHandler {
        private static final Logger log = LoggerFactory.getLogger(XmlHandler.class);
        private static final String SELECT_PREFIX = "select";
        private String sqlId;
        private boolean flag;
        private StringBuilder sb;
        private final String location;
        private Map<String, String> sqlMap;

        public XmlHandler(String location) {
            this.location = location;
        }

        public Map<String, String> getSqlMap() {
            return Collections.unmodifiableMap(this.sqlMap);
        }

        @Override
        public void startDocument() throws SAXException {
            this.sqlMap = new LinkedHashMap<String, String>();
        }

        @Override
        public void endDocument() throws SAXException {
            this.sb = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (SELECT_PREFIX.equalsIgnoreCase(qName)) {
                this.flag = true;
                this.sb = new StringBuilder();
                this.sqlId = attributes.getValue("id");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.flag) {
                this.sb.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (StringUtils.isBlank((CharSequence)this.sqlId)) {
                log.warn("The config file {} is empty. Ignored!", (Object)this.location);
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.sb)) {
                throw new InvalidStatementException("The Sql of id=" + this.sqlId + " is empty in " + this.location);
            }
            this.sqlMap.put(this.sqlId, this.sb.toString().trim());
            this.flag = false;
        }
    }
}

