/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.ExceptionInterceptor;
import com.oceanbase.jdbc.Lob;
import com.oceanbase.jdbc.ObLobLocatorV2;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class Clob
extends Lob
implements java.sql.Clob {
    private static final long serialVersionUID = -3066501059817815286L;
    static int maxLength = 0x40000000;
    private static final String Clob_0 = "indexToWriteAt must be >= 1";
    private static final String Clob_1 = "indexToWriteAt must be >= 1";
    private static final String Clob_2 = "Starting position can not be < 1";
    private static final String Clob_3 = "String to set can not be NULL";
    private static final String Clob_4 = "Starting position can not be < 1";
    private static final String Clob_5 = "String to set can not be NULL";
    private static final String Clob_6 = "CLOB start position can not be < 1";
    private static final String Clob_7 = "CLOB start position + length can not be > length of CLOB";
    private static final String Clob_8 = "Illegal starting position for search, '";
    private static final String Clob_9 = "'";
    private static final String Clob_10 = "Starting position for search is past end of CLOB";
    private static final String Clob_11 = "Cannot truncate CLOB of length";
    private static final String Clob_12 = "\\\\ to length of";
    private static final String Clob_13 = ".";

    public Clob(byte[] bytes) {
        super(bytes);
        this.encoding = Charset.defaultCharset().name();
    }

    public static Clob getEmptyCLOB() throws SQLException {
        byte[] emptyData = new byte[40];
        emptyData[0] = 33;
        emptyData[1] = 66;
        emptyData[2] = 79;
        emptyData[3] = 76;
        emptyData[4] = 1;
        return new Clob(true, emptyData, Charset.defaultCharset().name(), null);
    }

    public Clob(byte[] bytes, ExceptionInterceptor exceptionInterceptor) {
        super(bytes, exceptionInterceptor);
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(String charDataInit, ExceptionInterceptor exceptionInterceptor) {
        this.charData = charDataInit;
        this.exceptionInterceptor = exceptionInterceptor;
        this.encoding = Charset.defaultCharset().name();
    }

    public Clob(boolean hasLocator, byte[] data, String encoding, OceanBaseConnection conn) throws SQLException {
        this.encoding = null != conn ? conn.getProtocol().getEncoding() : (null != encoding ? encoding : "UTF-8");
        if (!hasLocator) {
            try {
                this.charData = new String(data, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding");
            }
        } else if (null != data) {
            Buffer buffer = new Buffer(data);
            long magicCode = buffer.readLong4BytesV1();
            long version = buffer.readLong4BytesV1();
            if (version == 1L) {
                this.buildObLobLocatorV1(false, buffer, magicCode, version, conn);
            } else if ((version & 0xFFL) == 2L) {
                this.buildObLobLocatorV2(false, buffer, magicCode, version, conn);
            } else {
                throw new SQLException("Unknown version of lob locator!");
            }
        }
    }

    public Clob() {
        this.encoding = Charset.defaultCharset().name();
    }

    public String getString() {
        if (this.charData != null) {
            return this.charData;
        }
        Charset charset = Charset.forName(this.encoding);
        return new String(this.data, this.offset, this.length, charset);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.isClosed) {
            if (this.isOracleMode) {
                throw new SQLException("Invalid operation on closed LOB");
            }
            return null;
        }
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("position must be >= 1");
        }
        if (length < 0) {
            throw ExceptionFactory.INSTANCE.create("length must be > 0");
        }
        if (this.length == 0 && !this.isEmptyLob() && this.locator != null && this.locator instanceof ObLobLocatorV2) {
            this.readFromServer();
        }
        int adjustedStartPos = (int)pos - 1;
        int adjustedEndIndex = adjustedStartPos + length;
        if (this.charData != null) {
            if (adjustedEndIndex > this.charData.length()) {
                adjustedEndIndex = this.charData.length();
            }
            return this.charData.substring(adjustedStartPos, adjustedEndIndex);
        }
        try {
            String val = this.getString();
            return val.substring((int)pos - 1, Math.min((int)pos - 1 + length, val.length()));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isClosed) {
            if (this.isOracleMode) {
                throw new SQLException("Invalid operation on closed LOB");
            }
            return null;
        }
        if (this.length == 0 && !this.isEmptyLob() && this.locator != null && this.locator instanceof ObLobLocatorV2) {
            this.readFromServer();
        }
        if (this.charData != null) {
            return new StringReader(this.charData);
        }
        return new StringReader(this.getString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String val = this.getString();
        if ((long)val.length() < (long)((int)pos - 1) + length) {
            throw ExceptionFactory.INSTANCE.create("pos + length is greater than the number of characters in the Clob");
        }
        String sub = val.substring((int)pos - 1, (int)pos - 1 + (int)length);
        return new StringReader(sub);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (pos < 1L) {
            if (!this.isOracleMode) {
                throw new SQLException("Starting position can not be < 1");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException();
            }
        }
        int bytePosition = this.utf8Position((int)pos - 1);
        OutputStream stream = this.setBinaryStream(bytePosition + 1);
        try {
            return new OutputStreamWriter(stream, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.isClosed) {
            if (this.isOracleMode) {
                throw new SQLException("Invalid operation on closed LOB");
            }
            return null;
        }
        if (this.length == 0 && !this.isEmptyLob() && this.locator != null && this.locator instanceof ObLobLocatorV2) {
            this.readFromServer();
        }
        if (this.charData != null) {
            try {
                if (this.encoding != null) {
                    return new ByteArrayInputStream(this.charData.getBytes(this.encoding));
                }
                return new ByteArrayInputStream(this.charData.getBytes());
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding " + this.encoding);
            }
        }
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        if (this.isOracleMode && this.isClosed) {
            throw new SQLException("Invalid operation on closed LOB");
        }
        if (start < 1L) {
            throw new SQLException(Clob_8 + start + Clob_9);
        }
        if (start - 1L > (long)this.getString().length()) {
            throw new SQLException("Cannot truncate CLOB of length ");
        }
        long pos = this.getString().indexOf(searchStr, (int)start - 1);
        return pos == -1L ? -1L : pos + 1L;
    }

    @Override
    public long position(java.sql.Clob searchStr, long start) throws SQLException {
        return this.position(((Clob)searchStr).getString(), start);
    }

    private int utf8Position(int charPosition) {
        int pos = this.offset;
        for (int i = 0; i < charPosition; ++i) {
            int byteValue = this.isOracleMode && pos >= this.data.length ? 32 : this.data[pos] & 0xFF;
            if (byteValue < 128) {
                ++pos;
                continue;
            }
            if (byteValue < 194) {
                throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
            }
            if (byteValue < 224) {
                pos += 2;
                continue;
            }
            if (byteValue < 240) {
                pos += 3;
                continue;
            }
            if (byteValue < 248) {
                pos += 4;
                continue;
            }
            throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
        }
        return pos;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (this.isOracleMode && this.isClosed) {
            throw new SQLException("Invalid operation on closed LOB");
        }
        if (pos < 1L) {
            throw new SQLException("Starting position can not be < 1");
        }
        if (this.isOracleMode && (str == null || str.length() == 0)) {
            return 0;
        }
        if (this.locator != null) {
            try {
                this.updateClobToServer(pos, str, str.length());
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding " + this.encoding);
            }
        }
        int bytePosition = this.utf8Position((int)pos - 1);
        try {
            super.setBytes(bytePosition + 1 - this.offset, str.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("Unsupported character encoding " + this.encoding);
        }
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (str == null) {
            throw new SQLException("String to set can not be NULL");
        }
        try {
            return this.setString(pos, str.substring(offset, offset + len));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.setBinaryStream(this.utf8Position((int)pos - 1) + 1);
    }

    @Override
    public long length() throws SQLException {
        if (this.isOracleMode && this.isClosed) {
            throw new SQLException("Invalid operation on closed LOB");
        }
        if (this.charData != null) {
            return this.charData.length();
        }
        if ((this.data == null || this.data.length == 0) && this.locator != null && this.locator.payloadSize > 0L && this.locator instanceof ObLobLocatorV2) {
            if (this.lengthFromServer == -1) {
                this.lengthFromServer = 0;
                this.getLengthFromServer();
            }
            return this.lengthFromServer;
        }
        Charset charset = Charset.forName(this.encoding);
        if (!charset.equals(StandardCharsets.UTF_8)) {
            return this.getString().length();
        }
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        pos += 3;
                        len += 2L;
                        continue;
                    }
                    pos += this.offset + this.length;
                    ++len;
                    continue;
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        return len;
    }

    @Override
    public void truncate(long truncateLen) throws SQLException {
        if (this.isClosed) {
            if (this.isOracleMode) {
                throw new SQLException("Invalid operation on closed LOB");
            }
            throw new NullPointerException("LOB is closed.");
        }
        if (truncateLen < 0L) {
            if (this.isOracleMode) {
                throw new SQLException("Invalid argument: 'len' should not be < 0");
            }
            throw new StringIndexOutOfBoundsException("String index out of range: " + truncateLen);
        }
        if (this.charData != null && truncateLen > (long)this.charData.length()) {
            throw new SQLException("Cannot truncate CLOB of length " + this.charData.length() + " to length of " + truncateLen);
        }
        if (this.locator != null) {
            this.trimClobToServer((int)truncateLen);
            return;
        }
        if (this.charData != null) {
            this.charData = this.charData.substring(0, (int)truncateLen);
            return;
        }
        long len = 0L;
        int pos = this.offset;
        while (len < (long)this.length && len < truncateLen && this.data[pos] >= 0) {
            ++len;
            ++pos;
        }
        while (pos < this.offset + this.length && len < truncateLen) {
            byte firstByte;
            if ((firstByte = this.data[pos++]) < 0) {
                if (firstByte >> 5 != -2 || (firstByte & 0x1E) == 0) {
                    if (firstByte >> 4 == -2) {
                        if (pos + 1 < this.offset + this.length) {
                            pos += 2;
                            ++len;
                            continue;
                        }
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (firstByte >> 3 != -2) {
                        throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                    }
                    if (pos + 2 < this.offset + this.length) {
                        if (len + 2L <= truncateLen) {
                            pos += 3;
                            len += 2L;
                            continue;
                        }
                        ++pos;
                        len = truncateLen;
                        continue;
                    }
                    throw new UncheckedIOException("invalid UTF8", new CharacterCodingException());
                }
                ++pos;
                ++len;
                continue;
            }
            ++len;
        }
        this.length = pos - this.offset;
    }

    private synchronized void updateClobToServer(long writeAt, String str, int length) throws SQLException, UnsupportedEncodingException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        int writeOffset = (int)writeAt;
        int localOffset = 0;
        try (CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.write( ?, ?, ?, ?)}");){
            int writeAmount;
            ((OceanBaseStatement)((Object)cstmt)).setInternal();
            for (int lengthLeft = length; lengthLeft > 0; lengthLeft -= writeAmount) {
                writeAmount = Math.min(lengthLeft, DBMS_LOB_MAX_AMOUNT);
                cstmt.setClob(1, (java.sql.Clob)this);
                cstmt.setInt(2, writeAmount);
                cstmt.setInt(3, writeOffset);
                cstmt.setString(4, str.substring(localOffset, localOffset + writeAmount));
                cstmt.registerOutParameter(1, 2005);
                cstmt.execute();
                writeOffset += writeAmount;
                localOffset += writeAmount;
            }
            Clob r = (Clob)cstmt.getClob(1);
            if (r == null || r.getLocator() == null) {
                throw new SQLException("Invalid operation on closed CLOB");
            }
            this.copy(r);
        }
    }

    private synchronized void trimClobToServer(int len) throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        this.clearData();
        try (CallableStatement cstmt = this.locator.connection.prepareCall("{call DBMS_LOB.trim( ?, ?)}");){
            ((OceanBaseStatement)((Object)cstmt)).setInternal();
            cstmt.setClob(1, (java.sql.Clob)this);
            cstmt.setInt(2, len);
            cstmt.registerOutParameter(1, 2005);
            cstmt.execute();
            Clob r = (Clob)cstmt.getClob(1);
            if (r == null || r.getLocator() == null) {
                throw new SQLException("Invalid operation on closed CLOB");
            }
            this.copy(r);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized void readFromServer() throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        int offset = 1;
        try {
            CallableStatement cstmt = this.locator.connection.getLobConn().prepareCall("{call DBMS_LOB.READ( ?, ?, ?, ?)}");
            Throwable throwable = null;
            try {
                try {
                    ((OceanBaseStatement)((Object)cstmt)).setInternal();
                    while (true) {
                        cstmt.setClob(1, (java.sql.Clob)this);
                        cstmt.setInt(2, DBMS_LOB_MAX_AMOUNT);
                        cstmt.setInt(3, offset);
                        cstmt.registerOutParameter(2, 4);
                        cstmt.registerOutParameter(4, 12);
                        cstmt.execute();
                        int amount = cstmt.getInt(2);
                        offset += amount;
                        if (amount > maxLength) throw new SQLException("Exceed max length of Clob for support " + maxLength + " current " + amount);
                        byte[] bytes = cstmt.getBytes(4);
                        String str = new String(bytes, this.encoding);
                        if (this.charData == null) {
                            this.charData = str;
                            continue;
                        }
                        this.charData = this.charData + str;
                        continue;
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException("Unsupported character encoding " + this.encoding);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cstmt == null) throw throwable3;
                if (throwable != null) {
                    try {
                        cstmt.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    cstmt.close();
                }
                throw throwable3;
            }
        }
        catch (SQLException ex) {
            if (!ex.getMessage().contains("no data found")) {
                throw ex;
            }
            this.length = this.charData.length();
            return;
        }
    }

    private synchronized void getLengthFromServer() throws SQLException {
        if (this.locator == null || this.locator.connection == null) {
            throw new SQLException("Invalid operation on closed CLOB");
        }
        try (CallableStatement cstmt = this.locator.connection.getLobConn().prepareCall("{? = call DBMS_LOB.GETLENGTH( ?)}");){
            ((OceanBaseStatement)((Object)cstmt)).setInternal();
            cstmt.setClob(2, (java.sql.Clob)this);
            cstmt.registerOutParameter(1, 4);
            cstmt.execute();
            this.lengthFromServer = cstmt.getInt(1);
        }
    }
}

