/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.ObStruct;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.StructImpl;
import com.oceanbase.jdbc.internal.util.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class OceanBaseXaResource
implements XAResource {
    private static final int MAX_COMMAND_LENGTH = 300;
    public static final int TMMIGRATE = 0x100000;
    private final OceanBaseConnection connection;
    private boolean isChangedCommit;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORATRANSLOOSE = 65536;
    public static final int ORATMREADONLY = 256;

    public OceanBaseXaResource(OceanBaseConnection connection) {
        this.connection = connection;
    }

    protected static String xidToString(Xid xid) {
        return "0x" + Utils.byteArrayToHexString(xid.getGlobalTransactionId()) + ",0x" + Utils.byteArrayToHexString(xid.getBranchQualifier()) + ",0x" + Utils.intToHexString(xid.getFormatId());
    }

    private static String flagsToString(int flags) {
        switch (flags) {
            case 0x200000: {
                return "JOIN";
            }
            case 0x40000000: {
                return "ONE PHASE";
            }
            case 0x8000000: {
                return "RESUME";
            }
            case 0x2000000: {
                return "SUSPEND";
            }
        }
        return "";
    }

    private XAException mapXaException(SQLException sqle) {
        int xaErrorCode;
        switch (sqle.getErrorCode()) {
            case 1397: {
                xaErrorCode = -4;
                break;
            }
            case 1398: {
                xaErrorCode = -5;
                break;
            }
            case 1399: {
                xaErrorCode = -7;
                break;
            }
            case 1400: {
                xaErrorCode = -9;
                break;
            }
            case 1401: {
                xaErrorCode = -3;
                break;
            }
            case 1402: {
                xaErrorCode = 100;
                break;
            }
            default: {
                xaErrorCode = 0;
            }
        }
        XAException xaException = xaErrorCode != 0 ? new XAException(xaErrorCode) : new XAException(sqle.getMessage());
        xaException.initCause(sqle);
        return xaException;
    }

    private XAException mapXaException2(SQLException sqle) {
        XAException xaException = new XAException(-7);
        xaException.initCause(sqle);
        return xaException;
    }

    private void execute(String command) throws XAException {
        try {
            this.connection.createStatement().execute(command);
        }
        catch (SQLException sqle) {
            throw this.mapXaException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().startCallInterface();
        }
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_COMMIT(?, ?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            try {
                this.dispatchOracleCommand(commandBuf.toString(), xidObj, onePhase);
            }
            finally {
                this.connection.setInGlobalTx(false);
            }
        } else {
            String command = "XA COMMIT " + OceanBaseXaResource.xidToString(xid);
            if (onePhase) {
                command = command + " ONE PHASE";
            }
            this.execute(command);
        }
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().endCallInterface("OceanBaseXaResource.commit");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().startCallInterface();
        }
        if (this.connection.getProtocol().isOracleMode()) {
            if ((flags & 0x4000000) == 0 && (flags & 0x2000000) == 0 && (flags & 0x20000000) == 0 && (flags & 0x100000) == 0) {
                throw new XAException(-5);
            }
            if (flags == 0x20000000) {
                flags = 0x4000000;
            }
            commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_END(?, ?) from dual");
            xidObj = this.genOracleXid(xid);
            this.dispatchOracleCommand(commandBuf.toString(), xidObj, flags);
            try {
                mySQLConnection = this.connection;
                if (!this.isChangedCommit) ** GOTO lbl25
                mySQLConnection.setAutoCommit(true);
                this.isChangedCommit = false;
            }
            catch (SQLException e) {
                throw this.mapXaException2(e);
            }
        } else {
            if (flags != 0x4000000 && flags != 0x2000000 && flags != 0x20000000) {
                throw new XAException(-5);
            }
            this.execute("XA END " + OceanBaseXaResource.xidToString(xid) + " " + OceanBaseXaResource.flagsToString(flags));
        }
lbl25:
        // 3 sources

        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().endCallInterface("OceanBaseXaResource.end");
        }
    }

    @Override
    public void forget(Xid xid) {
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int xaRet;
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().startCallInterface();
        }
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_PREPARE(?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            xaRet = this.dispatchOracleCommand(commandBuf.toString(), xidObj);
        } else {
            this.execute("XA PREPARE " + OceanBaseXaResource.xidToString(xid));
            xaRet = 0;
        }
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().endCallInterface("OceanBaseXaResource.prepare");
        }
        return xaRet;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Xid[] recover(int flags) throws XAException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().startCallInterface();
        }
        if (this.connection.getProtocol().isOracleMode()) {
            StringBuilder commandBuf = new StringBuilder(300);
            commandBuf.append("select DBMS_XA.XA_ROLLBACK(?) from dual");
            ObStruct xidObj = this.genOracleXid(xid);
            try {
                this.dispatchOracleCommand(commandBuf.toString(), xidObj);
            }
            finally {
                this.connection.setInGlobalTx(false);
            }
        } else {
            this.execute("XA ROLLBACK " + OceanBaseXaResource.xidToString(xid));
        }
        if (this.connection != null && this.connection.getProtocol() != null) {
            this.connection.getProtocol().endCallInterface("OceanBaseXaResource.rollback");
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int flags) throws XAException {
        block16: {
            if (flags != 0x200000 && flags != 0x8000000 && flags != 0 && flags != 1024 && flags != 65536 && flags != 256) {
                throw new XAException(-5);
            }
            if (this.connection != null && this.connection.getProtocol() != null) {
                this.connection.getProtocol().startCallInterface();
            }
            try {
                if (this.connection.getProtocol().isOracleMode()) {
                    StringBuilder commandBuf = new StringBuilder(300);
                    commandBuf.append("select DBMS_XA.XA_START(?, ?) from dual");
                    ObStruct xidObj = this.genOracleXid(xid);
                    try {
                        OceanBaseConnection mySQLConnection = this.connection;
                        boolean isAutoCommit = mySQLConnection.getAutoCommit();
                        if (isAutoCommit) {
                            mySQLConnection.setAutoCommit(false);
                            this.isChangedCommit = true;
                        } else {
                            this.isChangedCommit = false;
                        }
                    }
                    catch (SQLException e) {
                        throw this.mapXaException2(e);
                    }
                    try {
                        this.dispatchOracleCommand(commandBuf.toString(), xidObj, flags);
                        break block16;
                    }
                    catch (XAException e) {
                        try {
                            OceanBaseConnection mySQLConnection = this.connection;
                            if (this.isChangedCommit) {
                                mySQLConnection.setAutoCommit(true);
                                this.isChangedCommit = false;
                            }
                        }
                        catch (SQLException se) {
                            throw this.mapXaException2(se);
                        }
                        throw e;
                    }
                }
                this.execute("XA START " + OceanBaseXaResource.xidToString(xid) + " " + OceanBaseXaResource.flagsToString(flags == 0x200000 && this.connection.getPinGlobalTxToPhysicalConnection() ? 0x8000000 : flags));
            }
            finally {
                if (this.connection != null && this.connection.getProtocol() != null) {
                    this.connection.getProtocol().endCallInterface("OceanBaseXaResource.start");
                }
            }
        }
    }

    private ObStruct genOracleXid(Xid xid) throws XAException {
        try {
            OceanBaseConnection mySQLConnection = this.connection;
            Object[] xidObj = new Object[3];
            int i = 0;
            xidObj[i++] = xid.getFormatId();
            xidObj[i++] = xid.getGlobalTransactionId();
            xidObj[i++] = xid.getBranchQualifier();
            ComplexDataType complexType = null;
            if (this.connection.getProtocol().getOptions().useLocalXID) {
                String childTypeName = "DBMS_XA_XID";
                String ownerName = "SYS";
                int type = 3;
                complexType = new ComplexDataType(childTypeName, ownerName, type);
                complexType.setValid(true);
                complexType.setAttrCount(3);
                complexType.setAttrType(0, new ComplexDataType("NUMBER", "", 0));
                complexType.incInitAttrCount();
                complexType.setAttrType(1, new ComplexDataType("RAW", "", 6));
                complexType.incInitAttrCount();
                complexType.setAttrType(2, new ComplexDataType("RAW", "", 6));
                complexType.incInitAttrCount();
                StructImpl struct = new StructImpl(complexType);
                struct.setAttrData(xidObj);
                return struct;
            }
            return (ObStruct)mySQLConnection.createStruct("DBMS_XA_XID", xidObj);
        }
        catch (SQLException sqlEx) {
            throw this.mapXaException2(sqlEx);
        }
    }

    private int dispatchOracleCommand(String command, ObStruct xid) throws XAException {
        return this.dispatchOracleCommand(command, xid, null);
    }

    /*
     * Loose catch block
     */
    private int dispatchOracleCommand(String command, ObStruct xid, Object param) throws XAException {
        PreparedStatement psStmt = null;
        try {
            block17: {
                int n;
                block18: {
                    OceanBaseConnection mySQLConnection = this.connection;
                    psStmt = mySQLConnection.prepareStatement(command);
                    psStmt.setObject(1, xid);
                    if (param != null) {
                        psStmt.setObject(2, param);
                    }
                    ResultSet rs = null;
                    rs = psStmt.executeQuery();
                    if (!rs.next()) break block17;
                    int xaRet = rs.getInt(1);
                    if (xaRet < 0) {
                        XAException xaException = new XAException(xaRet);
                        throw xaException;
                    }
                    n = xaRet;
                    if (rs == null) break block18;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable;
                        }
                    }
                    rs.close();
                }
                return n;
            }
            try {
                throw new XAException(-7);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw this.mapXaException2(sqlEx);
            }
        }
        finally {
            if (psStmt != null) {
                try {
                    psStmt.close();
                }
                catch (SQLException sqlEx) {
                    throw this.mapXaException2(sqlEx);
                }
            }
        }
    }
}

