/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.dao;

import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ColumnLabelIndexer {
    private final ColumnDefinition[] columnInfo;
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;

    public ColumnLabelIndexer(ColumnDefinition[] columnDefinitions) {
        this.columnInfo = columnDefinitions;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        if (this.aliasMap == null) {
            TreeMap<String, Integer> map = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null) {
                    map.putIfAbsent(columnAlias, counter);
                    String tableName = ci.getTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
            this.aliasMap = map;
        }
        if ((res = this.aliasMap.get(name)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null) {
                    map.putIfAbsent(columnRealName, counter);
                    String tableName = ci.getOriginalTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
            this.originalMap = map;
        }
        if ((res = this.originalMap.get(name)) == null) {
            HashMap<String, Integer> possible = new HashMap<String, Integer>();
            possible.putAll(this.aliasMap);
            possible.putAll(this.originalMap);
            throw ExceptionFactory.INSTANCE.create(String.format("No such column: '%s'. '%s' must be in %s", name, name, possible.keySet().toString()), "42S22", 1054);
        }
        return res;
    }
}

