/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SerializableParameter
implements Cloneable,
ParameterHolder {
    protected final boolean noBackSlashEscapes;
    protected Object object;
    protected byte[] loadedStream = null;

    public SerializableParameter(Object object, boolean noBackslashEscapes) {
        this.object = object;
        this.noBackSlashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        pos.write(BINARY_INTRODUCER);
        pos.writeBytesEscaped(this.loadedStream, this.loadedStream.length, this.noBackSlashEscapes);
        pos.write(39);
    }

    protected void writeObjectToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        this.loadedStream = baos.toByteArray();
        this.object = null;
    }

    @Override
    public int getApproximateTextProtocolLength() throws IOException {
        this.writeObjectToBytes();
        return this.loadedStream.length;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        pos.writeFieldLength(this.loadedStream.length);
        pos.write(this.loadedStream);
    }

    @Override
    public String toString() {
        return "<Serializable>";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.BLOB;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

