/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.State;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Manifest;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.dumper.RecordFileDumper;
import com.oceanbase.tools.loaddump.dumper.SchemaFileDumper;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.logging.log4j.ThreadContext;

public class DumpClient
implements Closeable {
    protected State state;
    protected final DumpParameter parameter;
    protected boolean closed;
    protected ConnectionKey connectionKey;

    protected DumpClient(DumpParameter parameter) {
        this.parameter = parameter;
        LogUtils.info("Log files will be written to {}", parameter.getLogsPath());
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    public TaskContext dumpSchema() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((boolean)this.parameter.isIncludeDdl(), (Object)"Option [--ddl] is missing");
        return new SchemaFileDumper(this.parameter).prepare().dumpSchemaAsync();
    }

    public TaskContext dumpRecord() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((this.parameter.getDataFormat() != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        return new RecordFileDumper(this.parameter).prepare().dumpRecordAsync();
    }

    @Override
    public synchronized void close() {
        FileSystem fs;
        if (this.closed) {
            return;
        }
        if (this.connectionKey != null) {
            this.connectionKey.getSessionManager().destroy();
        }
        if ((fs = this.parameter.getStorageConfig().getFileSystem()) != null) {
            try {
                fs.close();
            }
            catch (IOException e) {
                LogUtils.warn("Release file system resources failed. Reason: {}", e.getMessage());
            }
        }
        this.closed = true;
    }

    public static class Builder {
        private final DumpParameter parameter;

        public Builder(DumpParameter parameter) {
            this.parameter = parameter;
        }

        public DumpClient build() throws Exception {
            Set<String> excludeDataTypes;
            Set<String> excludeColumnName;
            DumpClient target = new DumpClient(this.parameter);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getRootPath()), (Object)"The root path is null");
            target.connectionKey = this.parameter.buildConnectionKey();
            ServerMode serverMode = target.connectionKey.getServerMode();
            this.parameter.rebuildAllowedObjectsByUser(serverMode);
            if (serverMode.isPreviousV4()) {
                this.parameter.setCompactSchema(false);
            }
            Set tableSet = this.parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            if (StringUtils.isNotBlank(this.parameter.getCtlPath()) && CollectionUtils.isNotEmpty((Collection)tableSet)) {
                ControlManager cm = ControlManager.parse(new File(this.parameter.getCtlPath()), this.parameter.getDatabaseName(), tableSet, serverMode);
                this.parameter.setControlManager(cm);
                if (MapUtils.isEmpty(this.parameter.getColumnNameMapping())) {
                    this.parameter.getColumnNameMapping().putAll(cm.getColumnNameMapping());
                }
            }
            if (this.parameter.isSnapshot() && serverMode.isPreviousV4() && target.connectionKey.hasNoSysPrivileges()) {
                throw new IllegalArgumentException("Option --snapshot required sys privilege when the OceanBase < 4.0.0.0");
            }
            if (this.parameter.isEnableHiddenPk() && serverMode.isPreviousV4()) {
                if (serverMode.isMysqlMode() && !target.connectionKey.getUsername().equals("__oceanbase_inner_drc_user")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__oceanbase_inner_drc_user\"");
                }
                if (serverMode.isOracleMode() && !target.connectionKey.getUsername().equals("__OCEANBASE_INNER_DRC_USER")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__OCEANBASE_INNER_DRC_USER\"");
                }
            }
            if (this.parameter.getDataFormat() == DataFormat.CSV) {
                Manifest manifest = new Manifest(this.parameter);
                try {
                    SerializeUtils.serializeObjectByKryo(manifest, manifest.toPath());
                    LogUtils.info("Manifest \"{}\" has been saved", manifest.toPath());
                }
                catch (Exception e) {
                    LogUtils.info("Serialization of \".MANIFEST.bin\" failed. This does not impact data integrity.\n-\tNote: \".MANIFEST.bin\" is a binary file that specifies the current CSV format, in most cases, it's not necessary and okay to be ignored.");
                }
            }
            this.parameter.getWhiteListMap().forEach((k, v) -> {
                Set newV = (Set)DBUtils.toCaseInsensitiveCollections(serverMode, v, HashSet::new);
                this.parameter.getWhiteListMap().put((ObjectType)((Object)k), newV);
            });
            this.parameter.getBlackListMap().forEach((k, v) -> {
                Set newV = (Set)DBUtils.toCaseInsensitiveCollections(serverMode, v, HashSet::new);
                this.parameter.getBlackListMap().put((ObjectType)((Object)k), newV);
            });
            LinkedHashSet<String> includeColumnNames = this.parameter.getIncludeColumnNames();
            if (!includeColumnNames.isEmpty()) {
                Collection<String> newV = DBUtils.toCaseInsensitiveColumnNameCollections(serverMode, includeColumnNames, LinkedHashSet::new);
                includeColumnNames.clear();
                includeColumnNames.addAll(newV);
            }
            if (!(excludeColumnName = this.parameter.getExcludeColumnNames()).isEmpty()) {
                Collection<String> newV = DBUtils.toCaseInsensitiveColumnNameCollections(serverMode, excludeColumnName, HashSet::new);
                excludeColumnName.clear();
                excludeColumnName.addAll(newV);
            }
            if (!(excludeDataTypes = this.parameter.getExcludeDataTypes()).isEmpty()) {
                Set newV = excludeDataTypes.stream().map(t -> t.toLowerCase(Locale.getDefault())).collect(Collectors.toSet());
                excludeDataTypes.clear();
                excludeDataTypes.addAll(newV);
            }
            AdvancedOption advancedOption = new AdvancedOption(this.parameter, target.connectionKey.getServerMode());
            Database database = target.connectionKey.getMetadataProvider().queryDatabase(target.connectionKey, advancedOption);
            this.parameter.setDatabase(database);
            this.parameter.setDatabaseName(database.getSchemaName());
            if (!JavaOpts.skipTableNameCheck.booleanValue() && CollectionUtils.isNotEmpty((Collection)this.parameter.getWhiteListMap().get((Object)ObjectType.TABLE))) {
                Preconditions.checkArgument((boolean)this.parameter.getWhiteListMap().get((Object)ObjectType.TABLE).stream().noneMatch(t -> StringUtils.contains(t, ".")), (Object)"Table names must not contain the '.' character to prevent ambiguity in filenames during import\n- Note:\tThis check aims to prevent ambiguity when import from exported files; \n- a table name containing '.' would make it impossible to extract the real table name from the filename upon import, thus failing to correctly map to the database table\n- e.g. Table `test.1` may yield 3 possible output depends on user options, which is, `test.1.csv`, `test.1.0.csv` or `test.1.1.0.csv`. Obloader cannot distinguish them!\n- To resolve this, you may simply use option `--exclude-table` to exclude those invalid ones, or set `-Dskip.tableName.check=true` in obdumper shell script to skip this check, only as you acknowledge the potential risk.");
            }
            if (this.parameter.isIncludeDdl()) {
                this.parameter.getWhiteListMap().putAll(advancedOption.getAllowedObjectMap());
            }
            if (serverMode.isMysqlMode() || this.parameter.getSessionConfig().useOracleStreamResultSet()) {
                this.parameter.setFetchSize(Integer.MIN_VALUE);
            }
            target.state = State.INITIAL;
            return target;
        }
    }
}

