/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.client.LoadClient;
import com.oceanbase.tools.loaddump.client.LoadDataInfileClient;
import com.oceanbase.tools.loaddump.cmd.AbstractCommandParser;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.CustomHelpSectionRenderer;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.cmd.VersionProvider;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.CompatMode;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.SourceType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.utils.CmdCheckUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="obloader", subcommands={CommandLine.HelpCommand.class}, resourceBundle="com.oceanbase.loaddump.bundle.cli", versionProvider=VersionProvider.class, sortOptions=false, header={"@|green    ____                                  ____                       |@", "@|green   / __ \\  _____  ___   ____ _   ____    / __ )  ____ _   _____  ___ |@", "@|green  / / / / / ___/ / _ \\ / __ `/  / __ \\  / __  | / __ `/  / ___/ / _ \\|@", "@|green / /_/ / / /__  /  __// /_/ /  / / / / / /_/ / / /_/ /  (__  ) /  __/|@", "@|green \\____/  \\___/  \\___/ \\__,_/  /_/ /_/ /_____/  \\__,_/  /____/  \\___/ |@", "@|green                                                                     |@"}, footer={"%nExamples:", "@|italic \te.g: ./obloader -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxx -D USERA --ddl --all -f /Users/admin/DUMP-1/%n |@", "@|italic \te.g: ./obloader -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxx -D USERA --csv --all -f /Users/admin/DUMP-1/%n |@"})
public class Obloader
extends AbstractCommandParser
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Obloader.class);
    @CommandLine.Option(names={"--rw"}, description={"Interpret the ratio of reader / writer"})
    private double rw = 1.0;
    @CommandLine.Option(names={"--batch"}, description={"Interpret the batch size for per insert"})
    private int batch;
    @CommandLine.Option(names={"--max-tps"}, description={"Interpret the max tps for concurrent insert"})
    private int maxTps = Integer.MAX_VALUE;
    @CommandLine.Option(names={"--max-errors"}, description={"Interpret to support ignore error mode"})
    private int maxErrors = 1000;
    @CommandLine.Option(names={"--max-discards"}, description={"Interpret the threshold of discard records tolerance"})
    private int maxDiscards = 1000;
    @CommandLine.Option(names={"--strict"}, description={"Interpret that the process should exit with code 1 if there is any bad or discard record"})
    private Boolean strict;
    @CommandLine.Option(names={"--ignore-unhex"}, description={"Interpret to ignore the unhex function"})
    private boolean ignoreUnhex;
    @CommandLine.Option(names={"--ignore-escape"}, description={"Interpret to ignore the escape data file"})
    private boolean ignoreEscape;
    @CommandLine.Option(names={"--replace-data"}, description={"Interpret to replace data of duplicated primary/unique keys"})
    private boolean replaceData;
    @CommandLine.Option(names={"--skip-footer"}, description={"Interpret to skip the last row of cut file"})
    private boolean skipFooter;
    @CommandLine.Option(names={"--slow"}, description={"Interpret the threshold to slow the writer threads"})
    private double slow = 0.75;
    @CommandLine.Option(names={"--pause"}, description={"Interpret the threshold to pause the writer threads"})
    private double pause = 0.85;
    @CommandLine.Option(names={"--replace-object"}, description={"Interpret to replace object if it exists"})
    private boolean replaceObject;
    @CommandLine.Option(names={"--truncate-table"}, description={"Interpret to truncate table before load data"})
    private boolean truncateTable;
    @CommandLine.Option(names={"--delete-from-table"}, description={"Interpret to delete from table before load data"})
    private boolean deleteFromTable;
    @CommandLine.Option(names={"--yes", "-y"}, description={"Interpret to confirm the truncate/delete operation"})
    private boolean yesConfirm;
    @CommandLine.Option(names={"--external-data"}, description={"Interpret the data is dumped by 3rd-part tools"})
    private boolean externalData;
    @CommandLine.Option(names={"--file-regular-expression"}, description={"Interpret the regular expression of data files"})
    private String fileNameRegExp;
    @CommandLine.Option(names={"--max-wait-timeout"}, description={"If overload, the thread can wait up to N minutes"})
    private int maxWaitTimeout = 180;
    @CommandLine.Option(names={"--block-size"}, description={"Interpret the block size in MB for large file"})
    private long blockSize;
    @CommandLine.Option(names={"--direct"}, description={"Indicate using direct load mode."})
    private boolean direct;
    @CommandLine.Option(names={"--rpc-port"}, description={"Only used in direct load mode. Interpret the inner RPC port for connection"})
    private int rpcPort;
    @CommandLine.Option(names={"--buffer-size"}, description={"Interpret the ring buffer capacity."})
    private int bufferSize = Obloader.defaultBufferSize();
    @CommandLine.Option(names={"--compat-mode"}, description={"Enable compatible-load mode for loading DDL. It currently only supported 'mysql'."})
    private String compatMode = "mysql56";
    @CommandLine.Option(names={"--auto-column-mapping"}, description={"Auto map field name from file header to table column"})
    private boolean autoColumnMapping;
    @CommandLine.Option(names={"--source-type"}, description={"options: [hive]"})
    private String sourceType;
    @CommandLine.Option(names={"--default-date"}, description={"The replacement value used for date data parsing failure is only effective for date and datetime data in MySQL mode"})
    private String defaultDateValue;
    @CommandLine.Option(names={"--date-format"}, description={"The original data format for date data parsing, used with the --default-date option"})
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private int confirmTimes = 0;
    private static final int MAX_CONFIRM_TIMES = 3;

    public static void main(String[] args) {
        Obloader loader = new Obloader();
        CommandLine cmd = new CommandLine((Object)loader);
        cmd.parseArgs(args);
        CmdCheckUtils.checkDuplicateArgs(cmd);
        boolean isSubHelp = false;
        CustomHelpSectionRenderer custom = new CustomHelpSectionRenderer(TaskType.LOAD);
        if (args.length == 1) {
            for (String key : CustomHelpSectionRenderer.LOADER_OPTION_MAPPING.keySet()) {
                if (!key.equals(args[0].trim())) continue;
                custom.setDependent(key);
                isSubHelp = true;
                break;
            }
        }
        cmd.getHelpSectionMap().put("optionList", custom);
        cmd.setUsageHelpAutoWidth(true);
        cmd.setUsageHelpLongOptionsMaxWidth(60);
        cmd.setUsageHelpWidth(150);
        if (cmd.isUsageHelpRequested() || args.length == 0 || isSubHelp) {
            cmd.usage(cmd.getOut());
        } else if (cmd.isVersionHelpRequested()) {
            cmd.printVersionHelp(cmd.getOut());
        } else {
            loader.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.printParseArgs();
        Obloader.checkJavaVersion();
        int exitStatus = 0;
        RuntimeMetrics metrics = new RuntimeMetrics();
        try {
            LoadParameter parameter = this.parseCommandArgs();
            if (parameter.isUseServer()) {
                Stopwatch stopwatch;
                if (StringUtils.isBlank(parameter.getLineSeparator())) {
                    parameter.setLineSeparator(System.lineSeparator());
                }
                try (LoadDataInfileClient loadDataInfileClient = LoadDataInfileClient.builder().parameter(parameter).build();){
                    log.info("{}", (Object)SqlNotesUtil.getVersion());
                    stopwatch = Stopwatch.createStarted();
                    exitStatus = loadDataInfileClient.loadRecord();
                }
                log.info("Remote load record finished. Total Elapsed: {}", (Object)stopwatch.stop());
                return;
            }
            try (LoadClient client = new LoadClient.Builder(parameter).build();){
                Stopwatch stopwatch;
                log.info("{}", (Object)SqlNotesUtil.getVersion());
                if (JavaOpts.isBackupRestoreMode && !this.common.getObjectTypes().isAll()) {
                    parameter.setSourceTargetTableMap(this.buildTableMapping());
                }
                DataFormat dataFormat = parameter.getDataFormat();
                if (parameter.isIncludeDdl() || dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL) {
                    stopwatch = Stopwatch.createStarted();
                    parameter.setExternal(parameter.isExternal() || DataFormat.MIX.equals((Object)dataFormat));
                    exitStatus += this.waitUntilDone(client.loadSchema());
                    log.info("Load schema finished. Total Elapsed: {}", (Object)stopwatch.stop());
                }
                if (dataFormat != null && dataFormat != DataFormat.MIX && dataFormat != DataFormat.DDL) {
                    if (parameter.isIncludeDdl() && this.isReplaceObject()) {
                        log.info("Wait for observer to refresh schema...");
                        TimeUtils.sleep(TimeUnit.SECONDS, 5L);
                    }
                    stopwatch = Stopwatch.createStarted();
                    TaskContext context = client.loadRecord();
                    exitStatus += this.waitUntilDone(context);
                    metrics = context.getRuntimeMetrics();
                    log.info("Load record finished. Total Elapsed: {}", (Object)stopwatch.stop());
                }
            }
        }
        catch (Throwable e) {
            String rootCause = ExceptionUtils.getRootCauseMessage(e);
            if (StringUtils.containsIgnoreCase((CharSequence)rootCause, (CharSequence)"table or view does not exist")) {
                rootCause = rootCause + ", user might not have permission of dependent system views, such as __all_virtual_proxy_schema\u3001dba_ob_ls_locations\u3001dba_ob_major_compaction\u3001gv$ob_memstore. You can simply grant permission like this: grant select on oceanbase.* to 'user'. If you are using oracle mode, user might not have permission of dependent system views, such as dba_dependencies, dba_constraints. You can try: grant select on dba_dependencies to 'user'; grant select on dba_constraints to 'user'.";
            } else if (JdbcUtils.isCreateWithoutDependenciesError(rootCause)) {
                rootCause = rootCause + ", you might need to grant user the permission by executing: grant select on xxx.xxx to 'user'";
            }
            if (rootCause.contains(Constants.NO_SUB_FILES) || rootCause.contains(Constants.FILE_NOT_FOUND)) {
                log.warn(rootCause);
                exitStatus = 0;
            } else {
                exitStatus = 1;
                if (JavaOpts.isMultiTask()) {
                    if (JavaOpts.isDebugable) {
                        log.error("Load failed!", e);
                    } else {
                        log.error("Load failed! Error: {}", (Object)rootCause);
                    }
                } else {
                    if (JavaOpts.isDebugable) {
                        e.printStackTrace();
                    }
                    LogUtils.error("Load failed! Error: {}", rootCause);
                }
            }
        }
        finally {
            this.doFinally(metrics, exitStatus);
        }
    }

    @Override
    protected LoadParameter parseCommandArgs() throws Exception {
        String fileSuffix;
        LoadParameter parameter = new LoadParameter();
        parameter.setFailFast(false);
        super.parseCommonArgs(parameter);
        Common.Base base = this.common.getBase();
        ObjectTypes objects = this.common.getObjectTypes();
        DataFormat dataFormat = parameter.getDataFormat();
        if (parameter.getDataFormat() != DataFormat.MIX) {
            Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Option --all, --table or other object options are missing");
            parameter.getWhiteListMap().putAll(this.parseAllowedObjects(objects));
            parameter.getBlackListMap().putAll(this.parseDisallowedObjects(objects));
        }
        parameter.setAll(objects != null && objects.isAll());
        Set<String> tableSet = parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        if (parameter.isIncludeDdl() && dataFormat == null) {
            dataFormat = DataFormat.DDL;
            parameter.setDataFormat(dataFormat);
        }
        Preconditions.checkArgument((dataFormat != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        if (!parameter.isIncludeDdl()) {
            parameter.getWhiteListMap().clear();
            parameter.getWhiteListMap().put(ObjectType.TABLE, tableSet);
        }
        if (StringUtils.isNotBlank(fileSuffix = base.getFileSuffix())) {
            parameter.setFileSuffixes(Collections.singletonList(fileSuffix));
        } else if (dataFormat.isReadable()) {
            parameter.setFileSuffixes(dataFormat.getFileSuffixes().stream().map(s -> s + parameter.getCompressAlgo().getSuffix()).collect(Collectors.toList()));
        } else {
            parameter.setFileSuffixes(dataFormat.getFileSuffixes());
        }
        if (parameter.isUseServer()) {
            Preconditions.checkArgument((!this.isTruncateTable() ? 1 : 0) != 0, (Object)"Options --server and --truncate-table cannot be used simultaneously, the --truncate-table option is not supported in server mode.");
            Preconditions.checkArgument((!this.isDeleteFromTable() ? 1 : 0) != 0, (Object)"Options --server and --delete-from-table cannot be used simultaneously, the --delete-from-table option is not supported in server mode.");
        }
        this.confirmRiskOperation(objects);
        parameter.setTruncatable(this.isTruncateTable());
        parameter.setDeleteable(this.isDeleteFromTable());
        parameter.setFileNameRegExp(this.getFileNameRegExp());
        parameter.setBlockSize(this.getBlockSize() == 0L ? 0x4000000L : this.getBlockSize() * 0x100000L);
        String sourceType = this.getSourceType();
        boolean autoColumnMapping = this.isAutoColumnMapping();
        if (StringUtils.isNotBlank(sourceType)) {
            if (!SourceType.supports(sourceType)) {
                throw new UnsupportedOperationException("Option '--source-type' only support [ hive ] now.");
            }
            if (!DataFormat.isHiveDirSupported(dataFormat)) {
                throw new UnsupportedOperationException("Option '--source-type' does not support [ " + (Object)((Object)dataFormat) + " ] now.");
            }
            autoColumnMapping = true;
        }
        parameter.setSourceType(sourceType);
        boolean fileFormatSupported = DataFormat.isAutoColumnMappingSupported(dataFormat);
        if (autoColumnMapping && !fileFormatSupported) {
            throw new UnsupportedOperationException("Option '--auto-column-mapping' does not support [ " + (Object)((Object)dataFormat) + " ] file now.");
        }
        parameter.setAutoColumnMapping(autoColumnMapping);
        if (autoColumnMapping) {
            parameter.setSkipHeader(true);
        }
        if (StringUtils.isNotBlank(base.getCtlPath())) {
            if (autoColumnMapping) {
                throw new UnsupportedOperationException("Option '--ctl-path' and '--auto-column-mapping' conflict each other, please remove one of them and try again.");
            }
            File ctlDir = new File(base.getCtlPath());
            if (ctlDir.isFile()) {
                FileUtils.checkValidFile(ctlDir);
            } else {
                FileUtils.checkValidDirectory(ctlDir);
            }
            parameter.setCtlPath(ctlDir.getAbsolutePath());
        }
        parameter.setDirectMode(this.direct);
        if (this.direct && !base.isUseServer()) {
            Preconditions.checkArgument((this.rpcPort > 0 && this.rpcPort < 65535 ? 1 : 0) != 0, (Object)"RPC port (--rpc-port) should be specified in direct mode.");
            parameter.setRpcPort(this.rpcPort);
        }
        parameter.setBatchSize(this.getBatch());
        parameter.setBufferSize(this.bufferSize);
        parameter.setTpsLimit(this.getMaxTps());
        if (parameter.isDirectMode()) {
            if (this.maxErrors != 1000 || this.maxDiscards != 1000) {
                LogUtils.warn("Both `--max-errors` and `--max-discards` are not supported yet. They will be set to 0 by default");
            }
            parameter.setMaxErrors(0);
            parameter.setMaxDiscards(0);
        } else {
            parameter.setMaxErrors(this.maxErrors);
            parameter.setMaxDiscards(this.maxDiscards);
        }
        parameter.setSkipFooter(DataFormat.CUT.equals((Object)dataFormat) && this.isSkipFooter());
        parameter.setExternal(this.isExternalData());
        parameter.setIgnoreUnhex(this.isIgnoreUnhex());
        parameter.setIgnoreEscape(this.isIgnoreEscape());
        parameter.setReplaceData(this.isReplaceData());
        parameter.setStrict(this.strict == null ? true : this.strict);
        parameter.setReplaceObjectIfExists(this.isReplaceObject());
        parameter.setCompatMode(CompatMode.of(this.compatMode));
        parameter.setMaxWaitTimeMillis(TimeUnit.MINUTES.toMillis(this.getMaxWaitTimeout()));
        parameter.setDefaultDateValue(this.defaultDateValue);
        parameter.setDateFormat(this.dateFormat);
        parameter.setReadWriteRatio(this.getRw() < 0.0 || this.getRw() > 1.0 ? 1.0 : this.getRw());
        parameter.setSlowInsertThreshold(this.getSlow() < 0.0 || this.getSlow() > 1.0 ? 0.75 : this.getSlow());
        parameter.setPauseInsertThreshold(this.getPause() < 0.0 || this.getPause() > 1.0 ? 0.85 : this.getPause());
        return parameter;
    }

    private static int defaultBufferSize() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 0x80000000L) {
            return 512;
        }
        if (maxMem < 0x100000000L) {
            return 1024;
        }
        return 4096;
    }

    private void confirmRiskOperation(ObjectTypes objects) throws Exception {
        if (!this.isTruncateTable() && !this.isDeleteFromTable()) {
            return;
        }
        if (this.isYesConfirm()) {
            LogUtils.warn("The truncate/delete operation confirmation is skipped.");
            return;
        }
        if (this.confirmTimes++ > 3) {
            throw new UnsupportedOperationException("Please confirm your risk operation");
        }
        System.out.println();
        System.out.println(StringUtils.repeat((String)"=", (int)66));
        StringBuilder sb = new StringBuilder(256);
        sb.append("\nCaution: High-risk operation.");
        if (this.isTruncateTable()) {
            sb.append("The --truncate command will clear the target table. Please ensure the action is as expected. [Y/N]:");
        } else if (this.isDeleteFromTable()) {
            sb.append("The --delete command will clear the target table. Please ensure the action is as expected. [Y/N]:");
        }
        System.out.println(sb.toString());
        char[] buf = new char[2];
        try (InputStreamReader isr = new InputStreamReader(System.in);){
            int readChars = isr.read(buf);
            if (readChars < 0 || Character.toLowerCase(buf[0]) != 'y' && Character.toLowerCase(buf[0]) != 'n' || buf[1] != '\n') {
                this.confirmRiskOperation(objects);
                return;
            }
            Preconditions.checkArgument((Character.toLowerCase(buf[0]) == 'y' ? 1 : 0) != 0, (Object)"Operation aborted. No changes were made.");
        }
        System.out.println();
        LogUtils.info("Action confirmed. Program keep running...");
    }

    public double getRw() {
        return this.rw;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxTps() {
        return this.maxTps;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public Boolean getStrict() {
        return this.strict;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public boolean isIgnoreEscape() {
        return this.ignoreEscape;
    }

    public boolean isReplaceData() {
        return this.replaceData;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public double getSlow() {
        return this.slow;
    }

    public double getPause() {
        return this.pause;
    }

    public boolean isReplaceObject() {
        return this.replaceObject;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public boolean isDeleteFromTable() {
        return this.deleteFromTable;
    }

    public boolean isYesConfirm() {
        return this.yesConfirm;
    }

    public boolean isExternalData() {
        return this.externalData;
    }

    public String getFileNameRegExp() {
        return this.fileNameRegExp;
    }

    public int getMaxWaitTimeout() {
        return this.maxWaitTimeout;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCompatMode() {
        return this.compatMode;
    }

    public boolean isAutoColumnMapping() {
        return this.autoColumnMapping;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getDefaultDateValue() {
        return this.defaultDateValue;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public int getConfirmTimes() {
        return this.confirmTimes;
    }
}

