/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.cmd.Obloader;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.Version;
import com.oceanbase.tools.loaddump.tablefmt.CellStyle;
import com.oceanbase.tools.loaddump.tablefmt.Table;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ObloaderDebuger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PrecheckLogger");
    private static final String PING_SQL = "select 1 from dual";
    private static final String[] MEM_UNITS = new String[]{"B", " KB", " MB", " GB", " TB", " PB"};
    private static final long _8_MB = 0x800000L;
    private static final long _16_MB = 0x1000000L;
    private static final Version JAVA_1_8_0_200 = new Version("1.8.0_200");
    private static final DecimalFormat DEC_FORMAT_2 = new DecimalFormat("0.00");
    private static final DecimalFormat DEC_FORMAT_4 = new DecimalFormat("0.0000");
    private static final String INFO_LOG_FILE_NAME = "ob-loader-dumper.info";
    private static final String WARN_LOG_FILE_NAME = "ob-loader-dumper.warn";
    private static final String TRACE_LOG_FILE_NAME = "ob-loader-dumper.trace";
    private static final String INSERT_MARK = "JDBC insert";
    private static final String ELAPSED_MARK = "elapsed:";
    private static final String TOTAL_ELAPSED_MARK = "Total Elapsed:";
    private static final String ENQ_PERF_MONITOR_MARK = "1. Enqueue Performance Monitor:";
    private static final String URL_PATTERN = "jdbc:oceanbase://{0}:{1}/{2}?useSSL=false&connectTimeout=5000&socketTimeout=5000&usePipelineAuth=false";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int status = 0;
        try {
            CliArg cliArg = new CliArg(args);
            ObloaderDebuger.clearLog(cliArg.getTraceLogFile());
            LOGGER.trace("\n{}", (Object)StringUtils.repeat((char)'*', (int)150));
            ObloaderDebuger.checkEnv();
            ObloaderDebuger.checkTool(cliArg);
            Map<String, Integer> originalParamterMap = ObloaderDebuger.checkObserver(cliArg);
            cliArg.setOriginalParameterMap(originalParamterMap);
            Report prev = ObloaderDebuger.runPrevAdjustment(cliArg);
            Report post = ObloaderDebuger.runPostAdjustment(cliArg);
            LOGGER.trace("\n\u5bfc\u5165\u8c03\u53c2\u524d\u540e\u6027\u80fd\u5bf9\u6bd4\uff1a{}", (Object)post.compareWith(prev));
            LOGGER.trace("\n{}", (Object)StringUtils.repeat((char)'*', (int)150));
        }
        catch (Throwable t) {
            status = 1;
            t.printStackTrace();
        }
        finally {
            System.exit(status);
        }
    }

    private static void checkEnv() {
        LOGGER.trace("\n\n\u865a\u62df\u673a\u8fd0\u884c\u73af\u5883\u68c0\u67e5:");
        Properties props = System.getProperties();
        Object jvmVendor = props.get("java.vm.vendor");
        LOGGER.trace("\t JVM\u865a\u62df\u673a\u5382\u5546\uff1a{}", jvmVendor);
        String jvmName = props.get("java.vm.name").toString();
        jvmName = "OpenJDK 64-Bit Server VM";
        if (jvmName.contains("OpenJDK")) {
            jvmName = jvmName + "\t\uff08\u5f3a\u70c8\u5efa\u8bae\uff1a\u4f7f\u7528 Java HotSpot(TM) JDK\u3002\uff09";
        }
        LOGGER.trace("\t JVM\u865a\u62df\u673a\u540d\u79f0\uff1a{}", (Object)jvmName);
        String javaRuntimeVersion = props.get("java.runtime.version").toString();
        if (new Version(javaRuntimeVersion).isOlderThan(JAVA_1_8_0_200)) {
            javaRuntimeVersion = javaRuntimeVersion + "\t\uff08\u5f3a\u70c8\u5efa\u8bae\uff1a\u5347\u7ea7JDK 1.8\u81f3\u6700\u65b0\u7684\u5c0f\u7248\u672c\u3002\uff09";
        }
        LOGGER.trace("\t JVM\u865a\u62df\u673a\u7248\u672c\uff1a{}", (Object)javaRuntimeVersion);
        double maxMemory = Runtime.getRuntime().maxMemory();
        String heapMemory = ObloaderDebuger.convertUnit(maxMemory);
        if (maxMemory / 1024.0 < 1.6777216E7) {
            heapMemory = heapMemory + "\t\uff08\u5f3a\u70c8\u5efa\u8bae\uff1a\u8c03\u6574 -Xms/-Xmx \u53c2\u6570\u503c\u81f3 32GB\u4ee5\u4e0a\u3002\uff09";
        }
        LOGGER.trace("\t JVM\u865a\u62df\u673a\u6700\u5927\u5806\u5185\u5b58\uff1a{}", (Object)heapMemory);
    }

    private static void checkTool(CliArg cliArg) throws Exception {
        LOGGER.trace("\n\n\u547d\u4ee4\u884c\u9009\u9879\u5408\u7406\u6027\u68c0\u67e5:");
        int batch = 0;
        int thread = 0;
        double xmX = (double)Runtime.getRuntime().maxMemory() / 1024.0;
        if (xmX <= 8388608.0) {
            batch = 50;
            thread = 4;
            LOGGER.trace("\t JVM\u865a\u62df\u673a\u5806\u5185\u5b58\u592a\u5c0f\uff08<=8GB\uff09\u3002\uff08\u5efa\u8bae\uff1a\u547d\u4ee4\u884c\u9009\u9879\u8c03\u6574\u4e3a --batch {} --thread {}\uff09", (Object)batch, (Object)thread);
        } else if (xmX <= 1.6777216E7) {
            batch = 100;
            thread = 8;
            LOGGER.trace("\t JVM\u865a\u62df\u673a\u5806\u5185\u5b58\u8f83\u5c0f\uff08<=16GB\uff09\u3002\uff08\u5efa\u8bae\uff1a\u547d\u4ee4\u884c\u9009\u9879\u8c03\u6574\u4e3a --batch {} --thread {}\uff09", (Object)batch, (Object)thread);
        }
        try {
            LOGGER.trace("\n\n\u547d\u4ee4\u884c\u5de5\u5177\u7a7a\u5199\u6027\u80fd\u6d4b\u8bd5\uff1a");
            JavaOpts.isDryRunMode = true;
            Obloader.main(cliArg.getArgs());
            JavaOpts.isDryRunMode = false;
            ObloaderDebuger.analysisLog(cliArg);
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\u547d\u4ee4\u884c\u5de5\u5177\u7a7a\u5199\u6027\u80fd\u6d4b\u8bd5\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
    }

    private static Map<String, Integer> checkObserver(CliArg cliArg) throws Exception {
        LOGGER.trace("\n\n\u6570\u636e\u5e93\u7f51\u7edc\u5ef6\u65f6\u68c0\u67e5\uff1a");
        try (Connection conn = ObloaderDebuger.getConnection(cliArg.getUrl(false), cliArg.getUser(), cliArg.getPassword());){
            PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(PING_SQL));
            Object object = null;
            try {
                for (int i = 0; i < 10; ++i) {
                    long begin = System.currentTimeMillis();
                    try (ResultSet rs = pstmt.executeQuery();){
                        if (!rs.next() || rs.getInt(1) != 1) continue;
                        long elaspsed = System.currentTimeMillis() - begin;
                        String note = elaspsed > 1L ? "\uff08\u63d0\u9192\uff1a\u7f51\u7edc\u5ef6\u65f6\u8f83\u5927\uff0c\u5efa\u8bae <1ms\uff09" : "";
                        LOGGER.trace("\t\u63a2\u6d4b\u8bed\u53e5\uff1a{}; >>> \u7f51\u7edc\u5ef6\u65f6\uff1a{} \u6beb\u79d2\u3002 {}", new Object[]{PING_SQL, elaspsed, note});
                        continue;
                    }
                }
            }
            catch (Throwable i) {
                object = i;
                throw i;
            }
            finally {
                if (pstmt != null) {
                    if (object != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)object).addSuppressed(i);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\u6570\u636e\u5e93\u7f51\u7edc\u5ef6\u65f6\u68c0\u6d4b\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
        LOGGER.trace("\n\n\u6570\u636e\u5e93\u7cfb\u7edf\u53c2\u6570\u68c0\u67e5\uff1a");
        Set<Parameter> parameters = ObloaderDebuger.showSystemParameters(cliArg);
        int index = 1;
        Table table = ObloaderDebuger.createTable();
        for (Parameter parameter : parameters) {
            table.addCell(String.valueOf(index++));
            table.addCell("  " + parameter.getName(), new CellStyle(CellStyle.HorizontalAlign.LEFT));
            table.addCell(String.valueOf(parameter.getOriginalValue()));
            table.addCell("  " + parameter.getNotice(), new CellStyle(CellStyle.HorizontalAlign.LEFT));
        }
        LOGGER.trace(table.render().toString());
        LOGGER.trace("\n\n\u6570\u636e\u5e93\u5185\u6838\u7684\u6027\u80fd\u8bca\u65ad\uff1a");
        LOGGER.trace("\t\u8054\u7cfb\u5382\u5546\u7814\u53d1\u4eba\u5458\u83b7\u53d6\u6570\u636e\u5e93\u5185\u6838\u8bca\u65ad\u5de5\u5177\u3002");
        return parameters.stream().collect(Collectors.toMap(Parameter::getName, Parameter::getOriginalValue, (key1, key2) -> key2));
    }

    private static Report runPrevAdjustment(CliArg cliArg) throws Exception {
        LOGGER.trace("\n\n\u547d\u4ee4\u884c\u5de5\u5177\u5bfc\u5165\u6027\u80fd\u6d4b\u8bd5\uff08\u8c03\u53c2\u524d\uff09\uff1a");
        try {
            Obloader.main(cliArg.getArgs());
            return ObloaderDebuger.analysisLog(cliArg);
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\uff08\u8c03\u53c2\u524d\uff09\u8fd0\u884c\u5bfc\u5165\u5de5\u5177\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
    }

    private static Report runPostAdjustment(CliArg cliArg) throws Exception {
        LOGGER.trace("\n\n\u547d\u4ee4\u884c\u5de5\u5177\u5bfc\u5165\u6027\u80fd\u6d4b\u8bd5\uff08\u8c03\u53c2\u540e\uff09\uff1a");
        try {
            ObloaderDebuger.setSystemParameters(Parameter.getRecommendedParamMap(), cliArg);
            Obloader.main(cliArg.getArgs());
            Report report = ObloaderDebuger.analysisLog(cliArg);
            return report;
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\uff08\u8c03\u53c2\u540e\uff09\u8fd0\u884c\u5bfc\u5165\u5de5\u5177\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
        finally {
            ObloaderDebuger.setSystemParameters(cliArg.getOriginalParameterMap(), cliArg);
        }
    }

    private static Set<Parameter> showSystemParameters(CliArg cliArg) throws Exception {
        LinkedHashSet<Parameter> parameters = new LinkedHashSet<Parameter>();
        try (Connection conn = ObloaderDebuger.getConnection(cliArg.getUrl(false), cliArg.getUser(), cliArg.getPassword());){
            for (String parameterName : Parameter.getParameterNames()) {
                String show = "show parameters like '" + parameterName + "'";
                PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(show));
                Throwable throwable = null;
                try {
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            parameters.add(new Parameter(parameterName, rs.getInt("value")));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\u67e5\u770b\u6570\u636e\u5e93\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
        return parameters;
    }

    /*
     * Exception decompiling
     */
    private static void setSystemParameters(Map<String, Integer> paramMap, CliArg cliArg) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Connection getConnection(String url, String user, String password) throws Exception {
        try {
            return DriverManager.getConnection(url, user, password);
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\u83b7\u53d6\u666e\u901a\u79df\u6237\u7684\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
    }

    private static Connection getSysConnection(String url, String sysUser, String sysPassword) {
        try {
            return DriverManager.getConnection(url, sysUser, sysPassword);
        }
        catch (Throwable t) {
            throw new PreCheckFailureException("\u83b7\u53d6\u7cfb\u7edf\u79df\u6237\u7684\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", t);
        }
    }

    private static String convertUnit(double size) {
        double mod = 1024.0;
        int i = 0;
        while (size >= mod) {
            size /= mod;
            ++i;
        }
        return new BigDecimal(size).setScale(2, RoundingMode.HALF_UP).doubleValue() + MEM_UNITS[i];
    }

    private static Table createTable() {
        Table table = new Table(4);
        table.setColumnWidth(0, 5, 5);
        table.setColumnWidth(1, 40, 40);
        table.setColumnWidth(2, 10, 10);
        table.setColumnWidth(3, 100, 100);
        table.addCell(" No. ");
        table.addCell(" Name ");
        table.addCell(" Value ");
        table.addCell(" Info ");
        return table;
    }

    private static void clearLog(File logFile) throws IOException {
        FileUtils.write((File)logFile, (CharSequence)"", (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    private static Report analysisLog(CliArg cliArg) throws Exception {
        if (!cliArg.getInfoLogFile().exists()) {
            throw new PreCheckFailureException("\u65e5\u5fd7\u6587\u4ef6: \"{}\" \u672a\u627e\u5230", cliArg.getInfoLogFile());
        }
        String totalElapsed = null;
        ArrayList<String> tpsList = new ArrayList<String>();
        ArrayList<String> throughputList = new ArrayList<String>();
        ArrayList<Pair<String, String>> slotList = new ArrayList<Pair<String, String>>();
        TreeMap<String, List> mvm = new TreeMap<String, List>((k1, k2) -> {
            int res = Integer.parseInt(k1) - Integer.parseInt(k2);
            return res == 0 ? 0 : res / Math.abs(res);
        });
        LineIterator iter = FileUtils.lineIterator((File)cliArg.getInfoLogFile());
        while (iter.hasNext()) {
            String line = iter.nextLine();
            if (line.contains(ENQ_PERF_MONITOR_MARK)) {
                for (int i = 0; i < 4 && iter.hasNext(); ++i) {
                    line = iter.next();
                }
                String[] enqMetrics = line.split("\\|");
                for (int i = 0; i < 9 && iter.hasNext(); ++i) {
                    line = iter.next();
                }
                String[] deqMetrics = line.split("\\|");
                tpsList.add(deqMetrics[1].trim());
                throughputList.add(deqMetrics[2].trim());
                slotList.add(new Pair<String, String>(enqMetrics[3].trim(), deqMetrics[3].trim()));
                continue;
            }
            int insertMarkIdx = line.indexOf(INSERT_MARK);
            int elapsedMarkIdx = line.indexOf(ELAPSED_MARK);
            if (insertMarkIdx > -1 && elapsedMarkIdx > -1) {
                String rows = line.substring(insertMarkIdx + 11, line.indexOf("rows"));
                String elapsed = line.substring(elapsedMarkIdx + 8, line.indexOf(46, insertMarkIdx));
                List elapsedList = mvm.getOrDefault(rows.trim(), new ArrayList());
                elapsedList.add(elapsed.trim());
                mvm.putIfAbsent(rows.trim(), elapsedList);
                continue;
            }
            int totalElapsedMarkIdx = line.indexOf(TOTAL_ELAPSED_MARK);
            if (totalElapsedMarkIdx <= -1) continue;
            totalElapsed = line.substring(totalElapsedMarkIdx + TOTAL_ELAPSED_MARK.length());
        }
        long totalRecords = 0L;
        for (Map.Entry entry : mvm.entrySet()) {
            List values = (List)entry.getValue();
            totalRecords += (long)(Integer.parseInt((String)entry.getKey()) * values.size());
            List<Double> doubles = values.stream().map(t -> Double.valueOf(t.split("\\s")[0])).collect(Collectors.toList());
            OptionalDouble min = doubles.stream().mapToDouble(t -> t).min();
            OptionalDouble max = doubles.stream().mapToDouble(t -> t).max();
            OptionalDouble avg = doubles.stream().mapToDouble(t -> t).average();
            String minValue = min.isPresent() ? DEC_FORMAT_2.format(min.getAsDouble()) : "0.00D";
            String maxValue = max.isPresent() ? DEC_FORMAT_2.format(max.getAsDouble()) : "0.00D";
            String avgValue = avg.isPresent() ? DEC_FORMAT_2.format(avg.getAsDouble()) : "0.00D";
            LOGGER.trace("\t\u6279\u91cf\u5927\u5c0f\uff1a{}\uff0c\u603b\u5171\u63d2\u5165\u6b21\u6570: {}\uff0c\u8017\u65f6\u5206\u6790\uff1a[ \u6700\u4f4e\uff1a{} \u6beb\u79d2, \u6700\u9ad8\uff1a{} \u6beb\u79d2, \u5e73\u5747\uff1a{} \u6beb\u79d2 ]", new Object[]{entry.getKey(), values.size(), minValue, maxValue, avgValue});
            ObloaderDebuger.printHistogram(doubles.toArray(new Double[0]), min.getAsDouble(), max.getAsDouble());
            LOGGER.trace("");
        }
        LOGGER.trace("");
        LOGGER.trace("\t\u603b\u8bb0\u5f55\u6570: {}, \u603b\u8017\u65f6: {}", (Object)totalRecords, totalElapsed);
        Report report = new Report();
        List doubles = throughputList.stream().map(t -> Double.valueOf(t.split("\\s")[0])).collect(Collectors.toList());
        OptionalDouble min = doubles.stream().mapToDouble(t -> t).min();
        OptionalDouble max = doubles.stream().mapToDouble(t -> t).max();
        OptionalDouble avg = doubles.stream().mapToDouble(t -> t).average();
        LOGGER.trace("\t\u541e\u5410\u91cf: [ \u6700\u4f4e\uff1a{} \u5146\u5b57\u8282/\u79d2\uff0c\u6700\u5927\uff1a{} \u5146\u5b57\u8282/\u79d2\uff0c\u5e73\u5747\uff1a{} \u5146\u5b57\u8282/\u79d2 ]", new Object[]{min.isPresent() ? DEC_FORMAT_2.format(min.getAsDouble()) : Double.valueOf(0.0), max.isPresent() ? DEC_FORMAT_2.format(max.getAsDouble()) : Double.valueOf(0.0), avg.isPresent() ? DEC_FORMAT_2.format(avg.getAsDouble()) : Double.valueOf(0.0)});
        report.setMinThroughput(min.isPresent() ? min.getAsDouble() : 0.0);
        report.setMaxThroughput(max.isPresent() ? max.getAsDouble() : 0.0);
        report.setAvgThroughput(avg.isPresent() ? avg.getAsDouble() : 0.0);
        doubles = tpsList.stream().map(t -> Double.valueOf(t.split("\\s")[0])).collect(Collectors.toList());
        min = doubles.stream().mapToDouble(t -> t).min();
        max = doubles.stream().mapToDouble(t -> t).max();
        avg = doubles.stream().mapToDouble(t -> t).average();
        LOGGER.trace("\t\u63d2\u5165\u884c\u6570: [ \u6700\u4f4e: {} \u884c/\u79d2\uff0c\u6700\u5927\uff1a{} \u884c/\u79d2, \u5e73\u5747\uff1a{} \u884c/\u79d2 ]", new Object[]{min.isPresent() ? DEC_FORMAT_2.format(min.getAsDouble()) : Double.valueOf(0.0), max.isPresent() ? DEC_FORMAT_2.format(max.getAsDouble()) : Double.valueOf(0.0), avg.isPresent() ? DEC_FORMAT_2.format(avg.getAsDouble()) : Double.valueOf(0.0)});
        report.setMinTps(min.isPresent() ? min.getAsDouble() : 0.0);
        report.setMaxTps(max.isPresent() ? max.getAsDouble() : 0.0);
        report.setAvgTps(avg.isPresent() ? avg.getAsDouble() : 0.0);
        ObloaderDebuger.clearLog(cliArg.getInfoLogFile());
        ObloaderDebuger.clearLog(cliArg.getWarnLogFile());
        return report;
    }

    private static void printHistogram(Double[] values, double min, double max) {
        int c;
        double[] levels;
        int pieces;
        double binSize = Math.pow(10.0, Math.floor(Math.log10(max - min)));
        double minVal = Math.floor(min / binSize) * binSize;
        double maxVal = Math.ceil(max / binSize) * binSize;
        double range = maxVal - minVal;
        int n = max > 100.0 ? (max > 200.0 ? 20 : 10) : (pieces = max > 50.0 ? 5 : 3);
        if (range > 0.0) {
            while (range / binSize < (double)pieces) {
                binSize /= 2.0;
            }
            int binCount = Math.max(2, (int)Math.ceil(range / binSize)) + 1;
            levels = new double[binCount];
            for (c = 0; c < levels.length; ++c) {
                levels[c] = min + (double)c * binSize;
            }
        } else {
            levels = new double[]{min - Math.ulp(min), max + Math.ulp(max)};
        }
        int[] histos = ObloaderDebuger.createHistogram(values, levels);
        for (c = 0; c < levels.length - 1; ++c) {
            if (histos[c] == 0) continue;
            int total = values.length;
            String begin = DEC_FORMAT_2.format(Math.abs(levels[c]));
            String end = DEC_FORMAT_2.format(Math.abs(levels[c + 1]));
            String ratio = DEC_FORMAT_4.format((double)histos[c] * 100.0 / (double)total);
            StringBuilder sb = new StringBuilder(512);
            if (c == 0) {
                sb.append("\t\t\u63d2\u5165\u8017\u65f6\uff1a[{} \u6beb\u79d2 ~ {} \u6beb\u79d2)  \u5360\u6bd4\uff1a{}/{}\u2248{}%");
            } else {
                sb.append("\t\t\u63d2\u5165\u8017\u65f6\uff1a({} \u6beb\u79d2 ~ {} \u6beb\u79d2]  \u5360\u6bd4\uff1a{}/{}\u2248{}%");
            }
            if (c != 0 && histos[c] >= histos[0]) {
                sb.append("\t\uff08\u63d0\u9192\uff1a\u6027\u80fd\u51fa\u73b0\u6296\u52a8\uff0c\u8bf7\u68c0\u6d4b\u79df\u6237\u914d\u7f6e\u548c\u96c6\u7fa4\u72b6\u6001\uff1f\uff09");
            }
            LOGGER.trace(sb.toString(), new Object[]{begin, end, histos[c], total, ratio});
        }
    }

    private static int[] createHistogram(Double[] values, double[] levels) {
        if (levels.length < 2) {
            throw new IllegalArgumentException("Expected more than two levels");
        }
        int c = 0;
        Object[] sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(sortedValues);
        int[] result = new int[levels.length];
        Object[] objectArray = sortedValues;
        int n = objectArray.length;
        block0: for (int i = 0; i < n; ++i) {
            double value = (Double)objectArray[i];
            while (levels[c] > value || value > levels[c + 1]) {
                if (++c <= levels.length - 2) continue;
                break block0;
            }
            int n2 = c;
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    static class Report {
        private double minTps;
        private double maxTps;
        private double avgTps;
        private double minThroughput;
        private double maxThroughput;
        private double avgThroughput;

        public String compareWith(Report prev) {
            double prevMaxTps = Math.max(0.01, prev.getMaxTps());
            double prevAvgTps = Math.max(0.01, prev.getAvgTps());
            double prevMaxThroughput = Math.max(0.01, prev.getMaxThroughput());
            double prevAvgThroughput = Math.max(0.01, prev.getAvgThroughput());
            double currMaxTps = this.getMaxTps();
            double currAvgTps = this.getAvgTps();
            double currMaxThroughput = this.getMaxThroughput();
            double currAvgThroughput = this.getAvgThroughput();
            StringBuilder sb = new StringBuilder(128);
            sb.append("\n\t");
            sb.append("\u6700\u5927\u6bcf\u79d2\u63d2\u5165\u884c\u6570\uff1a");
            sb.append(DEC_FORMAT_2.format(100.0 * Math.abs(currMaxTps - prevMaxTps) / prevMaxTps));
            sb.append("% ").append(currMaxTps >= prevMaxTps ? "\u2191" : "\u2193");
            sb.append("\uff0c\u5e73\u5747\u6bcf\u79d2\u63d2\u5165\u884c\u6570: ");
            sb.append(DEC_FORMAT_2.format(100.0 * Math.abs(currAvgTps - prevAvgTps) / prevAvgTps));
            sb.append("% ").append(currAvgTps >= prevAvgTps ? "\u2191" : "\u2193");
            sb.append("\n\t");
            sb.append("\u6700\u5927\u6bcf\u79d2\u63d2\u5165\u5b57\u8282\u6570\uff1a");
            sb.append(DEC_FORMAT_2.format(100.0 * Math.abs(currMaxThroughput - prevMaxThroughput) / prevMaxThroughput));
            sb.append("% ").append(currMaxThroughput >= prevMaxThroughput ? "\u2191" : "\u2193");
            sb.append("\uff0c\u5e73\u5747\u6bcf\u79d2\u63d2\u5165\u5b57\u8282\u6570\uff1a");
            sb.append(DEC_FORMAT_2.format(100.0 * Math.abs(currAvgThroughput - prevAvgThroughput) / prevAvgThroughput));
            sb.append("% ").append(currAvgThroughput >= prevAvgThroughput ? "\u2191" : "\u2193");
            return sb.toString();
        }

        public double getMinTps() {
            return this.minTps;
        }

        public double getMaxTps() {
            return this.maxTps;
        }

        public double getAvgTps() {
            return this.avgTps;
        }

        public double getMinThroughput() {
            return this.minThroughput;
        }

        public double getMaxThroughput() {
            return this.maxThroughput;
        }

        public double getAvgThroughput() {
            return this.avgThroughput;
        }

        public void setMinTps(double minTps) {
            this.minTps = minTps;
        }

        public void setMaxTps(double maxTps) {
            this.maxTps = maxTps;
        }

        public void setAvgTps(double avgTps) {
            this.avgTps = avgTps;
        }

        public void setMinThroughput(double minThroughput) {
            this.minThroughput = minThroughput;
        }

        public void setMaxThroughput(double maxThroughput) {
            this.maxThroughput = maxThroughput;
        }

        public void setAvgThroughput(double avgThroughput) {
            this.avgThroughput = avgThroughput;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Report)) {
                return false;
            }
            Report other = (Report)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getMinTps(), other.getMinTps()) != 0) {
                return false;
            }
            if (Double.compare(this.getMaxTps(), other.getMaxTps()) != 0) {
                return false;
            }
            if (Double.compare(this.getAvgTps(), other.getAvgTps()) != 0) {
                return false;
            }
            if (Double.compare(this.getMinThroughput(), other.getMinThroughput()) != 0) {
                return false;
            }
            if (Double.compare(this.getMaxThroughput(), other.getMaxThroughput()) != 0) {
                return false;
            }
            return Double.compare(this.getAvgThroughput(), other.getAvgThroughput()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Report;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $minTps = Double.doubleToLongBits(this.getMinTps());
            result = result * 59 + (int)($minTps >>> 32 ^ $minTps);
            long $maxTps = Double.doubleToLongBits(this.getMaxTps());
            result = result * 59 + (int)($maxTps >>> 32 ^ $maxTps);
            long $avgTps = Double.doubleToLongBits(this.getAvgTps());
            result = result * 59 + (int)($avgTps >>> 32 ^ $avgTps);
            long $minThroughput = Double.doubleToLongBits(this.getMinThroughput());
            result = result * 59 + (int)($minThroughput >>> 32 ^ $minThroughput);
            long $maxThroughput = Double.doubleToLongBits(this.getMaxThroughput());
            result = result * 59 + (int)($maxThroughput >>> 32 ^ $maxThroughput);
            long $avgThroughput = Double.doubleToLongBits(this.getAvgThroughput());
            result = result * 59 + (int)($avgThroughput >>> 32 ^ $avgThroughput);
            return result;
        }

        public String toString() {
            return "ObloaderDebuger.Report(minTps=" + this.getMinTps() + ", maxTps=" + this.getMaxTps() + ", avgTps=" + this.getAvgTps() + ", minThroughput=" + this.getMinThroughput() + ", maxThroughput=" + this.getMaxThroughput() + ", avgThroughput=" + this.getAvgThroughput() + ")";
        }
    }

    static class PreCheckFailureException
    extends RuntimeException {
        public PreCheckFailureException(String pattern, Throwable t) {
            this(pattern, ExceptionUtils.getRootCauseMessage(t));
        }

        public PreCheckFailureException(String pattern, Object ... args) {
            super(PreCheckFailureException.format(pattern, args));
        }

        static String format(String pattern, Object ... args) {
            return MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    static class Parameter {
        String name;
        int originalValue;
        int recommendValue;
        private static final Map<String, Integer> RECOMMENDED_VALUE = new HashMap<String, Integer>();
        private static final Map<String, String> ADVISOR_INFO;

        public Parameter(String name, int originalValue) {
            this.name = name;
            this.originalValue = originalValue;
        }

        public String getNotice() {
            StringBuilder sb = new StringBuilder(128);
            return sb.append(ADVISOR_INFO.get(this.name)).append(" ").append("alter system set ").append(this.name).append("=").append(Parameter.getRecommendedParamMap().get(this.name)).append(";").toString();
        }

        public String toString() {
            return this.name + "=" + this.originalValue;
        }

        public static List<String> getParameterNames() {
            return Lists.newArrayList(ADVISOR_INFO.keySet());
        }

        public static Map<String, Integer> getRecommendedParamMap() {
            return Collections.unmodifiableMap(RECOMMENDED_VALUE);
        }

        public String getName() {
            return this.name;
        }

        public int getOriginalValue() {
            return this.originalValue;
        }

        public int getRecommendValue() {
            return this.recommendValue;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOriginalValue(int originalValue) {
            this.originalValue = originalValue;
        }

        public void setRecommendValue(int recommendValue) {
            this.recommendValue = recommendValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOriginalValue() != other.getOriginalValue()) {
                return false;
            }
            if (this.getRecommendValue() != other.getRecommendValue()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOriginalValue();
            result = result * 59 + this.getRecommendValue();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        static {
            RECOMMENDED_VALUE.put("minor_freeze_times", 10000);
            RECOMMENDED_VALUE.put("major_freeze_trigger_percentage", 30);
            RECOMMENDED_VALUE.put("freeze_trigger_percentage", 30);
            RECOMMENDED_VALUE.put("minor_compact_trigger", 16);
            RECOMMENDED_VALUE.put("disk_io_thread_count", 32);
            RECOMMENDED_VALUE.put("minor_merge_concurrency", 48);
            RECOMMENDED_VALUE.put("writing_throttling_trigger_percentage", 100);
            ADVISOR_INFO = new HashMap<String, String>();
            ADVISOR_INFO.put("minor_freeze_times", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5c06\u8be5\u503c\u8c03\u5927\uff0c\u5bfc\u6570\u671f\u95f4\u907f\u514d\u96c6\u7fa4\u53d1\u751f\u5408\u5e76\u3002");
            ADVISOR_INFO.put("major_freeze_trigger_percentage", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5c06\u8be5\u53c2\u6570\u8c03\u6574\u4e3a\u79df\u6237\u5185\u5b5830%\u5de6\u53f3\u3002");
            ADVISOR_INFO.put("freeze_trigger_percentage", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5c06\u8be5\u53c2\u6570\u8c03\u6574\u4e3a\u79df\u6237\u5185\u5b5830%\u5de6\u53f3\u3002");
            ADVISOR_INFO.put("minor_compact_trigger", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5c06\u8be5\u503c\u8c03\u5927\uff0c\u5206\u5c42\u8f6c\u50a8\u53ef\u4ee5\u63d0\u5347\u5bfc\u5165\u6027\u80fd\u3002");
            ADVISOR_INFO.put("disk_io_thread_count", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5c06\u78c1\u76d8\u7684IO\u7ebf\u7a0b\u6570\u8bbe\u5230\u6700\u5927\u503c32\u3002");
            ADVISOR_INFO.put("minor_merge_concurrency", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u9002\u5f53\u8c03\u5927\u8f6c\u50a8\u7684\u5e76\u53d1\u6570\uff0c\u8ba9\u79df\u6237\u5185\u5b58\u5c3d\u5feb\u91ca\u653e\u3002");
            ADVISOR_INFO.put("writing_throttling_trigger_percentage", "\u5efa\u8bae\uff1a\u975e\u751f\u4ea7\u73af\u5883\u53ef\u4ee5\u5173\u95ed\u670d\u52a1\u7aef\u9650\u6d41\u3002");
        }
    }

    static class CliArg {
        String[] args;
        String host;
        String port;
        String user;
        String tenant;
        String cluster;
        String schema;
        String password;
        String sysUser;
        String sysPassword;
        String filePath;
        String logPath;
        private Map<String, Integer> originalParameterMap;

        public CliArg(String[] args) {
            this.args = args;
            this.createCliArg();
            ThreadContext.put((String)"task.workspace", (String)this.getInfoLogFile().getParent());
        }

        private CliArg createCliArg() {
            for (int i = 0; i < this.args.length - 1; ++i) {
                String arg = this.args[i];
                if ("-h".equals(arg) || "--host".equals(arg) || arg.startsWith("-h")) {
                    this.setHost(this.args[i + 1]);
                    if (!"-h".equals(arg) && arg.startsWith("-h")) {
                        this.setHost(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"-h/--host is invalid");
                    continue;
                }
                if ("-P".equals(arg) || "--port".equals(arg) || arg.startsWith("-P")) {
                    this.setPort(this.args[i + 1]);
                    if (!"-P".equals(arg) && arg.startsWith("-P")) {
                        this.setPort(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"-P/--port is invalid");
                    continue;
                }
                if ("-u".equals(arg) || "--user".equals(arg) || arg.startsWith("-u")) {
                    this.setUser(this.args[i + 1]);
                    if (!"-u".equals(arg) && arg.startsWith("-u")) {
                        this.setUser(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"-u/--user is invalid");
                    continue;
                }
                if ("-t".equals(arg) || "--tenant".equals(arg) || arg.startsWith("-t")) {
                    this.setTenant(this.args[i + 1]);
                    if (!"-t".equals(arg) && arg.startsWith("-t")) {
                        this.setTenant(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getTenant()), (Object)"-t/--tenant is invalid");
                    continue;
                }
                if ("-c".equals(arg) || "--cluster".equals(arg) || arg.startsWith("-c")) {
                    this.setCluster(this.args[i + 1]);
                    if (!"-c".equals(arg) && arg.startsWith("-c")) {
                        this.setCluster(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getCluster()), (Object)"-c/--cluster is invalid");
                    continue;
                }
                if ("-D".equals(arg) || "--database".equals(arg) || arg.startsWith("-D")) {
                    this.setSchema(this.args[i + 1]);
                    if (!"-D".equals(arg) && arg.startsWith("-D")) {
                        this.setSchema(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getSchema()), (Object)"-D/--database is invalid");
                    continue;
                }
                if ("-p".equals(arg) || "--password".equals(arg) || arg.startsWith("-p")) {
                    this.setPassword(this.args[i + 1]);
                    if (!"-p".equals(arg) && arg.startsWith("-p")) {
                        this.setPassword(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"-p/--password is invalid");
                    continue;
                }
                if ("--sys-user".equals(arg)) {
                    this.setSysUser(this.args[i + 1]);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"--sys-user is invalid");
                    continue;
                }
                if ("--sys-password".equals(arg)) {
                    this.setSysPassword(this.args[i + 1]);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"--sys-password is invalid");
                    continue;
                }
                if ("-f".equals(arg) || "--file-path".equals(arg) || arg.startsWith("-f")) {
                    this.setFilePath(this.args[i + 1]);
                    if (!"-f".equals(arg) && arg.startsWith("-f")) {
                        this.setFilePath(this.args[i].substring(2));
                    }
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.getHost()), (Object)"-f/--file-path is invalid");
                    continue;
                }
                if (!"--log-path".equals(arg)) continue;
                this.setLogPath(this.args[i + 1]);
            }
            if (StringUtils.isBlank((CharSequence)this.getSysUser())) {
                this.setSysUser("root@sys");
            }
            return this;
        }

        public String getUser() {
            String temp = this.user + "@" + this.tenant;
            if (StringUtils.isNotBlank((CharSequence)this.cluster)) {
                temp = temp + "#" + this.cluster;
            }
            return temp;
        }

        public String getUrl(boolean isSysTenant) {
            return MessageFormat.format(ObloaderDebuger.URL_PATTERN, this.host, this.port, isSysTenant ? "oceanbase" : this.schema);
        }

        public File getInfoLogFile() {
            return new File(FileUtils.toPath(this.getLogPath(), ObloaderDebuger.INFO_LOG_FILE_NAME));
        }

        public File getWarnLogFile() {
            return new File(FileUtils.toPath(this.getLogPath(), ObloaderDebuger.WARN_LOG_FILE_NAME));
        }

        public File getTraceLogFile() {
            return new File(FileUtils.toPath(this.getLogPath(), ObloaderDebuger.TRACE_LOG_FILE_NAME));
        }

        public String getLogPath() {
            if (StringUtils.isNotBlank((CharSequence)this.logPath)) {
                return this.logPath;
            }
            File f = new File(this.filePath);
            if (f.exists() && f.isFile()) {
                return FileUtils.toPath(f.getParent(), "logs");
            }
            return FileUtils.toPath(this.filePath, "logs");
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getPassword() {
            return this.password;
        }

        public String getSysUser() {
            return this.sysUser;
        }

        public String getSysPassword() {
            return this.sysPassword;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Map<String, Integer> getOriginalParameterMap() {
            return this.originalParameterMap;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setTenant(String tenant) {
            this.tenant = tenant;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setSysUser(String sysUser) {
            this.sysUser = sysUser;
        }

        public void setSysPassword(String sysPassword) {
            this.sysPassword = sysPassword;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setLogPath(String logPath) {
            this.logPath = logPath;
        }

        public void setOriginalParameterMap(Map<String, Integer> originalParameterMap) {
            this.originalParameterMap = originalParameterMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CliArg)) {
                return false;
            }
            CliArg other = (CliArg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$port = this.getPort();
            String other$port = other.getPort();
            if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$tenant = this.getTenant();
            String other$tenant = other.getTenant();
            if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
                return false;
            }
            String this$cluster = this.getCluster();
            String other$cluster = other.getCluster();
            if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$sysUser = this.getSysUser();
            String other$sysUser = other.getSysUser();
            if (this$sysUser == null ? other$sysUser != null : !this$sysUser.equals(other$sysUser)) {
                return false;
            }
            String this$sysPassword = this.getSysPassword();
            String other$sysPassword = other.getSysPassword();
            if (this$sysPassword == null ? other$sysPassword != null : !this$sysPassword.equals(other$sysPassword)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$logPath = this.getLogPath();
            String other$logPath = other.getLogPath();
            if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
                return false;
            }
            Map<String, Integer> this$originalParameterMap = this.getOriginalParameterMap();
            Map<String, Integer> other$originalParameterMap = other.getOriginalParameterMap();
            return !(this$originalParameterMap == null ? other$originalParameterMap != null : !((Object)this$originalParameterMap).equals(other$originalParameterMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CliArg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : $port.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $tenant = this.getTenant();
            result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
            String $cluster = this.getCluster();
            result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $sysUser = this.getSysUser();
            result = result * 59 + ($sysUser == null ? 43 : $sysUser.hashCode());
            String $sysPassword = this.getSysPassword();
            result = result * 59 + ($sysPassword == null ? 43 : $sysPassword.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $logPath = this.getLogPath();
            result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
            Map<String, Integer> $originalParameterMap = this.getOriginalParameterMap();
            result = result * 59 + ($originalParameterMap == null ? 43 : ((Object)$originalParameterMap).hashCode());
            return result;
        }

        public String toString() {
            return "ObloaderDebuger.CliArg(args=" + Arrays.deepToString(this.getArgs()) + ", host=" + this.getHost() + ", port=" + this.getPort() + ", user=" + this.getUser() + ", tenant=" + this.getTenant() + ", cluster=" + this.getCluster() + ", schema=" + this.getSchema() + ", password=" + this.getPassword() + ", sysUser=" + this.getSysUser() + ", sysPassword=" + this.getSysPassword() + ", filePath=" + this.getFilePath() + ", logPath=" + this.getLogPath() + ", originalParameterMap=" + this.getOriginalParameterMap() + ")";
        }
    }
}

