/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.constants;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Locale;

public final class JdbcType {
    public static final String BIT = "BIT";
    public static final String TINYINT = "TINYINT";
    public static final String BOOL = "BOOL";
    public static final String MEDIUMINT = "MEDIUMINT";
    public static final String DEC = "DEC";
    public static final String DATETIME = "DATETIME";
    public static final String YEAR = "YEAR";
    public static final String BINARY = "BINARY";
    public static final String TINYBLOB = "TINYBLOB";
    public static final String TINYTEXT = "TINYTEXT";
    public static final String TEXT = "TEXT";
    public static final String MEDIUMBLOB = "MEDIUMBLOB";
    public static final String MEDIUMTEXT = "MEDIUMTEXT";
    public static final String LONGBLOB = "LONGBLOB";
    public static final String LONGTEXT = "LONGTEXT";
    public static final String ENUM = "ENUM";
    public static final String SET = "SET";
    public static final String JSON = "JSON";
    public static final String NUMBER = "NUMBER";
    public static final String VARCHAR2 = "VARCHAR2";
    public static final String NVARCHAR2 = "NVARCHAR2";
    public static final String RAW = "RAW";
    public static final String LONG = "LONG";
    public static final String LONG_RAW = "LONG RAW";
    public static final String REF = "REF";
    public static final String BFILE = "BFILE";
    public static final String UROWID = "UROWID";
    public static final String XMLTYPE = "XMLType";
    public static final String BINARY_FLOAT = "BINARY_FLOAT";
    public static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String REAL = "REAL";
    public static final String ROWID = "ROWID";
    public static final String FLOAT = "FLOAT";
    public static final String CHAR = "CHAR";
    public static final String NCHAR = "NCHAR";
    public static final String BLOB = "BLOB";
    public static final String CLOB = "CLOB";
    public static final String NCLOB = "NCLOB";
    public static final String DECIMAL = "DECIMAL";
    public static final String VARCHAR = "VARCHAR";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String INT = "INT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String NUMERIC = "NUMERIC";
    public static final String DOUBLE = "DOUBLE";
    public static final String DECFLOAT = "DECFLOAT";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String CHARACTER = "CHARACTER";
    public static final String GRAPHIC = "GRAPHIC";
    public static final String VARGRAPHIC = "VARGRAPHIC";
    public static final String LONG_VARGRAPHIC = "LONG VARGRAPHIC";
    public static final String LONG_VARCHAR = "LONG VARCHAR";
    public static final String VARG = "VARG";
    public static final String VARBINARY = "VARBINARY";
    public static final String LONG_VARBINARY = "LONGVARBINARY";
    public static final String VARBIN = "VARBIN";
    public static final String LONGVAR = "LONGVAR";
    public static final String TIMESTZ = "TIMESTZ";
    public static final String DBCLOB = "DBCLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIMESTMP = "TIMESTMP";
    public static final String XML = "XML";
    public static final String DATALINK = "DATALINK";
    public static final String GEOMETRY = "GEOMETRY";
    public static final String POINT = "POINT";
    public static final String LINESTRING = "LINESTRING";
    public static final String POLYGON = "POLYGON";
    public static final String MULTIPOINT = "MULTIPOINT";
    public static final String MULTILINESTRING = "MULTILINESTRING";
    public static final String MULTIPOLYGON = "MULTIPOLYGON";
    public static final String GEOMETRYCOLLECTION = "GEOMETRYCOLLECTION";
    public static final String IMAGE = "IMAGE";
    public static final String UNICHAR = "UNICHAR";
    public static final String UNIVARCHAR = "UNIVARCHAR";
    public static final String UNITEXT = "UNITEXT";
    public static final String SMALLDATETIME = "SMALLDATETIME";
    public static final String BIGDATETIME = "BIGDATETIME";
    public static final String BIGTIME = "BIGTIME";
    public static final String SMALLMONEY = "SMALLMONEY";
    public static final String MONEY = "MONEY";
    public static final String UNSIGNED_BIGINT = "UNSIGNED BIGINT";
    public static final String UNSIGNED_INT = "UNSIGNED INT";
    public static final String UNSIGNED_SMALLINT = "UNSIGNED SMALLINT";
    public static final String NUMERIC_IDENTITY = "NUMERIC IDENTITY";

    private JdbcType() {
    }

    public static boolean isGeometryType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "sdo_geometry": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMysqlGeometryType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "point": 
            case "linestring": 
            case "polygon": 
            case "multipoint": 
            case "multilinestring": 
            case "multipolygon": 
            case "geometrycollection": 
            case "geomcollection": 
            case "geometry": {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "bit": 
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "integer": 
            case "mediumint": 
            case "bigint": 
            case "double": 
            case "float": 
            case "decimal": 
            case "real": 
            case "binary_float": 
            case "binary_double": 
            case "decfloat": 
            case "numeric": 
            case "number": {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "char": 
            case "nchar": 
            case "varchar": 
            case "nvarchar": 
            case "character": 
            case "varchar2": 
            case "nvarchar2": 
            case "tinytext": 
            case "text": 
            case "mediumtext": 
            case "longtext": 
            case "clob": 
            case "set": 
            case "enum": 
            case "json": {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "date": 
            case "time": 
            case "timestamp": 
            case "timestmp": 
            case "datetime": 
            case "year": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryType(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "bit": 
            case "raw": 
            case "long raw": 
            case "binary": 
            case "varbin": 
            case "roaringbitmap": 
            case "varbinary": 
            case "longvarbinary": 
            case "tinyblob": 
            case "blob": 
            case "mediumblob": 
            case "longblob": 
            case "point": 
            case "linestring": 
            case "polygon": 
            case "multipoint": 
            case "multilinestring": 
            case "multipolygon": 
            case "geometrycollection": 
            case "geomcollection": 
            case "geometry": {
                return true;
            }
        }
        return false;
    }

    public static boolean isNullAndEmptyDistinguished(String dataType) {
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (Object)"Input data type is null");
        switch (dataType) {
            case "char": 
            case "nchar": 
            case "varchar": 
            case "nvarchar": 
            case "character": 
            case "varchar2": 
            case "nvarchar2": 
            case "tinytext": 
            case "text": 
            case "mediumtext": 
            case "longtext": 
            case "clob": 
            case "set": 
            case "bit": 
            case "raw": 
            case "long raw": 
            case "binary": 
            case "varbin": 
            case "varbinary": 
            case "longvarbinary": 
            case "tinyblob": 
            case "blob": 
            case "mediumblob": 
            case "longblob": {
                return true;
            }
        }
        return false;
    }

    public static class SdoGeometry {
        private final Object sdoGtype;
        private final Object sdoSrid;
        private final SdoPointType sdoPointType;
        private final SdoElemInfoArray sdoElemInfo;
        private final SdoOrdinateArray sdoOrdinates;

        public SdoGeometry(Object sdoGtype, Object sdoSrid, SdoPointType sdoPointType, SdoElemInfoArray sdoElemInfo, SdoOrdinateArray sdoOrdinates) {
            this.sdoGtype = sdoGtype;
            this.sdoSrid = sdoSrid;
            this.sdoPointType = sdoPointType;
            this.sdoElemInfo = sdoElemInfo;
            this.sdoOrdinates = sdoOrdinates;
        }

        public static SdoGeometry fromText(String text) {
            if (StringUtils.isBlank(text)) {
                return null;
            }
            String upperText = text.toUpperCase(Locale.getDefault());
            int index = upperText.indexOf("SDO_GEOMETRY");
            if (index > -1) {
                int offset = 0;
                Long sdoGtype = null;
                int index0 = upperText.indexOf(40);
                if (index0 > -1) {
                    offset = upperText.indexOf(44);
                    String sdoGtypeStr = upperText.substring(index0 + 1, offset).trim();
                    sdoGtype = "NULL".equalsIgnoreCase(sdoGtypeStr) ? null : Long.valueOf(Long.parseLong(sdoGtypeStr));
                }
                Long sdoSrid = null;
                int index1 = upperText.indexOf(44, offset);
                if (index1 > -1) {
                    offset = index1 + 1;
                    String sdoSridStr = upperText.substring(offset, upperText.indexOf(44, offset)).trim();
                    sdoSrid = "NULL".equalsIgnoreCase(sdoSridStr) ? null : Long.valueOf(Long.parseLong(sdoSridStr));
                }
                SdoPointType sdoPointType = null;
                int index2 = upperText.indexOf("SDO_POINT_TYPE");
                if (index2 > -1) {
                    sdoPointType = SdoPointType.fromText(upperText.substring(index2, upperText.indexOf(41, index2) + 1));
                }
                SdoElemInfoArray sdoElemInfo = null;
                int index3 = upperText.indexOf("SDO_ELEM_INFO_ARRAY");
                if (index3 > -1) {
                    sdoElemInfo = SdoElemInfoArray.fromText(upperText.substring(index3, upperText.indexOf(41, index3) + 1));
                }
                SdoOrdinateArray sdoOrdinates = null;
                int index4 = upperText.indexOf("SDO_ORDINATE_ARRAY");
                if (index4 > -1) {
                    sdoOrdinates = SdoOrdinateArray.fromText(upperText.substring(index4, upperText.indexOf(41, index4) + 1));
                }
                return new SdoGeometry(sdoGtype, sdoSrid, sdoPointType, sdoElemInfo, sdoOrdinates);
            }
            throw new IllegalArgumentException("Invalid SDO_GEOMETRY text: " + text);
        }

        public Struct createStruct(Connection conn) throws SQLException {
            Struct sdoPointTypeStruct = null;
            if (this.sdoPointType != null) {
                sdoPointTypeStruct = conn.createStruct("SDO_POINT_TYPE", this.sdoPointType.attributes);
            }
            Array sdoElemInfoArray = null;
            if (this.sdoElemInfo != null) {
                sdoElemInfoArray = conn.createArrayOf("Number", this.sdoElemInfo.elements);
            }
            Array sdoOrdinatesArray = null;
            if (this.sdoOrdinates != null) {
                sdoOrdinatesArray = conn.createArrayOf("Number", this.sdoOrdinates.elements);
            }
            return conn.createStruct("SDO_GEOMETRY", new Object[]{this.sdoGtype, this.sdoSrid, sdoPointTypeStruct, sdoElemInfoArray, sdoOrdinatesArray});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("SDO_GEOMETRY(");
            sb.append(this.sdoGtype == null ? "NULL" : this.sdoGtype);
            sb.append(", ").append(this.sdoSrid == null ? "NULL" : this.sdoSrid);
            sb.append(", ").append(this.sdoPointType == null ? "NULL" : this.sdoPointType.toString());
            sb.append(", ").append(this.sdoElemInfo == null ? "NULL" : this.sdoElemInfo.toString());
            sb.append(", ").append(this.sdoOrdinates == null ? "NULL" : this.sdoOrdinates.toString());
            return sb.append(")").toString();
        }
    }

    public static class SdoOrdinateArray {
        private final String typeName;
        private final Object[] elements;

        public SdoOrdinateArray(Object[] elements) {
            this("SDO_ORDINATE_ARRAY", elements);
        }

        public SdoOrdinateArray(String typeName, Object[] elements) {
            this.typeName = typeName;
            this.elements = elements;
        }

        public static SdoOrdinateArray fromText(String text) {
            if (StringUtils.isBlank(text)) {
                return null;
            }
            if (StringUtils.isBlank(text)) {
                return null;
            }
            String upperText = text.toUpperCase(Locale.getDefault());
            int index = upperText.indexOf("SDO_ORDINATE_ARRAY");
            if (index > -1) {
                int left = upperText.indexOf(40, index) + 1;
                int right = upperText.indexOf(41, index);
                Preconditions.checkArgument((right > -1 && left <= right ? 1 : 0) != 0, (String)"Invalid SDO_ORDINATE_ARRAY text: %s", (Object)text);
                String[] attributes = upperText.substring(left, right).split(",");
                Object[] sdoOrdinateArray = new Number[attributes.length];
                for (int i = 0; i < attributes.length; ++i) {
                    sdoOrdinateArray[i] = Long.parseLong(attributes[i].trim());
                }
                return new SdoOrdinateArray(sdoOrdinateArray);
            }
            throw new IllegalArgumentException("Invalid SDO_ORDINATE_ARRAY text: " + text);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("SDO_ORDINATE_ARRAY(");
            for (int i = 0; i < this.elements.length; ++i) {
                sb.append(this.elements[i] == null ? "NULL" : this.elements[i]);
                if (i >= this.elements.length - 1) continue;
                sb.append(", ");
            }
            return sb.append(")").toString();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Object[] getElements() {
            return this.elements;
        }
    }

    public static class SdoElemInfoArray {
        private final String typeName;
        private final Object[] elements;

        public SdoElemInfoArray(Object[] elements) {
            this("SDO_ELEM_INFO_ARRAY", elements);
        }

        public SdoElemInfoArray(String typeName, Object[] elements) {
            this.typeName = typeName;
            this.elements = elements;
        }

        public static SdoElemInfoArray fromText(String text) {
            if (StringUtils.isBlank(text)) {
                return null;
            }
            String upperText = text.toUpperCase(Locale.getDefault());
            int index = upperText.indexOf("SDO_ELEM_INFO_ARRAY");
            if (index > -1) {
                int left = upperText.indexOf(40, index) + 1;
                int right = upperText.indexOf(41, index);
                Preconditions.checkArgument((right > -1 && left <= right ? 1 : 0) != 0, (String)"Invalid SDO_ELEM_INFO_ARRAY text: %s", (Object)text);
                String[] attributes = upperText.substring(left, right).split(",");
                Object[] sdoElemInfoArray = new Number[attributes.length];
                for (int i = 0; i < attributes.length; ++i) {
                    sdoElemInfoArray[i] = Long.parseLong(attributes[i].trim());
                }
                return new SdoElemInfoArray(sdoElemInfoArray);
            }
            throw new IllegalArgumentException("Invalid SDO_ELEM_INFO_ARRAY text: " + text);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("SDO_ELEM_INFO_ARRAY(");
            for (int i = 0; i < this.elements.length; ++i) {
                sb.append(this.elements[i] == null ? "NULL" : this.elements[i]);
                if (i >= this.elements.length - 1) continue;
                sb.append(", ");
            }
            return sb.append(")").toString();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Object[] getElements() {
            return this.elements;
        }
    }

    public static class SdoPointType {
        private final String typeName;
        private final Object[] attributes;

        public SdoPointType(Object[] attributes) {
            this("SDO_POINT_TYPE", attributes);
        }

        public SdoPointType(String typeName, Object[] attributes) {
            this.typeName = typeName;
            this.attributes = attributes;
        }

        public static SdoPointType fromText(String text) {
            if (StringUtils.isBlank(text)) {
                return null;
            }
            String upperText = text.toUpperCase(Locale.getDefault());
            int index = upperText.indexOf("SDO_POINT_TYPE");
            if (index > -1) {
                int left = upperText.indexOf(40, index) + 1;
                int right = upperText.indexOf(41, index);
                Preconditions.checkArgument((right > -1 && left <= right ? 1 : 0) != 0, (String)"Invalid SDO_POINT_TYPE text: %s", (Object)text);
                String[] fields = upperText.substring(left, right).split(",");
                Object[] attributes = new Double[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i].trim();
                    attributes[i] = "NULL".equalsIgnoreCase(field) ? null : Double.valueOf(Double.parseDouble(field));
                }
                return new SdoPointType(attributes);
            }
            throw new IllegalArgumentException("Invalid SDO_POINT_TYPE text: " + text);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("SDO_POINT_TYPE(");
            for (int i = 0; i < this.attributes.length; ++i) {
                sb.append(this.attributes[i] == null ? "NULL" : this.attributes[i]);
                if (i >= this.attributes.length - 1) continue;
                sb.append(", ");
            }
            return sb.append(")").toString();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Object[] getAttributes() {
            return this.attributes;
        }
    }
}

