/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum DataFormat {
    POS("dat"),
    CUT("dat"),
    CSV("csv"),
    SQL("sql"),
    ORC("orc"),
    PAR("parquet", "par"),
    AVRO("avro"),
    DDL("sql"),
    MIX("sql");

    private static final DataFormat[] DATA_FORMATS;
    private final String[] extensions;

    private DataFormat(String ... extensions) {
        this.extensions = extensions;
    }

    public List<String> getFileSuffixes() {
        if (this == DDL) {
            return Collections.singletonList("-schema.sql");
        }
        return Arrays.stream(this.extensions).map(s -> "." + s).collect(Collectors.toList());
    }

    public boolean isBinary() {
        return this == ORC || this == PAR || this == AVRO;
    }

    public boolean isReadable() {
        return this == CUT || this == CSV || this == POS || this == SQL;
    }

    public static String appendSchemaOption() {
        return "[" + Arrays.stream(DATA_FORMATS).filter(f -> f == DDL || f == MIX).map(f -> "--" + f.toString().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(",")) + "]";
    }

    public static String appendRecordOption() {
        return "[" + Arrays.stream(DATA_FORMATS).filter(f -> f != DDL && f != MIX).map(f -> "--" + f.toString().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(",")) + "]";
    }

    public static boolean isAutoColumnMappingSupported(DataFormat dataFormat) {
        return ORC.equals((Object)dataFormat) || PAR.equals((Object)dataFormat) || CSV.equals((Object)dataFormat);
    }

    public static boolean isHiveDirSupported(DataFormat dataFormat) {
        return ORC.equals((Object)dataFormat) || PAR.equals((Object)dataFormat) || CSV.equals((Object)dataFormat);
    }

    public static boolean isFileFlat(DataFormat dataFormat) {
        return CSV == dataFormat || SQL == dataFormat || CUT == dataFormat || POS == dataFormat;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    static {
        DATA_FORMATS = DataFormat.values();
    }
}

