/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import lombok.NonNull;

public class Hint {
    private final String name;
    private Object value;

    public Hint(@NonNull HintTypes hintTypes) {
        this(hintTypes, null);
        if (hintTypes == null) {
            throw new NullPointerException("hintTypes is marked non-null but is null");
        }
    }

    public Hint(@NonNull HintTypes hintTypes, Object value) {
        if (hintTypes == null) {
            throw new NullPointerException("hintTypes is marked non-null but is null");
        }
        this.name = hintTypes.getName();
        this.value = value;
    }

    public String getHintStatement() {
        if (this.getValue() == null) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getName());
        sb.append("(").append(this.getValue()).append(")");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static enum HintTypes {
        FROZEN_VERSION("frozen_version"),
        PARALLEL("PARALLEL"),
        QUERY_TIMEOUT("QUERY_TIMEOUT"),
        READ_CONSISTENCY("READ_CONSISTENCY"),
        OPT_PARAM("opt_param");

        private final String name;

        private HintTypes(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

