/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public enum MergeStatus {
    IDLE(0L, "IDLE"),
    OTHERS(null, null);

    private final Long code;
    private final String status;

    private MergeStatus(Long code, String status) {
        this.code = code;
        this.status = status;
    }

    public static MergeStatus getByCode(@NonNull Long code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return Arrays.stream(MergeStatus.values()).filter(s -> Objects.equals(code, s.code)).findFirst().orElse(OTHERS);
    }

    public static MergeStatus getByStatus(@NonNull String status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return Arrays.stream(MergeStatus.values()).filter(s -> StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)s.status)).findFirst().orElse(OTHERS);
    }
}

