/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import com.oceanbase.tools.loaddump.utils.StringUtils;

public enum StorageType {
    LOCAL_DISK("local", "file", false),
    HADOOP_HDFS("hdfs", null, false),
    AMAZON_S3("s3", "s3a", true),
    ALIYUN_OSS("oss", null, true),
    TENCENT_COS("cos", "cosn", true),
    HUAWEI_OBS("obs", null, true),
    AZURE_WASB("wasb", "wasbs", true);

    private final String name;
    private final String alias;
    private final boolean isObjectStorage;
    private static final StorageType[] STORAGE_TYPES;

    private StorageType(String name, String alias, boolean isObjectStorage) {
        this.name = name;
        this.alias = alias;
        this.isObjectStorage = isObjectStorage;
    }

    public static StorageType of(String storageTypeName) {
        if (StringUtils.isBlank(storageTypeName)) {
            return LOCAL_DISK;
        }
        for (StorageType t : STORAGE_TYPES) {
            if (t.name != null && t.name.equalsIgnoreCase(storageTypeName)) {
                return t;
            }
            if (t.alias == null || !t.alias.equalsIgnoreCase(storageTypeName)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unsupported storage type: " + storageTypeName);
    }

    public String getName() {
        return this.name;
    }

    public boolean isObjectStorage() {
        return this.isObjectStorage;
    }

    static {
        STORAGE_TYPES = StorageType.values();
    }
}

