/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.RowKey;
import com.oceanbase.tools.loaddump.common.model.SchemaMetaCache;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.datatype.factory.LiteralDataTypeFactory;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.dumper.typehandler.BigIntegerTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TypeHandlerFactory;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataProvider
implements MetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetadataProvider.class);
    static final String GET_OPEN_CURSORS_SQL = "show parameters like 'open_cursors'";
    static final String MYSQL_TABLE_META_QUERY_SQL1 = "SELECT T.TABLE_NAME AS TABLE_NAME,C.COLUMN_NAME AS COLUMN_NAME, C.DATA_TYPE AS DATA_TYPE,C.DATETIME_PRECISION AS DATETIME_PRECISION,C.IS_NULLABLE AS NULLABLE,C.COLUMN_DEFAULT AS GENERATION_EXPRESSION,C.ORDINAL_POSITION-1 AS COLUMN_POSITION FROM information_schema.TABLES T, information_schema.COLUMNS C WHERE T.TABLE_SCHEMA=C.TABLE_SCHEMA AND T.TABLE_NAME=C.TABLE_NAME AND T.TABLE_SCHEMA={0} AND T.TABLE_NAME NOT LIKE ''__ctas_%_%'' AND T.TABLE_TYPE=''BASE TABLE'' {1} ORDER BY C.TABLE_NAME,C.ORDINAL_POSITION ASC";
    static final String MYSQL_TABLE_META_QUERY_SQL2 = "SELECT T.TABLE_NAME AS TABLE_NAME,C.COLUMN_NAME AS COLUMN_NAME,C.DATA_TYPE AS DATA_TYPE,C.DATETIME_PRECISION AS DATETIME_PRECISION,C.IS_NULLABLE AS NULLABLE,C.GENERATION_EXPRESSION AS GENERATION_EXPRESSION,C.ORDINAL_POSITION-1 AS COLUMN_POSITION FROM information_schema.TABLES T, information_schema.COLUMNS C WHERE T.TABLE_SCHEMA=C.TABLE_SCHEMA AND T.TABLE_NAME=C.TABLE_NAME AND T.TABLE_SCHEMA={0} AND T.TABLE_NAME NOT LIKE ''__ctas_%_%'' AND T.TABLE_TYPE=''BASE TABLE'' {1} ORDER BY C.TABLE_NAME,C.ORDINAL_POSITION ASC";
    static final String MYSQL_SHARDING_META_QUERY_SQL = "show full columns from {0} from {1}";
    static final String ORACLE_TABLE_META_QUERY_SQL_V4 = "SELECT O.OBJECT_NAME AS TABLE_NAME,C.COLUMN_NAME AS COLUMN_NAME,C.DATA_TYPE AS DATA_TYPE,C.DATA_SCALE AS DATETIME_PRECISION,C.VIRTUAL_COLUMN AS VIRTUAL_COLUMN,C.NULLABLE AS NULLABLE,C.COLUMN_ID-16 AS COLUMN_POSITION FROM ALL_OBJECTS O JOIN ALL_TAB_COLS C ON O.OWNER=C.OWNER AND O.OBJECT_NAME=C.TABLE_NAME WHERE O.OWNER={0} AND O.OBJECT_NAME NOT LIKE ''__ctas_%_%'' AND O.OBJECT_TYPE=''TABLE'' {1}AND (C.HIDDEN_COLUMN IS NULL OR C.HIDDEN_COLUMN!=''YES'') AND C.USER_GENERATED=''YES'' ORDER BY C.TABLE_NAME,C.COLUMN_ID ASC";
    static final String ORACLE_TABLE_META_QUERY_SQL_V3 = "SELECT O.OBJECT_NAME AS TABLE_NAME,C.COLUMN_NAME AS COLUMN_NAME,C.DATA_TYPE AS DATA_TYPE,C.DATA_SCALE AS DATETIME_PRECISION,C.VIRTUAL_COLUMN AS VIRTUAL_COLUMN,C.NULLABLE AS NULLABLE,C.COLUMN_ID-16 AS COLUMN_POSITION FROM ALL_OBJECTS O JOIN ALL_TAB_COLS C ON O.OWNER=C.OWNER AND O.OBJECT_NAME=C.TABLE_NAME WHERE O.OWNER={0} AND O.OBJECT_NAME NOT LIKE ''__ctas_%_%'' AND O.OBJECT_TYPE=''TABLE'' {1}AND (C.HIDDEN_COLUMN IS NULL OR C.HIDDEN_COLUMN!=''YES'') ORDER BY C.TABLE_NAME,C.COLUMN_ID ASC";
    static final String MYSQL_TABLE_NANE_QUERY_SQL = "SELECT TABLE_NAME FROM information_schema.TABLES where TABLE_SCHEMA={0} AND TABLE_NAME NOT LIKE ''__ctas_%_%'' AND TABLE_TYPE=''BASE TABLE'' {1}";
    static final String ORACLE_TABLE_NAME_QUERY_SQL_WITHOUT_TEMPORARY = "SELECT OBJECT_NAME AS TABLE_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_NAME NOT LIKE ''__ctas_%_%'' AND OBJECT_TYPE=''TABLE'' AND TEMPORARY=''N'' {1}";
    static final String ORACLE_TABLE_NAME_QUERY_SQL = "SELECT OBJECT_NAME AS TABLE_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_NAME NOT LIKE ''__ctas_%_%'' AND OBJECT_TYPE=''TABLE'' {1}";
    static final String QUERY_TABLE_GROUP_PATTERN_V1 = "select tablegroup_name as object_name from oceanbase.__all_tenant at,oceanbase.__all_tablegroup tg where tg.tablegroup_name not in (''oceanbase'') and at.tenant_id=tg.tenant_id and at.tenant_name={0} {1}";
    static final String QUERY_TABLE_GROUP_PATTERN_V2 = "select tablegroup_name as object_name from oceanbase.__all_tenant at,oceanbase.__all_virtual_tablegroup tg where tg.tablegroup_name not in (''oceanbase'') and at.tenant_id=tg.tenant_id and at.tenant_name={0} {1}";
    static final String QUERY_TABLE_GROUP_PATTERN_NO_SYS_MYSQL = "select tablegroup_name AS OBJECT_NAME from oceanbase.__all_tablegroup tg where tg.tablegroup_name not in (''oceanbase'') {0}";
    static final String QUERY_TABLE_GROUP_PATTERN_NO_SYS_ORACLE = "SELECT TABLEGROUP_NAME AS OBJECT_NAME FROM SYS.ALL_VIRTUAL_TABLEGROUP_REAL_AGENT TG WHERE TG.TABLEGROUP_NAME NOT IN (''oceanbase'') {0}";
    static final String QUERY_VIEW_PATTERN_ORACLE = "SELECT VIEW_NAME AS OBJECT_NAME FROM ALL_VIEWS WHERE OWNER={0} {1}";
    static final String QUERY_VIEW_PATTERN_MYSQL = "SELECT TABLE_NAME AS OBJECT_NAME FROM information_schema.VIEWS WHERE TABLE_SCHEMA={0} {1}";
    static final String QUERY_TRIGGER_PATTERN = "SELECT TRIGGER_NAME AS OBJECT_NAME FROM ALL_TRIGGERS WHERE OWNER={0} {1}";
    static final String QUERY_SYNONYM_PATTERN = "SELECT SYNONYM_NAME AS OBJECT_NAME FROM ALL_SYNONYMS WHERE (OWNER={0} OR ((OWNER=''__public'' OR OWNER=''PUBLIC'') AND TABLE_OWNER={1})) {2}";
    static final String QUERY_PUB_SYNONYM_PATTERN = "SELECT SYNONYM_NAME AS OBJECT_NAME FROM ALL_SYNONYMS WHERE (OWNER=''__public'' OR OWNER=''PUBLIC'') AND TABLE_OWNER={0} {1}";
    static final String QUERY_SEQUENCE_PATTERN_ORACLE = "SELECT SEQUENCE_NAME AS OBJECT_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER={0} {1}";
    static final String QUERY_SEQUENCE_PATTERN_MYSQL = "select sequence_name as object_name from oceanbase.__all_sequence_object s,oceanbase.__all_database d where s.database_id=d.database_id and d.database_name={0} {1}";
    static final String QUERY_FUNCTION_PATTERN_ORACLE = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''FUNCTION'' {1}";
    static final String QUERY_FUNCTION_PATTERN_MYSQL = "SELECT ROUTINE_NAME AS OBJECT_NAME FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA={0} AND ROUTINE_TYPE=''FUNCTION'' {1}";
    static final String QUERY_PROCEDURE_PATTERN_ORACLE = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''PROCEDURE'' {1}";
    static final String QUERY_PROCEDURE_PATTERN_MYSQL = "SELECT ROUTINE_NAME AS OBJECT_NAME FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA={0} AND ROUTINE_TYPE=''PROCEDURE'' {1}";
    static final String QUERY_TYPE_PATTERN = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''TYPE'' {1}";
    static final String QUERY_TYPE_BODY_PATTERN = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''TYPE BODY'' {1}";
    static final String QUERY_PACKAGE_PATTERN = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''PACKAGE'' {1}";
    static final String QUERY_PACKAGE_BODY_PATTERN = "SELECT OBJECT_NAME FROM ALL_OBJECTS WHERE OWNER={0} AND OBJECT_TYPE=''PACKAGE BODY'' {1}";
    static final String EXCLUDED_ROLES = "''CONNECT'', ''RESOURCE'', ''DBA'', ''PUBLIC'', ''STANDBY_REPLICATION''";
    static final String EXCLUDED_ORACLE_USERS = "''SYS'', ''proxyro'', ''standbyro'', ''PUBLIC'', ''ORAAUDITOR'', ''LBACSYS'', ''__OCEANBASE_INNER_DRC_USER''";
    static final String EXCLUDED_MYSQL_USERS = "''root'', ''proxyro'', ''standbyro'', ''__oceanbase_inner_drc_user'', ''ORAAUDITOR''";
    static final String QUERY_ROLE_PATTERN = "SELECT ROLE AS OBJECT_NAME FROM DBA_ROLES WHERE ROLE NOT IN (''CONNECT'', ''RESOURCE'', ''DBA'', ''PUBLIC'', ''STANDBY_REPLICATION'') {0};";
    static final String QUERY_OBJ_USER_PATTERN_ORACLE = "SELECT USERNAME AS OBJECT_NAME FROM DBA_USERS WHERE USERNAME NOT IN (''SYS'', ''proxyro'', ''standbyro'', ''PUBLIC'', ''ORAAUDITOR'', ''LBACSYS'', ''__OCEANBASE_INNER_DRC_USER'') {0};";
    static final String QUERY_OBJ_USER_PATTERN_MYSQL = "SELECT * FROM ( SELECT CASE WHEN host = ''%'' THEN user ELSE CONCAT(user, ''@'', host) END AS OBJECT_NAME FROM mysql.user) WHERE OBJECT_NAME NOT IN (''root'', ''proxyro'', ''standbyro'', ''__oceanbase_inner_drc_user'', ''ORAAUDITOR'') {0};";
    static final String GET_MACRO_RANGE_SQL = "SELECT partition_id,macro_range FROM __all_virtual_partition_sstable_macro_info where ";
    static final String GET_SERVER_PORT_SQL = "SELECT svr_ip, svr_port, inner_port FROM __all_server where ";
    static final String GET_UNIQUEKEY_OBMYSQL = "SELECT K.COLUMN_NAME AS COLUMN_NAME, K.ORDINAL_POSITION-1 AS POSITION, C.CONSTRAINT_NAME AS CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS C, information_schema.KEY_COLUMN_USAGE AS K, information_schema.STATISTICS AS S WHERE C.TABLE_SCHEMA=K.TABLE_SCHEMA AND C.TABLE_NAME=K.TABLE_NAME AND C.TABLE_SCHEMA=S.TABLE_SCHEMA AND C.TABLE_NAME=S.TABLE_NAME AND  C.CONSTRAINT_SCHEMA=K.CONSTRAINT_SCHEMA AND C.CONSTRAINT_NAME=K.CONSTRAINT_NAME AND C.CONSTRAINT_NAME=S.INDEX_NAME AND K.COLUMN_NAME=S.COLUMN_NAME AND C.TABLE_SCHEMA=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='UNIQUE' ORDER BY K.ORDINAL_POSITION ASC";
    static final String GET_NOT_NULL_UNIQUEKEY_OBMYSQL = "SELECT L.COLUMN_NAME AS COLUMN_NAME, S.SEQ_IN_INDEX-1 AS POSITION, C.CONSTRAINT_NAME AS CONSTRAINT_NAME FROM information_schema.TABLE_CONSTRAINTS C, information_schema.STATISTICS AS S, information_schema.COLUMNS L WHERE C.TABLE_SCHEMA=L.TABLE_SCHEMA AND C.TABLE_NAME=L.TABLE_NAME AND  C.TABLE_SCHEMA=S.TABLE_SCHEMA AND C.TABLE_NAME=S.TABLE_NAME AND C.CONSTRAINT_NAME=S.INDEX_NAME AND L.COLUMN_NAME=S.COLUMN_NAME AND  C.TABLE_SCHEMA=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='UNIQUE' AND L.IS_NULLABLE='NO' ORDER BY S.SEQ_IN_INDEX ASC";
    static final String GET_UNIQUEKEY_OBORACLE = "SELECT T.QUALIFIED_COL_NAME AS COLUMN_NAME, O.POSITION-1 AS POSITION, C.CONSTRAINT_NAME AS CONSTRAINT_NAME FROM ALL_CONSTRAINTS C LEFT JOIN ALL_CONS_COLUMNS O ON C.OWNER=O.OWNER AND C.TABLE_NAME=O.TABLE_NAME AND C.CONSTRAINT_NAME=O.CONSTRAINT_NAME  LEFT JOIN ALL_INDEXES I ON C.OWNER=I.OWNER AND C.TABLE_NAME=I.TABLE_NAME AND C.INDEX_NAME=I.INDEX_NAME INNER JOIN ALL_TAB_COLS T  ON O.OWNER=T.OWNER AND O.TABLE_NAME=T.TABLE_NAME AND O.COLUMN_NAME=T.COLUMN_NAME AND T.HIDDEN_COLUMN='NO'  WHERE C.OWNER=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='U' ORDER BY O.CONSTRAINT_NAME ASC, O.POSITION ASC";
    static final String GET_NOT_NULL_UNIQUEKEY_OBORACLE = "SELECT T.QUALIFIED_COL_NAME AS COLUMN_NAME, O.POSITION-1 AS POSITION, C.CONSTRAINT_NAME AS CONSTRAINT_NAME FROM ALL_CONSTRAINTS C LEFT JOIN ALL_CONS_COLUMNS O ON C.OWNER=O.OWNER AND C.TABLE_NAME=O.TABLE_NAME AND C.CONSTRAINT_NAME=O.CONSTRAINT_NAME  LEFT JOIN ALL_INDEXES I ON C.OWNER=I.OWNER AND C.TABLE_NAME=I.TABLE_NAME AND C.INDEX_NAME=I.INDEX_NAME  INNER JOIN ALL_TAB_COLS T ON O.OWNER=T.OWNER AND O.TABLE_NAME=T.TABLE_NAME AND O.COLUMN_NAME=T.COLUMN_NAME AND T.HIDDEN_COLUMN='NO'  WHERE C.OWNER=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='U' AND T.NULLABLE='N' ORDER BY O.CONSTRAINT_NAME ASC, O.POSITION ASC";
    static final String GET_ROWKEY_SQL21 = "SELECT column_name,data_type,rowkey_position-1 from __all_tenant t,__all_column c where t.tenant_id=c.tenant_id and t.tenant_name=? and table_id=? and rowkey_position>0 order by rowkey_position asc";
    static final String GET_ROWKEY_SQL22 = "SELECT column_name,data_type,rowkey_position-1 from __all_tenant t,__all_virtual_column c where t.tenant_id=c.tenant_id and t.tenant_name=? and table_id=? and rowkey_position>0 order by rowkey_position asc";
    protected SessionManager sessionManager;
    protected SchemaMetaCache metaCache;

    public AbstractMetadataProvider(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public int queryOpenCursors() throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            int n = JdbcExecutor.query(conn, GET_OPEN_CURSORS_SQL, rs -> rs.next() ? rs.getInt("VALUE") : 0);
            return n;
        }
    }

    @Override
    public List<TableInfo> queryTables(ConnectionKey connectionKey, AdvancedOption option) throws Exception {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(option.getAllowedObjectMap()), (Object)"White list is empty. Please check the --table and other options!");
        ServerMode serverMode = connectionKey.getServerMode();
        String sqlPatten = serverMode.isOracleMode() ? ORACLE_TABLE_NAME_QUERY_SQL_WITHOUT_TEMPORARY : MYSQL_TABLE_NANE_QUERY_SQL;
        String columnName = serverMode.isOracleMode() ? "OBJECT_NAME" : "TABLE_NAME";
        Set<String> includeTables = option.getAllowedObjectMap().remove((Object)ObjectType.TABLE);
        Set<String> excludeTables = option.getDisallowedObjectMap().remove((Object)ObjectType.TABLE);
        StringBuilder sb = new StringBuilder(128);
        if (CollectionUtils.isNotEmpty(includeTables)) {
            sb.append("AND ").append(SqlUtils.buildIncludeCondition(includeTables, serverMode, columnName));
        }
        if (CollectionUtils.isNotEmpty(excludeTables)) {
            sb.append(" AND ").append(SqlUtils.buildExcludeCondition(excludeTables, serverMode, columnName));
        }
        String sql = MessageFormat.format(sqlPatten, "'" + connectionKey.getDatabase() + "'", sb);
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        try (Connection conn = this.sessionManager.getPooledBizConnection();
             PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(sql));
             ResultSet rs = pstmt.executeQuery();){
            while (rs.next()) {
                tables.add(new TableInfo(serverMode, connectionKey.getDatabase(), rs.getString(1)));
            }
        }
        return tables;
    }

    @Override
    public Database queryDatabase(ConnectionKey connectionKey, AdvancedOption option) throws Exception {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(option.getAllowedObjectMap()), (Object)"White list is empty. Please check the --table and other options!");
        ServerMode serverMode = connectionKey.getServerMode();
        String databaseName = connectionKey.getDatabase();
        Database database = new Database();
        database.setServerMode(serverMode);
        database.setSubsequentV4(!serverMode.isPreviousV4());
        database.setSchemaName(databaseName);
        database.setLogicalDatabase(option.isLogicalDatabase());
        if (option.isCustomQuery()) {
            Iterator<String> iter = option.getAllowedObjectMap().get((Object)ObjectType.TABLE).iterator();
            String tableName = iter.hasNext() ? iter.next() : "CUSTOM_SQL";
            database.getTableInfoMap().put(tableName, new TableInfo(serverMode, databaseName, tableName));
            return database;
        }
        if (option.isDumpOperation()) {
            this.querySchemaObjects(database, connectionKey, option);
        }
        boolean isIncludeTable = option.getAllowedObjectMap().containsKey((Object)ObjectType.TABLE);
        if (!option.isOnlyDdl() && isIncludeTable) {
            log.info("Querying table column metadata, this might take a while...");
            if (option.isLogicalDatabase()) {
                this.queryTableInfoShardingMode(database, option);
            } else {
                this.queryTableInfoPhysicalMode(database, option);
            }
        }
        if (isIncludeTable) {
            this.metaCache = SchemaMetaCache.loadFromDatabase(connectionKey, option);
        }
        return database;
    }

    void querySchemaObjects(Database database, ConnectionKey key, AdvancedOption option) throws Exception {
        if (option.containObjectType(ObjectType.TABLE) && option.isOnlyDdl()) {
            log.info("Querying `TABLE` definitions...");
            this.queryTableNameMap(database, option);
        }
        if (!option.isIncludeDdl()) {
            return;
        }
        if (option.containObjectType(ObjectType.VIEW)) {
            log.info("Querying `VIEW` definitions...");
            this.queryViewInfoMap(database, option);
        }
        if (option.containObjectType(ObjectType.SEQUENCE)) {
            log.info("Querying `SEQUENCE` definitions...");
            this.querySequenceInfoMap(database, option);
        }
        if (option.containObjectType(ObjectType.TABLE_GROUP)) {
            boolean isNoSysPwd = key.hasNoSysPrivileges();
            boolean priorTo227 = key.getServerMode().isPreviousV2270();
            log.info("Querying `TABLE_GROUP` definitions...");
            if (!priorTo227 || !isNoSysPwd) {
                this.queryTableGroupInfoMap(database, key, option, isNoSysPwd);
            } else {
                log.warn("Dump TABLE_GROUP failed as privileges is not enough prior to OceanBase v2.2.70. (Required sys privileges)");
            }
        }
        if (option.containObjectType(ObjectType.FUNCTION) && !key.getServerMode().isPrevious("2.2.3.0")) {
            log.info("Querying `FUNCTION` definitions...");
            this.queryFunctionInfoMap(database, option);
        }
        if (option.containObjectType(ObjectType.PROCEDURE) && !key.getServerMode().isPrevious("2.2.3.0")) {
            log.info("Querying `PROCEDURE` definitions...");
            this.queryProcedureInfoMap(database, option);
        }
        if (option.containObjectType(ObjectType.OBJ_USER)) {
            log.info("Querying `USER` definitions...");
            this.queryObjUserInfoMap(database, option);
        }
        if (option.containObjectType(ObjectType.ROLE)) {
            log.info("Querying `ROLE` definitions...");
            this.queryRoleInfoMap(database, option);
        }
        if (key.getServerMode().isOracleMode()) {
            this.queryOracleObjects(database, option);
        }
    }

    private void queryOracleObjects(Database database, AdvancedOption option) throws Exception {
        if (option.containObjectType(ObjectType.TRIGGER)) {
            log.info("Querying `TRIGGER` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.TRIGGER, QUERY_TRIGGER_PATTERN, database.getSchemaName(), "TRIGGER_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TRIGGER))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.TRIGGER.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.TYPE)) {
            log.info("Querying `TYPE` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.TYPE, QUERY_TYPE_PATTERN, database.getSchemaName(), "OBJECT_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TYPE))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.TYPE.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.TYPE_BODY)) {
            log.info("Querying `TYPE_BODY` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.TYPE_BODY, QUERY_TYPE_BODY_PATTERN, database.getSchemaName(), "OBJECT_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TYPE_BODY))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.TYPE_BODY.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.PACKAGE)) {
            log.info("Querying `PACKAGE` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.PACKAGE, QUERY_PACKAGE_PATTERN, database.getSchemaName(), "OBJECT_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.PACKAGE))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.PACKAGE.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.PACKAGE_BODY)) {
            log.info("Querying `PACKAGE_BODY` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.PACKAGE_BODY, QUERY_PACKAGE_BODY_PATTERN, database.getSchemaName(), "OBJECT_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.PACKAGE_BODY))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.PACKAGE_BODY.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.SYNONYM)) {
            log.info("Querying `SYNONYM` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.SYNONYM, QUERY_SYNONYM_PATTERN, database.getSchemaName(), "SYNONYM_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.SYNONYM))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.SYNONYM.getName(), (Object)database.getSchemaName());
            }
        }
        if (option.containObjectType(ObjectType.PUBLIC_SYNONYM)) {
            log.info("Querying `PUBLIC_SYNONYM` definitions...");
            this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(true, ObjectType.PUBLIC_SYNONYM, QUERY_PUB_SYNONYM_PATTERN, database.getSchemaName(), "SYNONYM_NAME"));
            if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.PUBLIC_SYNONYM))) {
                log.warn("No {} were found in \"{}\"", (Object)ObjectType.PUBLIC_SYNONYM.getName(), (Object)database.getSchemaName());
            }
        }
    }

    private void queryTableInfoShardingMode(Database database, AdvancedOption option) throws Exception {
        String schemaName = database.getSchemaName();
        ServerMode serverMode = database.getServerMode();
        Set<String> specifiedTables = option.getAllowedObjectMap().remove((Object)ObjectType.TABLE);
        HashMap<String, LinkedHashMap<String, ColumnInfo>> tableColumnMap = new HashMap<String, LinkedHashMap<String, ColumnInfo>>();
        for (String tableName : specifiedTables) {
            String sql = MessageFormat.format(MYSQL_SHARDING_META_QUERY_SQL, "`" + tableName + "`", "`" + schemaName + "`");
            LinkedHashMap columnInfoMap = tableColumnMap.computeIfAbsent(tableName, v -> new LinkedHashMap());
            Connection conn = this.sessionManager.getPooledBizConnection();
            Throwable throwable = null;
            try {
                PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(sql));
                Throwable throwable2 = null;
                try {
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        Preconditions.checkState((boolean)rs.first(), (String)"The table: %s is not exists.", (Object)tableName);
                        rs.beforeFirst();
                        int position = 0;
                        while (rs.next()) {
                            String columnName = rs.getString("Field");
                            ColumnInfo columnInfo = columnInfoMap.computeIfAbsent(columnName, v -> new ColumnInfo());
                            columnInfo.setColumnName(columnName);
                            columnInfo.setDataType(new LiteralDataTypeFactory(rs.getString("Type")).generate());
                            columnInfo.setColumnPosition(position++);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable3 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable2 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                conn.close();
            }
        }
        database.setTableInfoMap(this.buildTableInfoMap(serverMode, schemaName, option, tableColumnMap));
    }

    private void queryTableInfoPhysicalMode(Database database, AdvancedOption option) throws Exception {
        ServerMode serverMode = database.getServerMode();
        boolean isOracle = serverMode.isOracleMode();
        boolean priorTo2273 = serverMode.isPrevious("2.2.73");
        boolean isTempTableExcluded = isOracle && (!option.isDumpOperation() || !option.isIncludeDdl());
        boolean isIncludeAllColumns = !isOracle && priorTo2273;
        HashMap<String, LinkedHashMap<String, ColumnInfo>> tableColumnMap = new HashMap<String, LinkedHashMap<String, ColumnInfo>>();
        Set<String> allowedTables = option.getAllowedObjectMap().remove((Object)ObjectType.TABLE);
        Set<String> disallowedTables = option.getDisallowedObjectMap().remove((Object)ObjectType.TABLE);
        List<String> batchSqls = this.buildQueryTableMetadataSqls(database, allowedTables, disallowedTables, isTempTableExcluded);
        for (String sql : batchSqls) {
            Connection conn = this.sessionManager.getPooledBizConnection();
            Throwable throwable = null;
            try {
                PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(sql));
                Throwable throwable2 = null;
                try {
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        while (rs.next()) {
                            String table = rs.getString("TABLE_NAME");
                            ColumnInfo columnInfo = this.extractColumnInfo(rs, option, isOracle, isIncludeAllColumns);
                            if (!tableColumnMap.containsKey(table)) {
                                log.debug("Query column metadata for the table: \"{}\" finished", (Object)table);
                            }
                            if (columnInfo == null) continue;
                            tableColumnMap.computeIfAbsent(table, v -> new LinkedHashMap()).put(columnInfo.getColumnName(), columnInfo);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable3 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable2 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                conn.close();
            }
        }
        option.getAllowedObjectMap().put(ObjectType.TABLE, tableColumnMap.keySet());
        if (CollectionUtils.isNotEmpty(allowedTables)) {
            ArrayList<String> specifiedTables = new ArrayList<String>(allowedTables);
            specifiedTables.removeAll((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TABLE));
            if (CollectionUtils.isNotEmpty(specifiedTables)) {
                Iterator iter = specifiedTables.iterator();
                while (iter.hasNext()) {
                    String tableName = (String)iter.next();
                    if (!tableName.contains("*")) {
                        log.warn("Table: \"{}\" doesn't exist, skip it", (Object)tableName);
                    }
                    iter.remove();
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TABLE))) {
            log.warn("No table to proceed for schema: \"{}\"", (Object)database.getSchemaName());
            database.setTableInfoMap(Maps.newHashMap());
            return;
        }
        database.setTableInfoMap(this.buildTableInfoMap(serverMode, database.getSchemaName(), option, tableColumnMap));
    }

    @Override
    public void markEmptyTables(boolean isOracleMode, Map<String, TableInfo> tableInfoMap) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("Filtering out empty tables...");
        ExecutorTemplate<Integer> template = new ExecutorTemplate<Integer>("find-empty-tables-", this.sessionManager.getConnectionKey().getConcurrency());
        for (TableInfo tableInfo : tableInfoMap.values()) {
            template.submit(() -> {
                String sql = "select 1 from " + tableInfo.getSchemaTable() + (isOracleMode ? " where rownum=1" : " limit 1");
                try (Connection conn = this.sessionManager.getPooledBizConnection();){
                    tableInfo.setEmptyTable(JdbcExecutor.query(conn, sql, rs -> !rs.next()));
                    Integer n = tableInfo.isEmptyTable() ? 1 : 0;
                    return n;
                }
            });
        }
        int emptyTables = template.waitForResult().stream().mapToInt(e -> e).sum();
        if (emptyTables > 0) {
            log.info("Found {} empty tables before executing. Elapsed: {}", (Object)emptyTables, (Object)stopwatch);
        }
    }

    private void queryObjectInfoMap(ServerMode serverMode, AdvancedOption option, ObjectTypeQueryInfo queryInfo) throws Exception {
        boolean isTableGroupNoSysSql = ObjectType.TABLE_GROUP.equals((Object)queryInfo.objectType) && StringUtils.isEmpty(queryInfo.placeHolderValue);
        String quotedName = isTableGroupNoSysSql ? "" : "'" + queryInfo.placeHolderValue + "'";
        ArrayList<String> specifiedObjectNames = new ArrayList<String>((Collection)option.getAllowedObjectMap().remove((Object)queryInfo.objectType));
        ArrayList<String> batchSqls = new ArrayList<String>();
        if (CollectionUtils.isEmpty(specifiedObjectNames)) {
            if (isTableGroupNoSysSql || ObjectType.OBJ_USER.equals((Object)queryInfo.objectType) || ObjectType.ROLE.equals((Object)queryInfo.objectType)) {
                batchSqls.add(MessageFormat.format(queryInfo.pattern, ""));
            } else if (ObjectType.SYNONYM.equals((Object)queryInfo.objectType)) {
                batchSqls.add(MessageFormat.format(queryInfo.pattern, quotedName, quotedName, ""));
            } else if (ObjectType.TABLE.equals((Object)queryInfo.objectType)) {
                Set<String> excludeObjectNames = option.getDisallowedObjectMap().get((Object)ObjectType.TABLE);
                String cond = " ";
                if (CollectionUtils.isNotEmpty(excludeObjectNames)) {
                    cond = "AND " + SqlUtils.buildExcludeCondition(excludeObjectNames, serverMode, queryInfo.columnName);
                }
                batchSqls.add(MessageFormat.format(queryInfo.pattern, quotedName, cond));
            } else {
                batchSqls.add(MessageFormat.format(queryInfo.pattern, quotedName, ""));
            }
        } else {
            List<Set<String>> objectNameSets = DBUtils.splitObjectNames(specifiedObjectNames);
            boolean isRegexSql = true;
            for (Set<String> objectNames : objectNameSets) {
                for (List batch : Lists.partition((List)Lists.newArrayList(objectNames), (int)128)) {
                    String str = isRegexSql ? String.join((CharSequence)"|", batch) : batch.stream().map(e -> "'" + e + "'").collect(Collectors.joining(","));
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("AND ");
                    sb.append((CharSequence)this.buildIncludeCondition(queryInfo.isOracle, isRegexSql, str, queryInfo.columnName));
                    if (isTableGroupNoSysSql || ObjectType.ROLE.equals((Object)queryInfo.objectType) || ObjectType.OBJ_USER.equals((Object)queryInfo.objectType)) {
                        batchSqls.add(MessageFormat.format(queryInfo.pattern, sb));
                        continue;
                    }
                    if (ObjectType.SYNONYM.equals((Object)queryInfo.objectType)) {
                        batchSqls.add(MessageFormat.format(queryInfo.pattern, quotedName, quotedName, sb));
                        continue;
                    }
                    batchSqls.add(MessageFormat.format(queryInfo.pattern, quotedName, sb));
                }
                isRegexSql = !isRegexSql;
            }
        }
        boolean isNeedSysConnection = ObjectType.TABLE_GROUP.equals((Object)queryInfo.objectType) && !isTableGroupNoSysSql;
        for (String sql : batchSqls) {
            Connection conn = isNeedSysConnection ? this.sessionManager.getPooledSysConnection() : this.sessionManager.getPooledBizConnection();
            Object object = null;
            try {
                option.getAllowedObjectMap().computeIfAbsent(queryInfo.objectType, v -> new HashSet()).addAll(JdbcExecutor.queryList(conn, sql, rs -> {
                    ArrayList<String> objectList = new ArrayList<String>(16);
                    while (rs.next()) {
                        String colName = !queryInfo.isOracle && ObjectType.TABLE.equals((Object)queryInfo.objectType) ? "TABLE_NAME" : "OBJECT_NAME";
                        objectList.add(rs.getString(colName));
                    }
                    return objectList;
                }));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (conn == null) continue;
                if (object != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                conn.close();
            }
        }
        if (CollectionUtils.isNotEmpty(specifiedObjectNames)) {
            specifiedObjectNames.removeAll((Collection)option.getAllowedObjectMap().get((Object)queryInfo.objectType));
            if (CollectionUtils.isNotEmpty(specifiedObjectNames)) {
                Iterator iter = specifiedObjectNames.iterator();
                while (iter.hasNext()) {
                    String objectName = (String)iter.next();
                    if (!objectName.contains("*")) {
                        log.warn("Ignore the {}: {} that doesn't exists in the schema", (Object)queryInfo.objectType.getName(), (Object)objectName);
                    }
                    iter.remove();
                }
            }
        }
    }

    private void queryTableNameMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.getServerMode().isOracleMode();
        String pattern = isOracle ? ORACLE_TABLE_NAME_QUERY_SQL : MYSQL_TABLE_NANE_QUERY_SQL;
        String conditionStr = isOracle ? "OBJECT_NAME" : "TABLE_NAME";
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.TABLE, pattern, database.getSchemaName(), conditionStr));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TABLE))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.TABLE.getName(), (Object)database.getSchemaName());
        }
    }

    private void queryViewInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.getServerMode().isOracleMode();
        String pattern = isOracle ? QUERY_VIEW_PATTERN_ORACLE : QUERY_VIEW_PATTERN_MYSQL;
        String conditionStr = isOracle ? "VIEW_NAME" : "TABLE_NAME";
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.VIEW, pattern, database.getSchemaName(), conditionStr));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.VIEW))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.VIEW.getName(), (Object)database.getSchemaName());
        }
    }

    protected void queryTableGroupInfoMap(Database database, ConnectionKey connectionKey, AdvancedOption option, boolean hasNoSysPrivilege) throws Exception {
        String pattern;
        boolean isOracle = database.isOracleMode();
        String placeHolderValue = "";
        if (hasNoSysPrivilege || database.isSubsequentV4()) {
            pattern = isOracle ? QUERY_TABLE_GROUP_PATTERN_NO_SYS_ORACLE : QUERY_TABLE_GROUP_PATTERN_NO_SYS_MYSQL;
        } else {
            pattern = connectionKey.getServerMode().isPrevious("2.2") ? QUERY_TABLE_GROUP_PATTERN_V1 : QUERY_TABLE_GROUP_PATTERN_V2;
            placeHolderValue = connectionKey.getTenant();
        }
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.TABLE_GROUP, pattern, placeHolderValue, "tablegroup_name"));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.TABLE_GROUP))) {
            log.warn("No {} are exist in the tenant: \"{}\"", (Object)ObjectType.TABLE_GROUP.getName(), (Object)connectionKey.getTenant());
        }
    }

    private void querySequenceInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.isOracleMode();
        if (!isOracle && database.getServerMode().isPreviousV3230()) {
            return;
        }
        String pattern = isOracle ? QUERY_SEQUENCE_PATTERN_ORACLE : QUERY_SEQUENCE_PATTERN_MYSQL;
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.SEQUENCE, pattern, database.getSchemaName(), "SEQUENCE_NAME"));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.SEQUENCE))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.SEQUENCE.getName(), (Object)database.getSchemaName());
        }
    }

    private void queryFunctionInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.isOracleMode();
        String pattern = isOracle ? QUERY_FUNCTION_PATTERN_ORACLE : QUERY_FUNCTION_PATTERN_MYSQL;
        String conditionStr = isOracle ? "OBJECT_NAME" : "ROUTINE_NAME";
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.FUNCTION, pattern, database.getSchemaName(), conditionStr));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.FUNCTION))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.FUNCTION.getName(), (Object)database.getSchemaName());
        }
    }

    private void queryProcedureInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.isOracleMode();
        String pattern = isOracle ? QUERY_PROCEDURE_PATTERN_ORACLE : QUERY_PROCEDURE_PATTERN_MYSQL;
        String conditionStr = isOracle ? "OBJECT_NAME" : "ROUTINE_NAME";
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.PROCEDURE, pattern, database.getSchemaName(), conditionStr));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.PROCEDURE))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.PROCEDURE.getName(), (Object)database.getSchemaName());
        }
    }

    private void queryObjUserInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.isOracleMode();
        String pattern = isOracle ? QUERY_OBJ_USER_PATTERN_ORACLE : QUERY_OBJ_USER_PATTERN_MYSQL;
        String conditionStr = isOracle ? "USERNAME" : "OBJECT_NAME";
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.OBJ_USER, pattern, database.getSchemaName(), conditionStr));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.OBJ_USER))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.OBJ_USER.getName(), (Object)database.getSchemaName());
        }
    }

    private void queryRoleInfoMap(Database database, AdvancedOption option) throws Exception {
        boolean isOracle = database.isOracleMode();
        this.queryObjectInfoMap(database.getServerMode(), option, new ObjectTypeQueryInfo(isOracle, ObjectType.ROLE, QUERY_ROLE_PATTERN, database.getSchemaName(), "ROLE"));
        if (CollectionUtils.isEmpty((Collection)option.getAllowedObjectMap().get((Object)ObjectType.ROLE))) {
            log.warn("No {} were found in \"{}\"", (Object)ObjectType.ROLE.getName(), (Object)database.getSchemaName());
        }
    }

    @Override
    public Map<String, List<String>> queryUniqueKeyMap(ServerMode serverMode, String schemaName, String tableName) throws Exception {
        log.info("Querying unique key for table \"{}\"...", (Object)tableName);
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            String sql = ServerMode.MYSQL.equals((Object)serverMode) ? GET_UNIQUEKEY_OBMYSQL : GET_UNIQUEKEY_OBORACLE;
            Object[] args = new Object[]{schemaName, tableName};
            Map map = JdbcExecutor.query(conn, sql, args, rs -> {
                LinkedHashMap<String, List> uniqueKeyMap = new LinkedHashMap<String, List>(8);
                while (rs.next()) {
                    uniqueKeyMap.computeIfAbsent(rs.getString(3), v -> new ArrayList()).add(rs.getString(1));
                }
                return uniqueKeyMap;
            });
            return map;
        }
    }

    @Override
    public Map<String, List<String>> queryNonNullUniqueKeyMap(ServerMode serverMode, String schemaName, String tableName) throws Exception {
        if (serverMode.isOracleMode()) {
            Preconditions.checkState((this.metaCache != null ? 1 : 0) != 0, (Object)"The `metaCache` has not been initialized");
            return this.metaCache.getObOracleTableUkCache().map(m -> m.getOrDefault(tableName, new HashMap())).orElse(new HashMap());
        }
        log.info("Querying unique key(with non-null columns) for table \"{}\"...", (Object)tableName);
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{schemaName, tableName};
            Map map = JdbcExecutor.query(conn, GET_NOT_NULL_UNIQUEKEY_OBMYSQL, args, rs -> {
                LinkedHashMap<String, List> uniqueKeyMap = new LinkedHashMap<String, List>(8);
                while (rs.next()) {
                    uniqueKeyMap.computeIfAbsent(rs.getString(3), v -> new ArrayList()).add(StringUtils.unquoteColumnIdentifier(rs.getString(1), serverMode));
                }
                return uniqueKeyMap;
            });
            return map;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RowKey> queryRowKeys(ServerMode serverMode, String tenantName, long tableId) throws SQLException {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            String sql = serverMode.isPrevious("2.2") ? GET_ROWKEY_SQL21 : GET_ROWKEY_SQL22;
            Object[] args = new Object[]{tenantName, tableId};
            List<RowKey> list = JdbcExecutor.queryList(conn, sql, args, rs -> {
                ArrayList<RowKey> rowKeys = new ArrayList<RowKey>(8);
                while (rs.next()) {
                    rowKeys.add(new RowKey(rs.getString(1), rs.getInt(2), rs.getInt(3)));
                }
                return rowKeys;
            });
            return list;
        }
        catch (Exception e) {
            log.error("Query row keys failed. tenant: {}, table: {}", new Object[]{tenantName, tableId, e});
            return Lists.newArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, List<String>> queryMacroRangeMap(Map<Long, String> leaderLocationMap, long tableId, long version) throws Exception {
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(leaderLocationMap), (String)"Leader location map is empty. table id: %s", (long)tableId);
        HashSet<String> serverParameters = new HashSet<String>(leaderLocationMap.values());
        Map<String, String> serverMap = this.queryServerPort(serverParameters);
        HashMap leaderServer2Locations = new HashMap();
        leaderLocationMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue)).forEach((k, v) -> {
            List value = leaderServer2Locations.computeIfAbsent(k, i -> new ArrayList());
            value.addAll(v.stream().filter(e -> {
                if (e.getValue() == null) {
                    log.error("The leader location is null. table id: {}, partition id: {}", (Object)tableId, e.getKey());
                    return false;
                }
                return true;
            }).map(e -> {
                String[] locations = ((String)e.getValue()).split(":");
                StringBuilder parameter = new StringBuilder(64);
                parameter.append("(partition_id='").append(e.getKey()).append("'");
                parameter.append(" AND svr_ip='").append(locations[0]).append("'");
                parameter.append(" AND svr_port=").append((String)serverMap.get(e.getValue())).append(")");
                return parameter;
            }).collect(Collectors.toList()));
        });
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(leaderServer2Locations), (String)"Can't find leader location. table id: %s", (long)tableId);
        long size = leaderServer2Locations.values().stream().mapToLong(Collection::size).sum();
        if ((long)leaderLocationMap.size() != size) {
            log.error("There are {} partition's leader location is missing ....", (Object)((long)leaderLocationMap.size() - size));
        }
        ThreadPoolExecutor queryMacroRangeExecutor = new ThreadPoolExecutor(leaderServer2Locations.size(), leaderServer2Locations.size(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("query-macro-range-"));
        try {
            ExecutorCompletionService<Map> completionService = new ExecutorCompletionService<Map>(queryMacroRangeExecutor);
            ArrayList builders = new ArrayList(leaderServer2Locations.entrySet());
            for (int i = 1; i < builders.size(); ++i) {
                Map.Entry item = (Map.Entry)builders.get(i);
                completionService.submit(() -> this.doQueryMacroRangeMap(tableId, version, (String)item.getKey(), (List)item.getValue()));
            }
            HashMap<Long, List<String>> res = new HashMap<Long, List<String>>(this.doQueryMacroRangeMap(tableId, version, (String)((Map.Entry)builders.get(0)).getKey(), (List)((Map.Entry)builders.get(0)).getValue()));
            for (int i = 1; i < builders.size(); ++i) {
                res.putAll((Map)completionService.take().get());
            }
            HashMap<Long, List<String>> hashMap = res;
            return hashMap;
        }
        finally {
            queryMacroRangeExecutor.shutdownNow();
        }
    }

    private Map<Long, List<String>> doQueryMacroRangeMap(long tableId, long frozenVersion, String leaderServer, List<StringBuilder> parameters) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("Begin to query macro range...");
        StringBuilder wherePrefix = new StringBuilder(64);
        wherePrefix.append("table_id='").append(tableId).append("' AND data_version='").append(frozenVersion).append("' AND ");
        ArrayList<StringBuilder> whereClauses = new ArrayList<StringBuilder>();
        for (List list : Lists.partition(parameters, (int)200)) {
            StringBuilder whereClause = new StringBuilder(1024);
            whereClause.append((CharSequence)wherePrefix).append("(").append(String.join((CharSequence)" OR ", list)).append(")");
            whereClauses.add(whereClause);
        }
        HashMap<Long, List<String>> macroRangeMap = new HashMap<Long, List<String>>();
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            for (StringBuilder whereClause : whereClauses) {
                macroRangeMap.putAll(JdbcExecutor.queryMap(conn, GET_MACRO_RANGE_SQL + whereClause, rs -> {
                    HashMap<Long, List> partitionMacroMap = new HashMap<Long, List>();
                    while (rs.next()) {
                        Long partitionId = rs.getLong("partition_id");
                        String macroRange = rs.getString("macro_range");
                        partitionMacroMap.computeIfAbsent(partitionId, v -> new ArrayList()).add(macroRange);
                    }
                    return partitionMacroMap;
                }));
            }
        }
        log.info("Query macro range succeed. server: {}, table id: {}, version: {}, partition count: {}, Elapsed: {}", new Object[]{leaderServer, tableId, frozenVersion, parameters.size(), stopwatch});
        return macroRangeMap;
    }

    private Map<String, String> queryServerPort(Set<String> serverParameters) throws Exception {
        String whereClause = serverParameters.stream().map(serverParameter -> {
            String[] locations = serverParameter.split(":");
            return "(svr_ip='" + locations[0] + "' AND inner_port=" + locations[1] + ")";
        }).collect(Collectors.joining(" OR "));
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            String sql = GET_SERVER_PORT_SQL + whereClause;
            HashMap serverMap = new HashMap();
            Map map = JdbcExecutor.query(conn, sql, rs -> {
                while (rs.next()) {
                    String svrIp = rs.getString("svr_ip");
                    String svrPort = rs.getString("svr_port");
                    String innerPort = rs.getString("inner_port");
                    serverMap.put(svrIp + ":" + innerPort, svrPort);
                }
                return serverMap;
            });
            return map;
        }
    }

    @Override
    public List<String> queryObOracleIndexNames(String schemaName, String tableName) {
        Preconditions.checkState((this.metaCache != null ? 1 : 0) != 0, (Object)"The `meta cache` has not been initialized");
        Optional<Map<String, List<String>>> idxCacheOptional = this.metaCache.getObOracleTableIdxCache();
        Preconditions.checkState((boolean)idxCacheOptional.isPresent(), (Object)"The index names cache has not been initialized");
        return idxCacheOptional.map(m -> m.getOrDefault(tableName, new ArrayList())).orElseGet(Lists::newArrayList);
    }

    private List<String> buildQueryTableMetadataSqls(Database database, Collection<String> specifiedTables, Collection<String> excludedTables, boolean isTemporaryTableExcluded) {
        String schemaName = database.getSchemaName();
        ServerMode serverMode = database.getServerMode();
        boolean isOracle = serverMode.isOracleMode();
        String template = null;
        template = isOracle ? (serverMode.isPreviousV4() ? ORACLE_TABLE_META_QUERY_SQL_V3 : ORACLE_TABLE_META_QUERY_SQL_V4) : (serverMode.isPrevious("2.2.73") ? MYSQL_TABLE_META_QUERY_SQL1 : MYSQL_TABLE_META_QUERY_SQL2);
        ArrayList<String> batchSqls = new ArrayList<String>();
        if (CollectionUtils.isEmpty(specifiedTables)) {
            StringBuilder sb = new StringBuilder(256);
            if (CollectionUtils.isNotEmpty(excludedTables)) {
                sb.append("AND ").append(SqlUtils.buildExcludeCondition(excludedTables, serverMode, "C.TABLE_NAME"));
            }
            if (isTemporaryTableExcluded) {
                sb.append(" AND O.TEMPORARY='N' ");
                log.info("Temporary tables will export table definitions but not meaningless table data.");
            }
            batchSqls.add(MessageFormat.format(template, "'" + schemaName + "'", sb));
        } else {
            if (CollectionUtils.isNotEmpty(excludedTables)) {
                List<Set<String>> excludeTableNames = DBUtils.splitObjectNames(excludedTables);
                if (!excludeTableNames.get(0).isEmpty()) {
                    for (String table : excludeTableNames.get(0)) {
                        specifiedTables.removeIf(s -> s.matches(table));
                    }
                }
                if (!excludeTableNames.get(1).isEmpty()) {
                    specifiedTables.removeAll((Collection)excludeTableNames.get(1));
                }
            }
            List<Set<String>> objectNameSets = DBUtils.splitObjectNames(specifiedTables);
            boolean isRegexSql = true;
            for (Set<String> objectNames : objectNameSets) {
                for (List batch : Lists.partition((List)Lists.newArrayList(objectNames), (int)128)) {
                    String str = isRegexSql ? String.join((CharSequence)"|", batch) : batch.stream().map(e -> "'" + e + "'").collect(Collectors.joining(","));
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("AND ");
                    sb.append((CharSequence)this.buildIncludeCondition(isOracle, isRegexSql, str, "C.TABLE_NAME"));
                    if (isTemporaryTableExcluded) {
                        sb.append(" AND O.TEMPORARY='N' ");
                    }
                    batchSqls.add(MessageFormat.format(template, "'" + schemaName + "'", sb));
                }
                isRegexSql = false;
            }
        }
        return batchSqls;
    }

    private StringBuilder buildIncludeCondition(boolean isOracleMode, boolean isRegexSql, String regex, String columnName) {
        StringBuilder sb = new StringBuilder(128);
        if (isRegexSql) {
            if (isOracleMode) {
                sb.append("regexp_like(").append(columnName).append(",");
            } else {
                sb.append(columnName).append(" regexp(");
            }
            return sb.append("'").append(regex).append("'").append(")");
        }
        return sb.append(columnName).append(" IN (").append(regex).append(")");
    }

    private ColumnInfo extractColumnInfo(ResultSet rs, AdvancedOption option, boolean isOracle, boolean includeAllColumns) throws Exception {
        boolean isVirtualColumn;
        LiteralDataTypeFactory factory = new LiteralDataTypeFactory(rs.getString("DATA_TYPE").toLowerCase(Locale.getDefault()));
        factory.setPrecision(rs.getInt("DATETIME_PRECISION"));
        String columnName = rs.getString("COLUMN_NAME");
        if (!isOracle) {
            columnName = StringUtils.isEmpty(columnName) ? columnName : columnName.toLowerCase();
        }
        int columnPosition = rs.getInt("COLUMN_POSITION");
        boolean nullable = rs.getString("NULLABLE").startsWith("Y");
        boolean bl = isVirtualColumn = !includeAllColumns;
        isVirtualColumn = isOracle ? (isVirtualColumn &= "YES".equalsIgnoreCase(rs.getString("VIRTUAL_COLUMN"))) : (isVirtualColumn &= StringUtils.isNotEmpty(rs.getString("GENERATION_EXPRESSION")));
        if (isVirtualColumn && option.isExcludeVirtualColumns()) {
            return null;
        }
        ColumnInfo columnInfo = new ColumnInfo(columnName, factory.generate(), nullable, columnPosition);
        columnInfo.setVirtual(isVirtualColumn);
        return columnInfo;
    }

    private Map<String, TableInfo> buildTableInfoMap(ServerMode serverMode, String schemaName, AdvancedOption option, Map<String, LinkedHashMap<String, ColumnInfo>> tableColumnMap) {
        boolean isMySqlMode = ServerMode.MYSQL.equals((Object)serverMode);
        HashMap tableTypeHandlerMap = Maps.newHashMap();
        tableColumnMap.forEach((tableName, tableValue) -> {
            Map typeHandlerMap = tableTypeHandlerMap.computeIfAbsent(tableName, v -> Maps.newConcurrentMap());
            tableValue.forEach((k, v) -> typeHandlerMap.put(k, TypeHandlerFactory.createTypeHandler(v.getDataType(), isMySqlMode, option)));
            if (option.isHiddenPrimaryKeyEnabled()) {
                typeHandlerMap.put("__pk_increment", new BigIntegerTypeHandler());
            }
        });
        HashMap<String, LinkedHashMap<String, ColumnInfo>> allColumnInfoMap = new HashMap<String, LinkedHashMap<String, ColumnInfo>>(tableColumnMap);
        this.filterTableColumns(tableColumnMap, option);
        Map<String, Map<String, MapObject>> columnNameMap = option.getColumnNameMapping();
        HashMap<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>(tableColumnMap.size());
        for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> entry : tableColumnMap.entrySet()) {
            String tableName2 = entry.getKey();
            Map columnInfoMap = tableColumnMap.get(tableName2);
            Map columnIndexMap = columnNameMap.getOrDefault(tableName2, new LinkedHashMap());
            if (MapUtils.isNotEmpty((Map)columnIndexMap)) {
                for (Map.Entry e : columnInfoMap.entrySet()) {
                    if (!columnIndexMap.containsKey(e.getKey())) continue;
                    ((MapObject)columnIndexMap.get(e.getKey())).setTarget(((ColumnInfo)e.getValue()).getColumnPosition());
                }
            }
            ArrayList allColumnInfoList = new ArrayList(((LinkedHashMap)allColumnInfoMap.get(tableName2)).values());
            Map<String, DataType> allColumnTypeMap = allColumnInfoList.stream().collect(Collectors.toMap(ColumnInfo::getColumnName, ColumnInfo::getDataType));
            Map typeHandlerMap = (Map)tableTypeHandlerMap.get(tableName2);
            TableInfo tableInfo = new TableInfo(serverMode, schemaName, tableName2, columnInfoMap, columnIndexMap, typeHandlerMap, option.isDumpOperation());
            tableInfo.setAllColumnTypeMap(allColumnTypeMap);
            tableInfo.setHiddenPrimaryKeyEnabled(option.isHiddenPrimaryKeyEnabled());
            tableInfo.setExcludeVirtualColumns(option.isExcludeVirtualColumns());
            tableInfoMap.putIfAbsent(tableName2, tableInfo);
        }
        if (option.isShouldFilterEmptyTables()) {
            this.markEmptyTables(serverMode.isOracleMode(), tableInfoMap);
        }
        return tableInfoMap;
    }

    private void filterTableColumns(Map<String, LinkedHashMap<String, ColumnInfo>> tableColumnMap, AdvancedOption option) {
        Set<String> columnWhitelist = option.getIncludeColumnNames();
        Set<String> columnBlackList = option.getExcludeColumnNames();
        Set<String> typeBlackList = option.getExcludeDataTypes();
        if (CollectionUtils.isEmpty(columnWhitelist) && CollectionUtils.isEmpty(columnBlackList) && CollectionUtils.isEmpty(typeBlackList)) {
            return;
        }
        HashMap tempTableColumnMap = new HashMap();
        if (CollectionUtils.isNotEmpty(columnWhitelist)) {
            for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> e : tableColumnMap.entrySet()) {
                LinkedHashMap<String, ColumnInfo> currMap = e.getValue();
                LinkedHashMap<String, ColumnInfo> tempMap = new LinkedHashMap<String, ColumnInfo>();
                for (String columnName : columnWhitelist) {
                    if (!currMap.containsKey(columnName)) continue;
                    tempMap.put(columnName, currMap.get(columnName));
                }
                tempTableColumnMap.putIfAbsent(e.getKey(), tempMap);
            }
        } else {
            tableColumnMap.forEach((tableName, columnMap) -> {
                LinkedHashMap tempMap = new LinkedHashMap();
                columnMap.entrySet().stream().filter(e -> !columnBlackList.contains(e.getKey()) && !typeBlackList.contains(((ColumnInfo)e.getValue()).getDataType().getDataTypeName())).forEach(e -> {
                    ColumnInfo cfr_ignored_0 = (ColumnInfo)tempMap.put(e.getKey(), e.getValue());
                });
                tempTableColumnMap.putIfAbsent((String)tableName, tempMap);
            });
        }
        tableColumnMap.clear();
        tableColumnMap.putAll(tempTableColumnMap);
    }

    public AbstractMetadataProvider() {
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private static class ObjectTypeQueryInfo {
        private final boolean isOracle;
        private final ObjectType objectType;
        private final String pattern;
        private final String placeHolderValue;
        private final String columnName;

        public ObjectTypeQueryInfo(boolean isOracle, ObjectType objectType, String pattern, String placeHolderValue, String columnName) {
            this.isOracle = isOracle;
            this.objectType = objectType;
            this.pattern = pattern;
            this.placeHolderValue = placeHolderValue;
            this.columnName = columnName;
        }
    }
}

