/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.metadata;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.MergeStatus;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.metadata.AbstractMetadataProvider;
import com.oceanbase.tools.loaddump.common.model.LoadStatus;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProviderV3
extends AbstractMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(MetadataProviderV3.class);
    private static final String GET_FROZEN_TIME = "select value as frozen_time from oceanbase.__all_zone where name='frozen_time'";
    private static final String GET_FROZEN_VERSION = "select value as frozen_version from oceanbase.__all_zone where name='frozen_version'";
    private static final String GET_LATEST_MERGED_VERSION_SQL = "SELECT value FROM oceanbase.__all_zone WHERE name='last_merged_version' and zone=''";
    private static final String GET_MERGE_STATUS_SQL = "SELECT value FROM oceanbase.__all_zone WHERE name='merge_status' and zone=''";
    private static final String LATEST_MERGED_TIME_QUERY = "select max(value) from oceanbase.__all_zone where name='last_merged_time' group by zone";
    static final String GET_DATABASE_CREATE_TIME = "select d.gmt_create as create_time from oceanbase.__all_virtual_database d,oceanbase.__all_tenant t where d.tenant_id=t.tenant_id and t.tenant_name=? and d.database_name=?";
    static final String SERVER_STATUS_QUERY = "select m.ip,s.inner_port,m.total/m.mem_limit,z.value from gv$memstore m,__all_tenant t,__all_zone z,__all_server s where t.tenant_name=? and m.tenant_id=t.tenant_id and s.zone=z.zone and s.svr_ip=m.ip and s.svr_port=m.port and z.name='is_merging'";
    static final String GET_PRIMARY_KEY_OBMYSQL = "SELECT K.COLUMN_NAME AS COLUMN_NAME, K.ORDINAL_POSITION-1 AS POSITION  FROM information_schema.TABLE_CONSTRAINTS C,information_schema.KEY_COLUMN_USAGE AS K WHERE C.TABLE_SCHEMA=K.TABLE_SCHEMA AND C.TABLE_NAME=K.TABLE_NAME AND  C.CONSTRAINT_SCHEMA=K.CONSTRAINT_SCHEMA AND C.CONSTRAINT_NAME=K.CONSTRAINT_NAME AND  C.TABLE_SCHEMA=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='PRIMARY KEY' ORDER BY K.ORDINAL_POSITION ASC";
    static final String GET_PRIMARY_KEY_OBORACLE = "SELECT T.QUALIFIED_COL_NAME AS COLUMN_NAME, O.POSITION-1 AS POSITION  FROM ALL_CONSTRAINTS C LEFT JOIN ALL_CONS_COLUMNS O ON C.OWNER=O.OWNER AND C.TABLE_NAME=O.TABLE_NAME AND C.CONSTRAINT_NAME=O.CONSTRAINT_NAME  LEFT JOIN ALL_INDEXES I ON C.OWNER=I.OWNER AND C.TABLE_NAME=I.TABLE_NAME AND C.INDEX_NAME=I.INDEX_NAME INNER JOIN ALL_TAB_COLS T  ON O.OWNER=T.OWNER AND O.TABLE_NAME=T.TABLE_NAME AND O.COLUMN_NAME=T.COLUMN_NAME AND T.HIDDEN_COLUMN='NO'  WHERE C.OWNER=? AND C.TABLE_NAME=? AND C.CONSTRAINT_TYPE='P' ORDER BY O.CONSTRAINT_NAME, O.POSITION ASC";

    public MetadataProviderV3(SessionManager sessionManager) {
        super(sessionManager);
    }

    @Override
    public Map<String, LoadStatus> queryObserverLoad(ServerMode serverMode, String tenantName) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            Object[] args = new Object[]{tenantName};
            Map<String, LoadStatus> map = JdbcExecutor.queryMap(conn, SERVER_STATUS_QUERY, args, rs -> {
                HashMap<String, LoadStatus> loadStatusMap = new HashMap<String, LoadStatus>(16);
                while (rs.next()) {
                    String address = rs.getString(1) + ":" + rs.getString(2);
                    LoadStatus loadStatus = new LoadStatus(rs.getInt(4) == 1, rs.getDouble(3));
                    loadStatus.setLeaderServer(address);
                    loadStatusMap.put(address, loadStatus);
                }
                return loadStatusMap;
            });
            return map;
        }
    }

    @Override
    public long queryFrozenVersion(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            long l = JdbcExecutor.query(conn, GET_FROZEN_VERSION, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public long queryFrozenTime(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            long l = JdbcExecutor.query(conn, GET_FROZEN_TIME, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public long queryLatestMergedVersion(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            long l = JdbcExecutor.query(conn, GET_LATEST_MERGED_VERSION_SQL, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public MergeStatus queryMergeStatus(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            MergeStatus mergeStatus = JdbcExecutor.query(conn, GET_MERGE_STATUS_SQL, rs -> rs.next() ? MergeStatus.getByCode(rs.getLong(1)) : null);
            return mergeStatus;
        }
    }

    @Override
    public long queryLatestMergedTime(ServerMode serverMode) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            long l = JdbcExecutor.query(conn, LATEST_MERGED_TIME_QUERY, rs -> rs.next() ? rs.getLong(1) : 0L);
            return l;
        }
    }

    @Override
    public String queryDatabaseCreateTime(ServerMode serverMode, String tenantName, String schemaName) throws Exception {
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            Object[] args = new Object[]{tenantName, schemaName};
            String string = JdbcExecutor.query(conn, GET_DATABASE_CREATE_TIME, args, rs -> rs.next() ? Constants.DEFAULT_DATETIME_FORMATTER.format(rs.getTimestamp(1).toLocalDateTime()) : null);
            return string;
        }
    }

    @Override
    public List<String> queryPrimaryKeyList(ServerMode serverMode, String schemaName, String tableName) throws Exception {
        if (serverMode.isOracleMode()) {
            Preconditions.checkState((this.metaCache != null ? 1 : 0) != 0, (Object)"The `metaCache` has not been initialized");
            return this.metaCache.getObOracleTablePkCache().map(m -> m.getOrDefault(tableName, new ArrayList())).orElse(new ArrayList());
        }
        log.info("Querying primary key for table \"{}\"...", (Object)tableName);
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{schemaName, tableName};
            List<String> list = JdbcExecutor.queryList(conn, GET_PRIMARY_KEY_OBMYSQL, args, rs -> {
                ArrayList<String> primaryCols = new ArrayList<String>();
                while (rs.next()) {
                    primaryCols.add(rs.getString(1));
                }
                return primaryCols;
            });
            return list;
        }
    }

    public MetadataProviderV3() {
    }
}

