/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DumpParameter
extends BaseParameter {
    private final Set<Integer> includeColumnIndex = new HashSet<Integer>();
    private Integer maxRows;
    private String querySql;
    private String outputFile;
    private boolean noNestedDir;
    private String whereClause;
    private String flashbackScn;
    private Set<String> partitions;
    private String flashbackTimestamp;
    private boolean distinct = false;
    private boolean snapshot = true;
    private boolean weakRead = false;
    private boolean skipCheckDir = false;
    private boolean removeNewline = false;
    private boolean retainEmptyFiles = false;
    private boolean excludeVirtualColumns = false;
    private int parallelMacros = 8;
    private int pageSize = 1000000;
    private int commitSize = 2000;
    private long maxFileSize = -1048576L;
    private boolean retainSchema = true;
    private boolean withExtra = false;
    private boolean droppable = false;
    private boolean useRuntimeTableName = false;
    private String blockSizeUnit = "MB";
    private String timeValuePattern = "";
    private String datetimeValuePattern = "";
    private String timestampTzValuePattern = "";
    private String timestampLtzValuePattern = "";
    private String dateValuePattern = "";
    private String timestampValuePattern = "";
    private UploadBehavior uploadBehavior;
    private int fetchSize;
    private boolean preserveZeroDatetime;
    private boolean compactSchema;
    private String ckptPath;
    private boolean failOnNoTaskToProceed;
    private String sequencePolicy = "preserve";

    public String getCheckpointPath() {
        if (this.ckptPath != null) {
            return this.ckptPath;
        }
        this.ckptPath = FileUtils.toPath(this.getTmpPath(), ".dump.ckpt");
        return this.ckptPath;
    }

    @Override
    public String getDefaultDatabasePath() {
        Preconditions.checkArgument((this.getDatabaseName() != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        Preconditions.checkArgument((this.getStorageConfig() != null ? 1 : 0) != 0, (Object)"storage config has not been set yet");
        if (this.noNestedDir) {
            return this.getStorageConfig().getPath();
        }
        return FileUtils.toPath(this.getDataPath(), super.getDatabaseName()) + File.separator;
    }

    @Override
    public String getDefaultTableDataPath() {
        Preconditions.checkArgument((super.getDatabaseName() != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        if (this.noNestedDir || StringUtils.isNotEmpty(this.outputFile)) {
            return this.getFilePath();
        }
        return FileUtils.toPath(this.getDataPath(), super.getDatabaseName(), ObjectType.TABLE.getName()) + File.separator;
    }

    public void removeFinishedObjectTypes(Collection<ObjectType> unfinishedObjectTypes) {
        if (CollectionUtils.isEmpty(unfinishedObjectTypes)) {
            return;
        }
        Iterator<Map.Entry<ObjectType, Set<String>>> iterator = this.getWhiteListMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ObjectType, Set<String>> next = iterator.next();
            if (unfinishedObjectTypes.contains((Object)next.getKey())) continue;
            iterator.remove();
        }
    }

    public void removeFinishedTables(Collection<String> unfinishedTables) {
        if (CollectionUtils.isEmpty(unfinishedTables)) {
            return;
        }
        Iterator<Map.Entry<String, TableInfo>> iterator = this.getDatabase().getTableInfoMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TableInfo> next = iterator.next();
            if (unfinishedTables.contains(next.getKey())) continue;
            iterator.remove();
        }
        this.getDatabase().getTableNames().retainAll(unfinishedTables);
    }

    public Set<Integer> getIncludeColumnIndex() {
        return this.includeColumnIndex;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isNoNestedDir() {
        return this.noNestedDir;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }

    public String getFlashbackTimestamp() {
        return this.flashbackTimestamp;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public boolean isWeakRead() {
        return this.weakRead;
    }

    public boolean isSkipCheckDir() {
        return this.skipCheckDir;
    }

    public boolean isRemoveNewline() {
        return this.removeNewline;
    }

    public boolean isRetainEmptyFiles() {
        return this.retainEmptyFiles;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    public int getParallelMacros() {
        return this.parallelMacros;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean isRetainSchema() {
        return this.retainSchema;
    }

    public boolean isWithExtra() {
        return this.withExtra;
    }

    public boolean isDroppable() {
        return this.droppable;
    }

    public boolean isUseRuntimeTableName() {
        return this.useRuntimeTableName;
    }

    public String getBlockSizeUnit() {
        return this.blockSizeUnit;
    }

    public String getTimeValuePattern() {
        return this.timeValuePattern;
    }

    public String getDatetimeValuePattern() {
        return this.datetimeValuePattern;
    }

    public String getTimestampTzValuePattern() {
        return this.timestampTzValuePattern;
    }

    public String getTimestampLtzValuePattern() {
        return this.timestampLtzValuePattern;
    }

    public String getDateValuePattern() {
        return this.dateValuePattern;
    }

    public String getTimestampValuePattern() {
        return this.timestampValuePattern;
    }

    public UploadBehavior getUploadBehavior() {
        return this.uploadBehavior;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isPreserveZeroDatetime() {
        return this.preserveZeroDatetime;
    }

    public boolean isCompactSchema() {
        return this.compactSchema;
    }

    public String getCkptPath() {
        return this.ckptPath;
    }

    public boolean isFailOnNoTaskToProceed() {
        return this.failOnNoTaskToProceed;
    }

    public String getSequencePolicy() {
        return this.sequencePolicy;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setNoNestedDir(boolean noNestedDir) {
        this.noNestedDir = noNestedDir;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setFlashbackScn(String flashbackScn) {
        this.flashbackScn = flashbackScn;
    }

    public void setPartitions(Set<String> partitions) {
        this.partitions = partitions;
    }

    public void setFlashbackTimestamp(String flashbackTimestamp) {
        this.flashbackTimestamp = flashbackTimestamp;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public void setWeakRead(boolean weakRead) {
        this.weakRead = weakRead;
    }

    public void setSkipCheckDir(boolean skipCheckDir) {
        this.skipCheckDir = skipCheckDir;
    }

    public void setRemoveNewline(boolean removeNewline) {
        this.removeNewline = removeNewline;
    }

    public void setRetainEmptyFiles(boolean retainEmptyFiles) {
        this.retainEmptyFiles = retainEmptyFiles;
    }

    public void setExcludeVirtualColumns(boolean excludeVirtualColumns) {
        this.excludeVirtualColumns = excludeVirtualColumns;
    }

    public void setParallelMacros(int parallelMacros) {
        this.parallelMacros = parallelMacros;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setRetainSchema(boolean retainSchema) {
        this.retainSchema = retainSchema;
    }

    public void setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
    }

    public void setDroppable(boolean droppable) {
        this.droppable = droppable;
    }

    public void setUseRuntimeTableName(boolean useRuntimeTableName) {
        this.useRuntimeTableName = useRuntimeTableName;
    }

    public void setBlockSizeUnit(String blockSizeUnit) {
        this.blockSizeUnit = blockSizeUnit;
    }

    public void setTimeValuePattern(String timeValuePattern) {
        this.timeValuePattern = timeValuePattern;
    }

    public void setDatetimeValuePattern(String datetimeValuePattern) {
        this.datetimeValuePattern = datetimeValuePattern;
    }

    public void setTimestampTzValuePattern(String timestampTzValuePattern) {
        this.timestampTzValuePattern = timestampTzValuePattern;
    }

    public void setTimestampLtzValuePattern(String timestampLtzValuePattern) {
        this.timestampLtzValuePattern = timestampLtzValuePattern;
    }

    public void setDateValuePattern(String dateValuePattern) {
        this.dateValuePattern = dateValuePattern;
    }

    public void setTimestampValuePattern(String timestampValuePattern) {
        this.timestampValuePattern = timestampValuePattern;
    }

    public void setUploadBehavior(UploadBehavior uploadBehavior) {
        this.uploadBehavior = uploadBehavior;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPreserveZeroDatetime(boolean preserveZeroDatetime) {
        this.preserveZeroDatetime = preserveZeroDatetime;
    }

    public void setCompactSchema(boolean compactSchema) {
        this.compactSchema = compactSchema;
    }

    public void setCkptPath(String ckptPath) {
        this.ckptPath = ckptPath;
    }

    public void setFailOnNoTaskToProceed(boolean failOnNoTaskToProceed) {
        this.failOnNoTaskToProceed = failOnNoTaskToProceed;
    }

    public void setSequencePolicy(String sequencePolicy) {
        this.sequencePolicy = sequencePolicy;
    }
}

