/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.model.Progress;

public class DumpProgress
extends Progress {
    private final int totalMergeTaskCount;
    private final int finishedMergeTaskCount;

    public DumpProgress(int finished, int running, double progress, int totalMergeTaskCount, int finishedMergeTaskCount) {
        super(finished, running, progress);
        this.totalMergeTaskCount = totalMergeTaskCount;
        this.finishedMergeTaskCount = finishedMergeTaskCount;
    }

    @Override
    public String toString() {
        if (this.totalMergeTaskCount > 0) {
            return String.format("----------\tFinished Tasks: %d\tRunning Tasks: %d\tProgress: %.2f%%\tFinished File Merge Tasks: %d\tRunning File Merge Tasks: %d\t----------", this.getFinished(), this.getRunning(), this.getProgress(), this.finishedMergeTaskCount, this.totalMergeTaskCount - this.finishedMergeTaskCount);
        }
        return String.format("----------\tFinished Tasks: %d\tRunning Tasks: %d\tProgress: %.2f%%\t----------", this.getFinished(), this.getRunning(), this.getProgress());
    }

    public int getTotalMergeTaskCount() {
        return this.totalMergeTaskCount;
    }

    public int getFinishedMergeTaskCount() {
        return this.finishedMergeTaskCount;
    }
}

