/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SqlContext;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public class Insertion
implements Serializable {
    private static final long serialVersionUID = -3924066851740506161L;
    private long partitionId;
    private boolean retry;
    private boolean commit;
    private Mode mode = Mode.BATCH;
    private boolean retried;
    private SqlContext sqlContext;
    private long byteSize;
    private SubFile subFile;
    private String leaderServer;
    private List<Record> recordList;
    private List<String> fieldNameList;
    private List<String> fullColumnNameList;

    public Insertion(SubFile subFile, long partitionId, boolean isShouldRetry) {
        this.subFile = subFile;
        this.retry = isShouldRetry;
        this.partitionId = partitionId;
    }

    public String getSchema() {
        return this.getSubFile().getSchemaName();
    }

    public String getTable() {
        return this.getSubFile().getObjectName();
    }

    public int getRecordCount() {
        return Optional.ofNullable(this.getRecordList()).map(List::size).orElse(0);
    }

    public void clearAll() {
        this.byteSize = 0L;
        this.retry = false;
        this.retried = false;
        this.mode = Mode.BATCH;
        if (this.sqlContext != null) {
            this.sqlContext.clearAll();
            this.sqlContext = null;
        }
        if (this.recordList != null) {
            for (Record record : this.recordList) {
                record.clearAll();
            }
            this.recordList.clear();
            this.recordList = null;
        }
        if (this.fullColumnNameList != null) {
            this.fullColumnNameList = null;
        }
        if (this.fieldNameList != null) {
            this.fieldNameList = null;
        }
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public void setSqlContext(SqlContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public void setSubFile(SubFile subFile) {
        this.subFile = subFile;
    }

    public void setLeaderServer(String leaderServer) {
        this.leaderServer = leaderServer;
    }

    public void setRecordList(List<Record> recordList) {
        this.recordList = recordList;
    }

    public void setFieldNameList(List<String> fieldNameList) {
        this.fieldNameList = fieldNameList;
    }

    public void setFullColumnNameList(List<String> fullColumnNameList) {
        this.fullColumnNameList = fullColumnNameList;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isRetried() {
        return this.retried;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public SubFile getSubFile() {
        return this.subFile;
    }

    public String getLeaderServer() {
        return this.leaderServer;
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public List<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public List<String> getFullColumnNameList() {
        return this.fullColumnNameList;
    }

    public Insertion() {
    }

    public static enum Mode {
        SERIAL,
        BATCH;

    }
}

