/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.CompatMode;
import com.oceanbase.tools.loaddump.common.enums.DirectLoadType;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import org.apache.hadoop.fs.FileStatus;

public class LoadParameter
extends BaseParameter {
    private boolean failFast = true;
    private FileStatus inputFile;
    private boolean ignoreUnhex;
    private boolean ignoreEscape;
    private boolean skipFooter = false;
    private int batchSize;
    private boolean external = false;
    private int maxErrors = 1000;
    private int maxDiscards = 1000;
    private boolean strict = true;
    private boolean deleteable;
    private boolean truncatable;
    private boolean yesConfirm;
    private boolean replaceObjectIfExists;
    private boolean replaceData;
    protected String fileNameRegExp;
    private int tpsLimit = Integer.MAX_VALUE;
    private int bufferSize;
    private double readWriteRatio = 1.0;
    private double slowInsertThreshold = 0.75;
    private double pauseInsertThreshold = 0.85;
    private long maxWaitTimeMillis = 10800000L;
    private boolean directMode = false;
    private DirectLoadType directLoadType;
    private int rpcPort;
    private CompatMode compatMode;
    private String ckptPath;
    private boolean canWrite = true;
    @Deprecated
    private String defaultDateValue;
    @Deprecated
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";

    @Override
    public String getDataPath() {
        return this.isExternal() ? super.getFilePath() : super.getDataPath();
    }

    public String getCheckpointPath() {
        if (this.ckptPath != null) {
            return this.ckptPath;
        }
        this.ckptPath = FileUtils.toPath(this.getTmpPath(), ".load.ckpt");
        return this.ckptPath;
    }

    public boolean enablePartitionCalculation() {
        return JavaOpts.enablePartitionCalculation != null ? JavaOpts.enablePartitionCalculation : true;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public FileStatus getInputFile() {
        return this.inputFile;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public boolean isIgnoreEscape() {
        return this.ignoreEscape;
    }

    @Override
    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isExternal() {
        return this.external;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDeleteable() {
        return this.deleteable;
    }

    public boolean isTruncatable() {
        return this.truncatable;
    }

    public boolean isYesConfirm() {
        return this.yesConfirm;
    }

    public boolean isReplaceObjectIfExists() {
        return this.replaceObjectIfExists;
    }

    public boolean isReplaceData() {
        return this.replaceData;
    }

    public String getFileNameRegExp() {
        return this.fileNameRegExp;
    }

    public int getTpsLimit() {
        return this.tpsLimit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public double getReadWriteRatio() {
        return this.readWriteRatio;
    }

    public double getSlowInsertThreshold() {
        return this.slowInsertThreshold;
    }

    public double getPauseInsertThreshold() {
        return this.pauseInsertThreshold;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTimeMillis;
    }

    public boolean isDirectMode() {
        return this.directMode;
    }

    public DirectLoadType getDirectLoadType() {
        return this.directLoadType;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public CompatMode getCompatMode() {
        return this.compatMode;
    }

    public String getCkptPath() {
        return this.ckptPath;
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }

    @Deprecated
    public String getDefaultDateValue() {
        return this.defaultDateValue;
    }

    @Deprecated
    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setInputFile(FileStatus inputFile) {
        this.inputFile = inputFile;
    }

    public void setIgnoreUnhex(boolean ignoreUnhex) {
        this.ignoreUnhex = ignoreUnhex;
    }

    public void setIgnoreEscape(boolean ignoreEscape) {
        this.ignoreEscape = ignoreEscape;
    }

    @Override
    public void setSkipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setMaxDiscards(int maxDiscards) {
        this.maxDiscards = maxDiscards;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    public void setTruncatable(boolean truncatable) {
        this.truncatable = truncatable;
    }

    public void setYesConfirm(boolean yesConfirm) {
        this.yesConfirm = yesConfirm;
    }

    public void setReplaceObjectIfExists(boolean replaceObjectIfExists) {
        this.replaceObjectIfExists = replaceObjectIfExists;
    }

    public void setReplaceData(boolean replaceData) {
        this.replaceData = replaceData;
    }

    public void setFileNameRegExp(String fileNameRegExp) {
        this.fileNameRegExp = fileNameRegExp;
    }

    public void setTpsLimit(int tpsLimit) {
        this.tpsLimit = tpsLimit;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setReadWriteRatio(double readWriteRatio) {
        this.readWriteRatio = readWriteRatio;
    }

    public void setSlowInsertThreshold(double slowInsertThreshold) {
        this.slowInsertThreshold = slowInsertThreshold;
    }

    public void setPauseInsertThreshold(double pauseInsertThreshold) {
        this.pauseInsertThreshold = pauseInsertThreshold;
    }

    public void setMaxWaitTimeMillis(long maxWaitTimeMillis) {
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    public void setDirectMode(boolean directMode) {
        this.directMode = directMode;
    }

    public void setDirectLoadType(DirectLoadType directLoadType) {
        this.directLoadType = directLoadType;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void setCompatMode(CompatMode compatMode) {
        this.compatMode = compatMode;
    }

    public void setCkptPath(String ckptPath) {
        this.ckptPath = ckptPath;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    @Deprecated
    public void setDefaultDateValue(String defaultDateValue) {
        this.defaultDateValue = defaultDateValue;
    }

    @Deprecated
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

