/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import java.text.NumberFormat;

public class LoadStatus {
    public volatile boolean merging;
    public volatile double memUsedRatio;
    private String leaderServer = "0.0.0.0";
    private volatile double slowInsertThreshold = 0.75;
    private volatile double pauseInsertThreshold = 0.85;

    public LoadStatus(boolean merging, double memUsedRatio) {
        this.merging = merging;
        this.memUsedRatio = memUsedRatio;
    }

    public LoadStatus(double slowThreshold, double pauseThreshold) {
        this(false, slowThreshold, pauseThreshold);
    }

    public LoadStatus(boolean merging, double slowThreshold, double pauseThreshold) {
        this.merging = merging;
        this.memUsedRatio = 0.0;
        this.slowInsertThreshold = Math.min(slowThreshold, 0.75);
        this.pauseInsertThreshold = Math.min(pauseThreshold, 0.85);
    }

    public String getMemUsedPercent() {
        return NumberFormat.getPercentInstance().format(this.getMemUsedRatio());
    }

    public LoadMode getLoadMode() {
        double memUsedRatio = this.getMemUsedRatio();
        if (Double.valueOf(0.0).equals(memUsedRatio)) {
            return LoadMode.INIT;
        }
        if (memUsedRatio >= this.getPauseInsertThreshold()) {
            return LoadMode.PAUSE;
        }
        if (this.isMerging() || memUsedRatio >= this.getSlowInsertThreshold()) {
            return LoadMode.SLOW;
        }
        return LoadMode.FAST;
    }

    public String toString() {
        return "Leader Server: " + this.leaderServer + ", Merging: " + this.merging + ", Mem Used Ratio: " + this.memUsedRatio + ", Slow Threshold: " + this.slowInsertThreshold + ", Pause Threshold: " + this.pauseInsertThreshold + ", Load Mode: " + (Object)((Object)this.getLoadMode());
    }

    public void setMerging(boolean merging) {
        this.merging = merging;
    }

    public void setMemUsedRatio(double memUsedRatio) {
        this.memUsedRatio = memUsedRatio;
    }

    public void setLeaderServer(String leaderServer) {
        this.leaderServer = leaderServer;
    }

    public void setSlowInsertThreshold(double slowInsertThreshold) {
        this.slowInsertThreshold = slowInsertThreshold;
    }

    public void setPauseInsertThreshold(double pauseInsertThreshold) {
        this.pauseInsertThreshold = pauseInsertThreshold;
    }

    public boolean isMerging() {
        return this.merging;
    }

    public double getMemUsedRatio() {
        return this.memUsedRatio;
    }

    public String getLeaderServer() {
        return this.leaderServer;
    }

    public double getSlowInsertThreshold() {
        return this.slowInsertThreshold;
    }

    public double getPauseInsertThreshold() {
        return this.pauseInsertThreshold;
    }

    public static enum LoadMode {
        INIT,
        FAST,
        SLOW,
        PAUSE;


        public boolean isInit() {
            return INIT.equals((Object)this);
        }
    }
}

