/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import java.io.File;
import java.io.Serializable;

public class Manifest
implements Serializable {
    private static final long serialVersionUID = 8847250684181983061L;
    private static final String MANIFEST_FILE = ".MANIFEST.bin";
    private static final String MANIFEST_FILE_COMPAT = "MANIFEST.bin";
    private String root;
    private DataFormat dataFormat;
    private Character escapeCharacter;
    private char columnDelimiter;
    private char columnSeparator;
    private String lineSeparator;
    private String nullString;
    private String emptyString;
    private boolean skipHeader;
    private boolean ignoreEmptyLine;

    public Manifest(BaseParameter parameter) {
        this.root = parameter.getTmpPath();
        this.skipHeader = parameter.isSkipHeader();
        this.dataFormat = parameter.getDataFormat();
        this.nullString = parameter.getNullString();
        this.emptyString = parameter.getEmptyString();
        this.lineSeparator = parameter.getLineSeparator();
        this.ignoreEmptyLine = parameter.isIgnoreEmptyLine();
        this.columnDelimiter = parameter.getColumnDelimiter().charValue();
        this.escapeCharacter = parameter.getEscapeCharacter();
        this.columnSeparator = parameter.getColumnSeparator().charValue();
    }

    public String toPath() {
        return FileUtils.toPath(this.getRoot(), MANIFEST_FILE);
    }

    public String toPathCompat() {
        String compatPath = FileUtils.toPath(this.getRoot(), MANIFEST_FILE);
        if (new File(compatPath).exists()) {
            return compatPath;
        }
        return FileUtils.toPath(this.getRoot(), MANIFEST_FILE_COMPAT);
    }

    public void replaceTo(BaseParameter parameter) throws Exception {
        Manifest origin = (Manifest)SerializeUtils.deserializeObjectByKryo(this.toPathCompat());
        if (origin == null) {
            return;
        }
        this.dataFormat = origin.getDataFormat();
        this.nullString = origin.getNullString();
        this.emptyString = origin.getEmptyString();
        this.lineSeparator = origin.getLineSeparator();
        this.ignoreEmptyLine = origin.isIgnoreEmptyLine();
        this.columnDelimiter = origin.getColumnDelimiter();
        this.escapeCharacter = origin.getEscapeCharacter();
        this.columnSeparator = origin.getColumnSeparator();
        parameter.setColumnDelimiter(Character.valueOf(this.getColumnDelimiter()));
        parameter.setEscapeCharacter(this.getEscapeCharacter());
        parameter.setColumnSeparator(Character.valueOf(this.getColumnSeparator()));
        if (this.getNullString() != null) {
            parameter.setNullString(this.getNullString());
        }
        if (this.getEmptyString() != null) {
            parameter.setEmptyString(this.getEmptyString());
        }
        parameter.setLineSeparator(this.getLineSeparator());
        parameter.setIgnoreEmptyLine(this.isIgnoreEmptyLine());
        if (parameter instanceof LoadParameter) {
            LoadParameter lp = (LoadParameter)parameter;
            if (lp.isExternal()) {
                if (parameter.isRetry()) {
                    parameter.setSkipHeader(origin.isSkipHeader());
                    this.skipHeader = origin.isSkipHeader();
                } else {
                    this.skipHeader = parameter.isSkipHeader();
                }
            } else {
                parameter.setSkipHeader(!origin.isSkipHeader());
                this.skipHeader = origin.isSkipHeader();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnDelimiter;
        result = 31 * result + this.columnSeparator;
        result = 31 * result + (this.dataFormat == null ? 0 : this.dataFormat.hashCode());
        result = 31 * result + (this.emptyString == null ? 0 : this.emptyString.hashCode());
        result = 31 * result + this.escapeCharacter.charValue();
        result = 31 * result + (this.ignoreEmptyLine ? 1231 : 1237);
        result = 31 * result + (this.lineSeparator == null ? 0 : this.lineSeparator.hashCode());
        result = 31 * result + (this.nullString == null ? 0 : this.nullString.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.skipHeader ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Manifest other = (Manifest)obj;
        if (this.columnDelimiter != other.columnDelimiter) {
            return false;
        }
        if (this.columnSeparator != other.columnSeparator) {
            return false;
        }
        if (this.dataFormat != other.dataFormat) {
            return false;
        }
        if (this.emptyString == null ? other.emptyString != null : !this.emptyString.equals(other.emptyString)) {
            return false;
        }
        if (this.escapeCharacter != other.escapeCharacter) {
            return false;
        }
        if (this.ignoreEmptyLine != other.ignoreEmptyLine) {
            return false;
        }
        if (this.lineSeparator == null ? other.lineSeparator != null : !this.lineSeparator.equals(other.lineSeparator)) {
            return false;
        }
        if (this.nullString == null ? other.nullString != null : !this.nullString.equals(other.nullString)) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        return this.skipHeader == other.skipHeader;
    }

    public Manifest() {
    }

    public String getRoot() {
        return this.root;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getNullString() {
        return this.nullString;
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public boolean isIgnoreEmptyLine() {
        return this.ignoreEmptyLine;
    }
}

