/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.model.TaskState;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class ObjectStatus
implements Serializable {
    private static final long serialVersionUID = 1028654516639472029L;
    private String schema;
    private String type;
    private String name;
    private AtomicLong total;
    private AtomicLong count;
    private Status status;

    public ObjectStatus() {
        this(null, new AtomicLong(0L), new AtomicLong(0L), Status.INITIAL);
    }

    public ObjectStatus(String objectName, String objectType, AtomicLong totalCount, AtomicLong objectCount, TaskState taskState) {
        this.name = objectName;
        this.type = objectType;
        this.total = totalCount;
        this.count = objectCount;
        this.status = taskState == TaskState.SUCCESS ? Status.SUCCESS : Status.FAILURE;
    }

    public ObjectStatus(String objectType, String schemaName, String objectName, long objectCount) {
        this(objectType, schemaName, objectName, objectCount, Status.SUCCESS);
    }

    public ObjectStatus(String objectType, String schemaName, String objectName, long objectCount, Status status) {
        this.type = objectType;
        this.schema = schemaName;
        this.name = objectName;
        this.total = new AtomicLong(objectCount);
        this.count = new AtomicLong(objectCount);
        this.status = status;
    }

    public ObjectStatus(String objectName, AtomicLong totalCount, AtomicLong objectCount, Status status) {
        this.name = objectName;
        this.total = totalCount;
        this.count = objectCount;
        this.status = status;
    }

    public void and(TaskState state) {
        if (this.status == Status.FAILURE) {
            return;
        }
        if (state == TaskState.FAILURE) {
            this.status = Status.FAILURE;
        } else if (state == TaskState.SUCCESS) {
            this.status = Status.SUCCESS;
        }
    }

    public void addTotal(long count) {
        this.total.addAndGet(count);
    }

    public void addCount(long count) {
        this.count.addAndGet(count);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AtomicLong getTotal() {
        return this.total;
    }

    public void setTotal(AtomicLong total) {
        this.total = total;
    }

    public AtomicLong getCount() {
        return this.count;
    }

    public void setCount(AtomicLong count) {
        this.count = count;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum Status {
        INITIAL,
        SUCCESS,
        FAILURE;

    }
}

