/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.lmax.disruptor.RingBuffer;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.Record;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class Payload {
    private RingBuffer<Insertion> ringBuffer;
    private long byteSize = 0L;
    private List<Record> recordList = new ArrayList<Record>();

    public Payload(@NonNull Insertion insertion) {
        this(insertion, null);
        if (insertion == null) {
            throw new NullPointerException("insertion is marked non-null but is null");
        }
    }

    public Payload(@NonNull Insertion insertion, RingBuffer<Insertion> ringBuffer) {
        if (insertion == null) {
            throw new NullPointerException("insertion is marked non-null but is null");
        }
        this.ringBuffer = ringBuffer;
        this.byteSize = insertion.getByteSize();
        this.recordList = insertion.getRecordList();
    }

    public void reset() {
        this.recordList = new ArrayList<Record>();
        this.byteSize = 0L;
    }

    public int getRecordCount() {
        return this.recordList.size();
    }

    public Payload addByteSize(long byteSize) {
        this.byteSize += byteSize;
        return this;
    }

    public Payload addRecord(@NonNull Record record) {
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        this.recordList.add(record);
        return this;
    }

    public RingBuffer<Insertion> getRingBuffer() {
        return this.ringBuffer;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public Payload() {
    }
}

